/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public class AzimuthalEquidistantTest {
    @Test
    public void toWKT() throws Exception {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"unnamed\", GEOGCS[\"unnamed ellipse\", DATUM[\"unknown\", SPHEROID[\"unnamed\",6370841.391468334,0]], PRIMEM[\"Greenwich\",0], UNIT[\"degree\",0.0174532925199433]], PROJECTION[\"Azimuthal_Equidistant\"], PARAMETER[\"latitude_of_center\",42.42], PARAMETER[\"longitude_of_center\",16.16], PARAMETER[\"false_easting\",100000], PARAMETER[\"false_northing\",200000],UNIT[\"metre\", 1, AUTHORITY[\"EPSG\",\"9001\"]]]");
        String wkt = crs.toWKT();
        Assert.assertTrue((boolean)wkt.contains("PROJECTION[\"Azimuthal_Equidistant\"]"));
        Assert.assertTrue((boolean)wkt.contains("PARAMETER[\"latitude_of_center\", 42.42]"));
        Assert.assertTrue((boolean)wkt.contains("PARAMETER[\"longitude_of_center\", 16.16]"));
        Assert.assertTrue((boolean)wkt.contains("PARAMETER[\"false_easting\", 100000.0]"));
        Assert.assertTrue((boolean)wkt.contains("PARAMETER[\"false_northing\", 200000.0]"));
    }

    @Test
    public void testLegacyProjectionParameters() throws Exception {
        CoordinateReferenceSystem azeq = CRS.parseWKT((String)"PROJCS[\"Azeq test\", GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295], AUTHORITY[\"EPSG\",\"4326\"]], PROJECTION[\"Azimuthal Equidistant\"], PARAMETER[\"latitude_of_origin\", 42.56], PARAMETER[\"longitude_of_origin\", -71.43], PARAMETER[\"scale_factor\", 1.0], PARAMETER[\"false_easting\", 0.0], PARAMETER[\"false_northing\", 0.0], UNIT[\"m\", 1.0],  AUTHORITY[\"EPSG\",\"741002\"]]");
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)azeq, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Point2D out = AzimuthalEquidistantTest.doTransform(transform, new Point2D.Double(0.0, 0.0));
        Assert.assertEquals((double)-71.43, (double)out.getX(), (double)1.0E-4);
        Assert.assertEquals((double)42.56, (double)out.getY(), (double)1.0E-4);
        Point2D out2 = AzimuthalEquidistantTest.doTransform(transform.inverse(), out);
        Assert.assertEquals((double)0.0, (double)out2.getX(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)out2.getY(), (double)1.0E-4);
        Point2D point = AzimuthalEquidistantTest.doTransform(transform.inverse(), new Point2D.Double(20.0, 60.0));
        Assert.assertEquals((double)3740188.0147449127, (double)point.getX(), (double)1.0E-4);
        Assert.assertEquals((double)4831302.159548063, (double)point.getY(), (double)1.0E-4);
        byte[] serialized = SerializationUtils.serialize((Serializable)((Serializable)transform));
        MathTransform trans2 = (MathTransform)SerializationUtils.deserialize((byte[])serialized);
        Point2D point2 = AzimuthalEquidistantTest.doTransform(trans2.inverse(), new Point2D.Double(20.0, 60.0));
        Assert.assertEquals((double)3740188.0147449127, (double)point2.getX(), (double)1.0E-4);
        Assert.assertEquals((double)4831302.159548063, (double)point2.getY(), (double)1.0E-4);
    }

    @Test
    public void testAutoCode() throws Exception {
        CoordinateReferenceSystem azeq = CRS.decode((String)"AUTO:97003,9001,-71.43,42.56", (boolean)true);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)azeq, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Point2D point = AzimuthalEquidistantTest.doTransform(transform.inverse(), new Point2D.Double(20.0, 60.0));
        Assert.assertEquals((double)3740188.0147449127, (double)point.getX(), (double)1.0E-4);
        Assert.assertEquals((double)4831302.159548063, (double)point.getY(), (double)1.0E-4);
    }

    private static Point2D doTransform(MathTransform transform, Point2D point) {
        double[] output = new double[2];
        double[] input = new double[]{point.getX(), point.getY()};
        try {
            transform.transform(input, 0, output, 0, 1);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        return new Point2D.Double(output[0], output[1]);
    }

    @Test
    public void testReprojectAlongDateline() throws FactoryException, TransformException {
        CoordinateReferenceSystem crs = CRS.decode((String)"AUTO:97003,9001,170,-16", (boolean)true);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs);
        double[] src = new double[]{179.8, -11.0};
        double[] dst = new double[2];
        for (int i = 0; i < 40; ++i) {
            mt.transform(src, 0, dst, 0, 1);
            src[0] = src[0] + 0.1;
        }
    }
}

