/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.net.URI;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.NoSuchIdentifierException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.referencing.operation.transform.NADCONTransform;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NADCONTransformTest {
    private static final String STPAUL_LAS = "stpaul.las";
    private static final String STPAUL_LOS = "stpaul.los";
    private static final double TOLERANCE = 1.8E-6;
    private static final double[] TEST_POINT_SRC = new double[]{-170.25, 57.125};
    private static final double[] TEST_POINT_DST = new double[]{-170.252283, 57.125655};
    private NADCONTransform transform;

    @Before
    public void setUp() throws Exception {
        this.transform = new NADCONTransform(new URI(STPAUL_LAS), new URI(STPAUL_LOS));
    }

    @Test
    public void testGetSourceDimensions() {
        Assert.assertEquals((long)this.transform.getSourceDimensions(), (long)2L);
    }

    @Test
    public void testGetTargetDimensions() {
        Assert.assertEquals((long)this.transform.getTargetDimensions(), (long)2L);
    }

    @Test
    public void testGetParameterValues() {
        ParameterValueGroup pvg = this.transform.getParameterValues();
        Assert.assertEquals((Object)pvg.getDescriptor(), (Object)NADCONTransform.Provider.PARAMETERS);
        Assert.assertEquals((long)pvg.values().size(), (long)2L);
        Object value = pvg.parameter("Latitude difference file").getValue();
        Assert.assertTrue((boolean)(value instanceof URI));
        Assert.assertEquals((Object)value.toString(), (Object)STPAUL_LAS);
        value = pvg.parameter("Longitude difference file").getValue();
        Assert.assertTrue((boolean)(value instanceof URI));
        Assert.assertEquals((Object)value.toString(), (Object)STPAUL_LOS);
    }

    @Test
    public void testNADCONTransform() throws Exception {
        try {
            new NADCONTransform(null, null);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            // empty catch block
        }
    }

    @Test
    public void testInverse() throws TransformException {
        Assert.assertSame((Object)this.transform, (Object)this.transform.inverse().inverse());
        double[] p1 = new double[2];
        double[] p2 = new double[2];
        this.transform.inverse().transform(TEST_POINT_DST, 0, p1, 0, 1);
        this.transform.inverseTransform(TEST_POINT_DST, 0, p2, 0, 1);
        Assert.assertEquals((double)p1[0], (double)p2[0], (double)1.8E-6);
        Assert.assertEquals((double)p1[1], (double)p2[1], (double)1.8E-6);
    }

    @Test
    public void testTransform() throws TransformException {
        double[] p = new double[2];
        this.transform.transform(TEST_POINT_SRC, 0, p, 0, 1);
        Assert.assertEquals((double)p[0], (double)TEST_POINT_DST[0], (double)1.8E-6);
        Assert.assertEquals((double)p[1], (double)TEST_POINT_DST[1], (double)1.8E-6);
    }

    @Test
    public void testInverseTransform() throws TransformException {
        double[] p = new double[2];
        this.transform.inverseTransform(TEST_POINT_DST, 0, p, 0, 1);
        Assert.assertEquals((double)p[0], (double)TEST_POINT_SRC[0], (double)1.8E-6);
        Assert.assertEquals((double)p[1], (double)TEST_POINT_SRC[1], (double)1.8E-6);
    }
}

