/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.List;
import java.util.Random;
import org.geotools.api.geometry.Position;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.operation.builder.ExtendedPosition;
import org.geotools.referencing.operation.builder.Quadrilateral;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.builder.TriangulationException;
import org.geotools.referencing.operation.builder.TriangulationFactory;
import org.junit.Assert;
import org.junit.Test;

public final class TriangulationFactoryTest {
    @Test
    public void testTringulationFactory() {
        Position2D sp1 = new Position2D(10.0, 10.0);
        Position2D tp1 = new Position2D(10.0, 10.0);
        Position2D sp2 = new Position2D(20.0, 10.0);
        Position2D tp2 = new Position2D(20.0, 10.0);
        Position2D sp3 = new Position2D(20.0, 20.0);
        Position2D tp3 = new Position2D(20.0, 20.0);
        Position2D sp4 = new Position2D(10.0, 20.0);
        Position2D tp4 = new Position2D(10.0, 20.0);
        Position2D sp5 = new Position2D(14.0, 16.0);
        Position2D tp5 = new Position2D(14.0, 16.0);
        ExtendedPosition mtp1 = new ExtendedPosition((Position)sp1, (Position)tp1);
        ExtendedPosition mtp2 = new ExtendedPosition((Position)sp2, (Position)tp2);
        ExtendedPosition mtp3 = new ExtendedPosition((Position)sp3, (Position)tp3);
        ExtendedPosition mtp4 = new ExtendedPosition((Position)sp4, (Position)tp4);
        ExtendedPosition mtp5 = new ExtendedPosition((Position)sp5, (Position)tp5);
        Position[] vertices = new Position[]{mtp5};
        Quadrilateral quad = new Quadrilateral((Position)mtp1, (Position)mtp2, (Position)mtp3, (Position)mtp4);
        try {
            new TriangulationFactory(quad, vertices);
        }
        catch (TriangulationException triangulationException) {
            // empty catch block
        }
    }

    @Test
    public void testDelaunay() throws TriangulationException {
        Position2D leftDown = new Position2D(100.0, 100.0);
        Position2D rightDown = new Position2D(200.0, 100.0);
        Position2D rightTop = new Position2D(200.0, 250.0);
        Position2D leftTop = new Position2D(100.0, 250.0);
        Random randomCoord = new Random(872066443L);
        int number = 5;
        Position[] vertices = new Position[number];
        for (int i = 0; i < number; ++i) {
            double x = leftDown.x + randomCoord.nextDouble() * (rightDown.x - leftDown.x);
            double y = leftDown.y + randomCoord.nextDouble() * (leftTop.y - leftDown.y);
            vertices[i] = new Position2D(x, y);
        }
        Quadrilateral quad = new Quadrilateral((Position)leftDown, (Position)rightDown, (Position)rightTop, (Position)leftTop);
        TriangulationFactory trigfac = new TriangulationFactory(quad, vertices);
        List triangles = trigfac.getTriangulation();
        int j = 1;
        for (TINTriangle triangle : triangles) {
            for (j = 0; j < vertices.length; ++j) {
                Assert.assertFalse((boolean)triangle.getCircumCicle().contains(vertices[j]));
            }
        }
    }
}

