/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.junit.Assert;
import org.junit.Test;

public final class SouthOrientedTest {
    private static final double EPS = 1.0E-10;

    private static ProjectedCRS parseTransverseMercator(boolean methodSouth, boolean axisSouth, double northing) throws FactoryException {
        String method = methodSouth ? "Transverse Mercator (South Orientated)" : "Transverse Mercator";
        String axis = axisSouth ? "\"Southing\", SOUTH" : "\"Northing\", NORTH";
        return (ProjectedCRS)CRS.parseWKT((String)("PROJCS[\"South African Coordinate System zone 25\", GEOGCS[\"Cape\", DATUM[\"Cape\", SPHEROID[\"Clarke 1880 (Arc)\", 6378249.145, 293.4663077, AUTHORITY[\"EPSG\",\"7013\"]], TOWGS84[-136.0, -108.0, -292.0, 0.0, 0.0, 0.0, 0.0], AUTHORITY[\"EPSG\",\"6222\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Geodetic latitude\", NORTH], AXIS[\"Geodetic longitude\", EAST], AUTHORITY[\"EPSG\",\"4222\"]], PROJECTION[\"" + method + "\"], PARAMETER[\"central_meridian\", 25.0], PARAMETER[\"latitude_of_origin\", 0.0], PARAMETER[\"scale_factor\", 1.0], PARAMETER[\"false_easting\", 0.0], PARAMETER[\"false_northing\", " + northing + "], UNIT[\"m\", 1.0], AXIS[\"Westing\", WEST], AXIS[" + axis + "]]"));
    }

    @Test
    public void testTransverseMercator() throws FactoryException {
        ProjectedCRS north = SouthOrientedTest.parseTransverseMercator(false, false, 1000.0);
        Assert.assertEquals((Object)AxisDirection.WEST, (Object)north.getCoordinateSystem().getAxis(0).getDirection());
        Assert.assertEquals((Object)AxisDirection.NORTH, (Object)north.getCoordinateSystem().getAxis(1).getDirection());
        ProjectedCRS south = SouthOrientedTest.parseTransverseMercator(false, true, 1000.0);
        Assert.assertEquals((Object)AxisDirection.WEST, (Object)south.getCoordinateSystem().getAxis(0).getDirection());
        Assert.assertEquals((Object)AxisDirection.SOUTH, (Object)south.getCoordinateSystem().getAxis(1).getDirection());
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)north, (CoordinateReferenceSystem)south);
        Assert.assertTrue((boolean)(transform instanceof LinearTransform));
        Matrix matrix = ((LinearTransform)transform).getMatrix();
        SouthOrientedTest.assertDiagonal(matrix);
        Assert.assertFalse((boolean)matrix.isIdentity());
        Assert.assertEquals((String)"West direction should be unchanged. ", (double)1.0, (double)matrix.getElement(0, 0), (double)1.0E-10);
        Assert.assertEquals((String)"North-South direction should be reverted.", (double)-1.0, (double)matrix.getElement(1, 1), (double)1.0E-10);
        Assert.assertEquals((String)"No easting expected.", (double)0.0, (double)matrix.getElement(0, 2), (double)1.0E-10);
        Assert.assertEquals((String)"No northing expected.", (double)0.0, (double)matrix.getElement(1, 2), (double)1.0E-10);
        south = SouthOrientedTest.parseTransverseMercator(true, true, 1000.0);
        Assert.assertEquals((Object)AxisDirection.WEST, (Object)south.getCoordinateSystem().getAxis(0).getDirection());
        Assert.assertEquals((Object)AxisDirection.SOUTH, (Object)south.getCoordinateSystem().getAxis(1).getDirection());
        transform = CRS.findMathTransform((CoordinateReferenceSystem)north, (CoordinateReferenceSystem)south);
        Assert.assertTrue((boolean)(transform instanceof LinearTransform));
        matrix = ((LinearTransform)transform).getMatrix();
        SouthOrientedTest.assertDiagonal(matrix);
        Assert.assertFalse((boolean)matrix.isIdentity());
        Assert.assertEquals((String)"West direction should be unchanged. ", (double)1.0, (double)matrix.getElement(0, 0), (double)1.0E-10);
        Assert.assertEquals((String)"North-South direction should be reverted.", (double)-1.0, (double)matrix.getElement(1, 1), (double)1.0E-10);
        Assert.assertEquals((String)"No easting expected.", (double)0.0, (double)matrix.getElement(0, 2), (double)1.0E-10);
        Assert.assertEquals((String)"No northing expected.", (double)0.0, (double)matrix.getElement(1, 2), (double)1.0E-10);
        north = SouthOrientedTest.parseTransverseMercator(false, false, 3000.0);
        transform = CRS.findMathTransform((CoordinateReferenceSystem)north, (CoordinateReferenceSystem)south);
        Assert.assertTrue((boolean)(transform instanceof LinearTransform));
        matrix = ((LinearTransform)transform).getMatrix();
        Assert.assertFalse((boolean)matrix.isIdentity());
        Assert.assertEquals((String)"West direction should be unchanged. ", (double)1.0, (double)matrix.getElement(0, 0), (double)1.0E-10);
        Assert.assertEquals((String)"North-South direction should be reverted.", (double)-1.0, (double)matrix.getElement(1, 1), (double)1.0E-10);
        Assert.assertEquals((String)"No easting expected.", (double)0.0, (double)matrix.getElement(0, 2), (double)1.0E-10);
        Assert.assertEquals((String)"Northing expected.", (double)2000.0, (double)matrix.getElement(1, 2), (double)1.0E-10);
    }

    @Test
    public void testKrovak() throws FactoryException {
        String geoWKT = "GEOGCS[\"S-JTSK (Ferro)\", DATUM[\"S_JTSK_Ferro\", SPHEROID[\"Bessel 1841\", 6377397.155, 299.1528128], TOWGS84[570.8,85.7,462.8,4.998,1.587,5.261,3.56]], PRIMEM[\"Greenwich\",0], UNIT[\"degree\",0.0174532925199433]]";
        String prjWKT = "PROJCS[\"S-JTSK(Ferro) / krovak\", GEOGCS[\"S-JTSK (Ferro)\", DATUM[\"S_JTSK_Ferro\", SPHEROID[\"Bessel 1841\", 6377397.155, 299.1528128], TOWGS84[570.8,85.7,462.8,4.998,1.587,5.261,3.56]], PRIMEM[\"Greenwich\",0], UNIT[\"degree\",0.0174532925199433]], PROJECTION[\"Krovak\"], UNIT[\"metre\",1.0], AXIS[\"y\",WEST], AXIS[\"x\",SOUTH]]";
        CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)"GEOGCS[\"S-JTSK (Ferro)\", DATUM[\"S_JTSK_Ferro\", SPHEROID[\"Bessel 1841\", 6377397.155, 299.1528128], TOWGS84[570.8,85.7,462.8,4.998,1.587,5.261,3.56]], PRIMEM[\"Greenwich\",0], UNIT[\"degree\",0.0174532925199433]]");
        CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)"PROJCS[\"S-JTSK(Ferro) / krovak\", GEOGCS[\"S-JTSK (Ferro)\", DATUM[\"S_JTSK_Ferro\", SPHEROID[\"Bessel 1841\", 6377397.155, 299.1528128], TOWGS84[570.8,85.7,462.8,4.998,1.587,5.261,3.56]], PRIMEM[\"Greenwich\",0], UNIT[\"degree\",0.0174532925199433]], PROJECTION[\"Krovak\"], UNIT[\"metre\",1.0], AXIS[\"y\",WEST], AXIS[\"x\",SOUTH]]");
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        Assert.assertTrue((boolean)(transform instanceof ConcatenatedTransform));
        ConcatenatedTransform ct = (ConcatenatedTransform)transform;
        Assert.assertTrue((boolean)(ct.transform2 instanceof LinearTransform));
        Matrix matrix = ((LinearTransform)ct.transform2).getMatrix();
        SouthOrientedTest.assertDiagonal(matrix);
        Assert.assertEquals((String)"East-West direction should be reverted. ", (double)-1.0, (double)matrix.getElement(0, 0), (double)1.0E-10);
        Assert.assertEquals((String)"North-South direction should be reverted.", (double)-1.0, (double)matrix.getElement(1, 1), (double)1.0E-10);
        Assert.assertEquals((String)"No easting expected.", (double)0.0, (double)matrix.getElement(0, 2), (double)1.0E-10);
        Assert.assertEquals((String)"No northing expected.", (double)0.0, (double)matrix.getElement(1, 2), (double)1.0E-10);
    }

    private static void assertDiagonal(Matrix matrix) {
        int nrow = matrix.getNumRow();
        int ncol = matrix.getNumCol();
        for (int j = 0; j < nrow; ++j) {
            for (int i = 0; i < ncol; ++i) {
                if (i == j) continue;
                Assert.assertEquals((String)("row " + j + ", col " + i), (double)0.0, (double)matrix.getElement(j, i), (double)1.0E-10);
            }
        }
    }
}

