/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Set;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.AllAuthoritiesFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.junit.Assert;
import org.junit.Test;

public final class AllAuthoritiesFactoryTest {
    @Test
    public void testAuthorityCodes() throws FactoryException {
        AllAuthoritiesFactory all = AllAuthoritiesFactory.DEFAULT;
        Set codes = all.getAuthorityCodes(CoordinateReferenceSystem.class);
        Assert.assertFalse((boolean)codes.isEmpty());
        Assert.assertTrue((boolean)codes.contains("CRS:84"));
        Assert.assertTrue((codes.contains("AUTO:42001") || codes.contains("AUTO2:42001") ? 1 : 0) != 0);
    }

    @Test
    public void testCreateCRS() throws FactoryException {
        CRSAuthorityFactory auto = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"AUTO", null);
        CRSAuthorityFactory crs = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"CRS", null);
        AllAuthoritiesFactory all = AllAuthoritiesFactory.DEFAULT;
        CoordinateReferenceSystem actual = all.createCoordinateReferenceSystem("CRS:84");
        CoordinateReferenceSystem expected = crs.createCoordinateReferenceSystem("84");
        Assert.assertSame((Object)expected, (Object)actual);
        Assert.assertSame((Object)expected, (Object)all.createObject("CRS:84"));
        actual = all.createCoordinateReferenceSystem("AUTO:42001,0,0");
        expected = auto.createCoordinateReferenceSystem("42001,0,0");
        Assert.assertSame((Object)expected, (Object)actual);
        Assert.assertSame((Object)expected, (Object)all.createObject("AUTO:42001,0,0"));
        actual = all.createCoordinateReferenceSystem("CRS:27");
        expected = crs.createCoordinateReferenceSystem("27");
        Assert.assertSame((Object)expected, (Object)actual);
        Assert.assertSame((Object)expected, (Object)all.createObject("CRS:27"));
        try {
            all.createCoordinateReferenceSystem("84");
            Assert.fail((String)"Should not work without authority.");
        }
        catch (NoSuchAuthorityCodeException exception) {
            Assert.assertEquals((Object)"84", (Object)exception.getAuthorityCode());
        }
        try {
            all.createCoordinateReferenceSystem("FOO:84");
            Assert.fail((String)"Should not work with unknown authority.");
        }
        catch (NoSuchAuthorityCodeException exception) {
            Assert.assertEquals((Object)"FOO", (Object)exception.getAuthority());
        }
    }

    @Test
    public void testHttp() throws FactoryException {
        CRSAuthorityFactory crs = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"CRS", null);
        AllAuthoritiesFactory all = AllAuthoritiesFactory.DEFAULT;
        CoordinateReferenceSystem actual = all.createCoordinateReferenceSystem("http://www.opengis.net/gml/srs/CRS#84");
        CoordinateReferenceSystem expected = crs.createCoordinateReferenceSystem("84");
        Assert.assertSame((Object)expected, (Object)actual);
        actual = all.createCoordinateReferenceSystem("HTTP://WWW.OPENGIS.NET/GML/SRS/crs#84");
        Assert.assertSame((Object)expected, (Object)actual);
        actual = all.createCoordinateReferenceSystem("http://www.opengis.net/gml/srs/CRS.xml#84");
        Assert.assertSame((Object)expected, (Object)actual);
        try {
            all.createCoordinateReferenceSystem("http://www.dummy.net/gml/srs/CRS#84");
            Assert.fail((String)"Expected a NoSuchAuthorityCodeException");
        }
        catch (NoSuchAuthorityCodeException e) {
            Assert.assertEquals((Object)"http://www.dummy.net", (Object)e.getAuthority());
        }
        try {
            all.createCoordinateReferenceSystem("http://www.opengis.net/gml/dummy/CRS#84");
            Assert.fail((String)"Expected a NoSuchAuthorityCodeException");
        }
        catch (NoSuchAuthorityCodeException e) {
            Assert.assertEquals((Object)"http://www.opengis.net/gml/srs/", (Object)e.getAuthority());
        }
    }

    @Test
    public void testFind() throws FactoryException {
        AllAuthoritiesFactory all = AllAuthoritiesFactory.DEFAULT;
        IdentifiedObjectFinder finder = all.getIdentifiedObjectFinder(CoordinateReferenceSystem.class);
        finder.setFullScanAllowed(false);
        Assert.assertNull((String)"Should not find the CRS without a scan.", (Object)finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84));
        finder.setFullScanAllowed(true);
        IdentifiedObject find = finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84);
        Assert.assertNotNull((String)"With scan allowed, should find the CRS.", (Object)find);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)find, (Object)DefaultGeographicCRS.WGS84));
        Assert.assertSame((Object)all.createCoordinateReferenceSystem("CRS:84"), (Object)find);
        Assert.assertEquals((Object)"CRS:84", (Object)finder.findIdentifier((IdentifiedObject)DefaultGeographicCRS.WGS84));
    }
}

