/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.Map;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CSFactory;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.DatumFactory;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.datum.VerticalDatumType;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import si.uom.NonSI;
import si.uom.SI;

public final class Transform3DTest {
    private static Map<String, String> name(String name) {
        return Collections.singletonMap("name", name);
    }

    @Test
    public void testProjectedToGeocentric() throws FactoryException, TransformException {
        Hints hints = new Hints();
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory((Hints)hints);
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory((Hints)hints);
        DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory((Hints)hints);
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory((Hints)hints);
        CoordinateOperationFactory opFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        PrimeMeridian greenwichMeridian = datumFactory.createPrimeMeridian(Transform3DTest.name("Greenwich Meridian"), 0.0, NonSI.DEGREE_ANGLE);
        Ellipsoid wgs84Ellipsoid = datumFactory.createFlattenedSphere(Transform3DTest.name("WGS84 Ellipsoid"), 6378137.0, 298.257223563, SI.METRE);
        GeodeticDatum wgs84 = datumFactory.createGeodeticDatum(Transform3DTest.name("WGS84 Datum"), wgs84Ellipsoid, greenwichMeridian);
        VerticalDatum wgs84_height = datumFactory.createVerticalDatum(Transform3DTest.name("WGS84 Ellispoidal height"), VerticalDatumType.ELLIPSOIDAL);
        CoordinateSystemAxis x_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("X"), "X", AxisDirection.OTHER, SI.METRE);
        CoordinateSystemAxis y_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("Y"), "Y", AxisDirection.WEST, SI.METRE);
        CoordinateSystemAxis z_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("Z"), "Z", AxisDirection.NORTH, SI.METRE);
        CartesianCS world_cs = csFactory.createCartesianCS(Transform3DTest.name("Rendered Cartesian CS"), x_axis, z_axis, y_axis);
        GeocentricCRS output_crs = crsFactory.createGeocentricCRS(Transform3DTest.name("Output Cartesian CRS"), wgs84, world_cs);
        CoordinateSystemAxis latitude_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("Geodetic Latitude"), "lat", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        CoordinateSystemAxis longitude_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("Geodetic Longitude"), "lon", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        CoordinateSystemAxis northing_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("Northing"), "N", AxisDirection.NORTH, SI.METRE);
        CoordinateSystemAxis easting_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("Easting"), "E", AxisDirection.EAST, SI.METRE);
        CoordinateSystemAxis height_axis = csFactory.createCoordinateSystemAxis(Transform3DTest.name("Ellipsoidal height"), "Up", AxisDirection.UP, SI.METRE);
        EllipsoidalCS ellipsoidal_2d_cs = csFactory.createEllipsoidalCS(Transform3DTest.name("2D ellipsoidal"), longitude_axis, latitude_axis);
        EllipsoidalCS ellipsoidal_3d_cs = csFactory.createEllipsoidalCS(Transform3DTest.name("3D ellipsoidal"), longitude_axis, latitude_axis, height_axis);
        GeographicCRS geographic_2d_crs = crsFactory.createGeographicCRS(Transform3DTest.name("2D geographic CRS"), wgs84, ellipsoidal_2d_cs);
        GeographicCRS geographic_3d_crs = crsFactory.createGeographicCRS(Transform3DTest.name("3D geographic CRS"), wgs84, ellipsoidal_3d_cs);
        CartesianCS utm_cartesian_3d_cs = csFactory.createCartesianCS(Transform3DTest.name("UTM 3D Cartesian CS"), northing_axis, easting_axis, height_axis);
        CartesianCS utm_cartesian_2d_cs = csFactory.createCartesianCS(Transform3DTest.name("UTM 2D Cartesian CS"), northing_axis, easting_axis);
        VerticalCS utm_height_cs = csFactory.createVerticalCS(Transform3DTest.name("Height CS"), height_axis);
        VerticalCRS height_crs = crsFactory.createVerticalCRS(Transform3DTest.name("WGS84 Height CRS"), wgs84_height, utm_height_cs);
        int zone_num = 12;
        ParameterValueGroup parameters = mtFactory.getDefaultParameters("Transverse_Mercator");
        parameters.parameter("central_meridian").setValue(-111);
        parameters.parameter("latitude_of_origin").setValue(0.0);
        parameters.parameter("scale_factor").setValue(0.9996);
        parameters.parameter("false_easting").setValue(500000.0);
        parameters.parameter("false_northing").setValue(0.0);
        ProjectedCRS proj_2d = crsFactory.createProjectedCRS(Transform3DTest.name("WGS 84 / UTM Zone 12/ 2D"), geographic_2d_crs, (Conversion)new DefiningConversion("Transverse_Mercator", parameters), utm_cartesian_2d_cs);
        CompoundCRS compound_3d = crsFactory.createCompoundCRS(Transform3DTest.name("3D Compound WGS 84 / UTM Zone 12"), new CoordinateReferenceSystem[]{proj_2d, height_crs});
        double[] out1 = Transform3DTest.checkTransformation(opFactory.createOperation((CoordinateReferenceSystem)compound_3d, (CoordinateReferenceSystem)output_crs));
        ProjectedCRS proj_3d = crsFactory.createProjectedCRS(Transform3DTest.name("WGS 84 / UTM Zone 12/ 3D"), geographic_3d_crs, (Conversion)new DefiningConversion("Transverse_Mercator", parameters), utm_cartesian_3d_cs);
        double[] out2 = Transform3DTest.checkTransformation(opFactory.createOperation((CoordinateReferenceSystem)proj_3d, (CoordinateReferenceSystem)output_crs));
        int upper = out1.length;
        Assert.assertEquals((long)upper, (long)out2.length);
        for (int i = 0; i < upper; ++i) {
            Assert.assertEquals((double)out1[i], (double)out2[i], (double)1.0E-5);
        }
    }

    private static double[] checkTransformation(CoordinateOperation operation) throws TransformException {
        Assert.assertTrue((boolean)(operation.getSourceCRS() instanceof ProjectedCRS));
        Assert.assertTrue((boolean)(operation.getTargetCRS() instanceof GeocentricCRS));
        Assert.assertTrue((boolean)(operation.getTargetCRS().getCoordinateSystem() instanceof CartesianCS));
        MathTransform mt = operation.getMathTransform();
        double[] input = new double[]{41451.73, 572227.0, 0.0};
        double[] output = new double[input.length * 2];
        mt.transform(input, 0, output, 0, 1);
        input[2] = 10000.0;
        mt.transform(input, 0, output, input.length, 1);
        double distance = 0.0;
        for (int i = 0; i < input.length; ++i) {
            double delta = output[i] - output[input.length + i];
            distance += delta * delta;
        }
        distance = Math.sqrt(distance);
        Assert.assertEquals((String)"Distance", (double)10000.0, (double)distance, (double)1.0E-5);
        return output;
    }
}

