/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.composite;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.geotools.image.test.ImageAssert;
import org.geotools.renderer.composite.BlendComposite;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompositeTest {
    private static BufferedImage BKG;
    private static BufferedImage BKG2;
    private static BufferedImage MAP;
    private static BufferedImage MAP2;
    private String name;
    private Composite composite;

    public CompositeTest(String name, Composite composite) {
        this.name = name;
        this.composite = composite;
    }

    @BeforeClass
    public static void readSourceImages() throws Exception {
        BKG = ImageIO.read(CompositeTest.class.getResourceAsStream("test-data/bkg.png"));
        BKG2 = ImageIO.read(CompositeTest.class.getResourceAsStream("test-data/bkg2.png"));
        MAP = ImageIO.read(CompositeTest.class.getResourceAsStream("test-data/map.png"));
        MAP2 = ImageIO.read(CompositeTest.class.getResourceAsStream("test-data/map2.png"));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        result.add(new Object[]{"copy", AlphaComposite.getInstance(2)});
        result.add(new Object[]{"destination", AlphaComposite.getInstance(9)});
        result.add(new Object[]{"source-over", AlphaComposite.getInstance(3)});
        result.add(new Object[]{"destination-over", AlphaComposite.getInstance(4)});
        result.add(new Object[]{"source-in", AlphaComposite.getInstance(5)});
        result.add(new Object[]{"destination-in", AlphaComposite.getInstance(6)});
        result.add(new Object[]{"source-out", AlphaComposite.getInstance(7)});
        result.add(new Object[]{"destination-out", AlphaComposite.getInstance(8)});
        result.add(new Object[]{"source-atop", AlphaComposite.getInstance(10)});
        result.add(new Object[]{"destination-atop", AlphaComposite.getInstance(11)});
        result.add(new Object[]{"xor", AlphaComposite.getInstance(12)});
        result.add(new Object[]{"multiply", BlendComposite.MULTIPLY_COMPOSITE});
        result.add(new Object[]{"screen", BlendComposite.SCREEN_COMPOSITE});
        result.add(new Object[]{"overlay", BlendComposite.OVERLAY_COMPOSITE});
        result.add(new Object[]{"darken", BlendComposite.DARKEN_COMPOSITE});
        result.add(new Object[]{"lighten", BlendComposite.LIGHTEN_COMPOSITE});
        result.add(new Object[]{"color-dodge", BlendComposite.COLOR_DODGE_COMPOSITE});
        result.add(new Object[]{"color-burn", BlendComposite.COLOR_BURN_COMPOSITE});
        result.add(new Object[]{"hard-light", BlendComposite.HARD_LIGHT_COMPOSITE});
        result.add(new Object[]{"soft-light", BlendComposite.SOFT_LIGHT_COMPOSITE});
        result.add(new Object[]{"difference", BlendComposite.DIFFERENCE_COMPOSITE});
        result.add(new Object[]{"exclusion", BlendComposite.EXCLUSION_COMPOSITE});
        return result;
    }

    @Test
    public void testCompositeInteger1() throws Exception {
        BufferedImage bkg = this.convertImage(BKG, 2);
        BufferedImage map = this.convertImage(MAP, 2);
        BufferedImage blended = this.blend(bkg, map);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend1-" + this.name + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)0);
    }

    @Test
    public void testCompositeByte1() throws Exception {
        BufferedImage bkg = this.convertImage(BKG, 6);
        BufferedImage map = this.convertImage(MAP, 6);
        BufferedImage blended = this.blend(bkg, map);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend1-" + this.name + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)0);
    }

    @Test
    public void testCompositeInteger2() throws Exception {
        BufferedImage bkg2 = this.convertImage(BKG2, 2);
        BufferedImage map2 = this.convertImage(MAP2, 2);
        BufferedImage blended = this.blend(bkg2, map2);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend2-" + this.name + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)0);
    }

    @Test
    public void testCompositeByte2() throws Exception {
        BufferedImage bkg2 = this.convertImage(BKG2, 6);
        BufferedImage map2 = this.convertImage(MAP2, 6);
        BufferedImage blended = this.blend(bkg2, map2);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend2-" + this.name + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)0);
    }

    private BufferedImage blend(BufferedImage src, BufferedImage dst) {
        BufferedImage blend = new BufferedImage(src.getWidth(), dst.getWidth(), src.getType());
        Graphics2D graphics = (Graphics2D)blend.getGraphics();
        graphics.drawRenderedImage(src, new AffineTransform());
        graphics.setComposite(this.composite);
        graphics.drawRenderedImage(dst, new AffineTransform());
        graphics.dispose();
        return blend;
    }

    private BufferedImage convertImage(BufferedImage src, int imageType) {
        BufferedImage result = new BufferedImage(src.getWidth(), src.getHeight(), imageType);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.drawRenderedImage(src, new AffineTransform());
        graphics.dispose();
        return result;
    }
}

