/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.PropertyName;
import org.opengis.parameter.Parameter;

public class AttributeRenameFunction
extends FunctionExpressionImpl
implements RenderingTransformation {
    public static FunctionName NAME = new FunctionNameImpl("AttributeRename", FunctionNameImpl.parameter((String)"sourceAttribute", String.class), new Parameter[]{FunctionNameImpl.parameter((String)"targetAttribute", String.class), FunctionNameImpl.parameter((String)"optimizeQuery", Boolean.TYPE, (int)0, (int)1)});

    public AttributeRenameFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        String source = this.getAttribute(object, 0, String.class, true);
        String target = this.getAttribute(object, 1, String.class, true);
        SimpleFeatureCollection fc = (SimpleFeatureCollection)object;
        SimpleFeatureType sourceSchema = (SimpleFeatureType)fc.getSchema();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        for (AttributeDescriptor ad : sourceSchema.getAttributeDescriptors()) {
            if (ad.getLocalName().equals(source)) {
                tb.add(target, ad.getType().getBinding());
                continue;
            }
            tb.add(ad);
        }
        tb.setName(sourceSchema.getName());
        SimpleFeatureType targetSchema = tb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(targetSchema);
        ArrayList features = new ArrayList();
        try {
            fc.accepts(feature -> {
                fb.init((SimpleFeature)feature);
                SimpleFeature f = fb.buildFeature(feature.getIdentifier().getID());
                features.add(f);
            }, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to compute output collection", e);
        }
        return new ListFeatureCollection(targetSchema, features);
    }

    <T> T getAttribute(Object object, int expressionIdx, Class<T> targetClass, boolean mandatory) {
        try {
            Object result = this.getExpression(expressionIdx).evaluate(object, targetClass);
            if (result == null && mandatory) {
                throw new IllegalArgumentException("Could not find function argument #" + expressionIdx + ", but it's mandatory");
            }
            return (T)result;
        }
        catch (Exception e) {
            if (mandatory) {
                throw new IllegalArgumentException("Could not find function argument #" + expressionIdx + ", but it's mandatory");
            }
            return null;
        }
    }

    public Query invertQuery(Query targetQuery, GridGeometry gridGeometry) {
        final String source = this.getAttribute(null, 0, String.class, true);
        final String target = this.getAttribute(null, 1, String.class, true);
        Boolean invert = this.getAttribute(null, 2, Boolean.class, false);
        if (invert == null || !invert.booleanValue()) {
            return null;
        }
        Query q = new Query(targetQuery);
        if (q.getPropertyNames() != null) {
            String[] names = Arrays.copyOf(q.getPropertyNames(), q.getPropertyNames().length);
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(target)) continue;
                names[i] = source;
            }
            q.setPropertyNames(names);
        }
        if (q.getFilter() != null) {
            Filter renamed = (Filter)q.getFilter().accept((FilterVisitor)new DuplicatingFilterVisitor(){

                public Object visit(PropertyName expression, Object extraData) {
                    if (expression.getPropertyName().equals(target)) {
                        return this.ff.property(source);
                    }
                    return super.visit(expression, extraData);
                }
            }, null);
            q.setFilter(renamed);
        }
        return q;
    }

    public GridGeometry invertGridGeometry(Query targetQuery, GridGeometry targetGridGeometry) {
        return null;
    }
}

