/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.geotools.renderer.lite.DashedShape;
import org.junit.Assert;
import org.junit.Test;

public class DashedShapeTest {
    static final float EPS = 0.001f;

    @Test
    public void testHorizontalLine() {
        Line2D.Double line = new Line2D.Double(0.0, 0.0, 30.0, 0.0);
        DashedShape stroked = new DashedShape((Shape)line, new float[]{10.0f, 10.0f}, 0.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 10.0f, 0.0f}, {0.0f, 20.0f, 0.0f}, {1.0f, 30.0f, 0.0f});
    }

    @Test
    public void testShortLine() {
        Line2D.Double line = new Line2D.Double(0.0, 0.0, 5.0, 0.0);
        DashedShape stroked = new DashedShape((Shape)line, new float[]{10.0f, 10.0f}, 0.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 5.0f, 0.0f});
    }

    @Test
    public void testMidLine() {
        Line2D.Double line = new Line2D.Double(0.0, 0.0, 25.0, 0.0);
        DashedShape stroked = new DashedShape((Shape)line, new float[]{10.0f, 10.0f}, 0.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 10.0f, 0.0f}, {0.0f, 20.0f, 0.0f}, {1.0f, 25.0f, 0.0f});
    }

    @Test
    public void testPhase() {
        Line2D.Double line = new Line2D.Double(0.0, 0.0, 25.0, 0.0);
        DashedShape stroked = new DashedShape((Shape)line, new float[]{10.0f, 10.0f}, 5.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 5.0f, 0.0f}, {0.0f, 15.0f, 0.0f}, {1.0f, 25.0f, 0.0f});
    }

    @Test
    public void testVerticalLine() {
        Line2D.Double line = new Line2D.Double(0.0, 0.0, 0.0, 30.0);
        DashedShape stroked = new DashedShape((Shape)line, new float[]{10.0f, 10.0f}, 0.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 10.0f}, {0.0f, 0.0f, 20.0f}, {1.0f, 0.0f, 30.0f});
    }

    @Test
    public void testLShape() {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(0.0f, 5.0f);
        gp.lineTo(5.0f, 5.0f);
        DashedShape stroked = new DashedShape((Shape)gp, new float[]{2.0f, 2.0f}, 0.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 2.0f}, {0.0f, 0.0f, 4.0f}, {1.0f, 0.0f, 5.0f}, {1.0f, 1.0f, 5.0f}, {0.0f, 3.0f, 5.0f}, {1.0f, 5.0f, 5.0f});
    }

    @Test
    public void testDisconnected() {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(5.0f, 0.0f);
        gp.moveTo(10.0f, 5.0f);
        gp.lineTo(15.0f, 5.0f);
        DashedShape stroked = new DashedShape((Shape)gp, new float[]{2.0f, 2.0f}, 0.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 2.0f, 0.0f}, {0.0f, 4.0f, 0.0f}, {1.0f, 5.0f, 0.0f}, {0.0f, 10.0f, 5.0f}, {1.0f, 12.0f, 5.0f}, {0.0f, 14.0f, 5.0f}, {1.0f, 15.0f, 5.0f});
    }

    @Test
    public void testRectangle() {
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0);
        DashedShape stroked = new DashedShape((Shape)r, new float[]{2.0f, 2.0f}, 0.0f);
        this.checkExpected((Shape)stroked, {0.0f, 0.0f, 0.0f}, {1.0f, 2.0f, 0.0f}, {0.0f, 4.0f, 0.0f}, {1.0f, 4.0f, 2.0f}, {0.0f, 4.0f, 4.0f}, {1.0f, 2.0f, 4.0f}, {0.0f, 0.0f, 4.0f}, {1.0f, 0.0f, 2.0f}, {0.0f, 0.0f, 0.0f}, {4.0f, 0.0f, 0.0f});
    }

    void checkExpected(Shape stroked, float[] ... segments) {
        PathIterator pi = stroked.getPathIterator(new AffineTransform());
        String errorMessage = this.errorMessage(stroked);
        float[] piSegment = new float[2];
        for (float[] segment : segments) {
            if (pi.isDone()) {
                Assert.fail((String)("The iterator has less segments than expected. " + errorMessage));
            }
            int type = pi.currentSegment(piSegment);
            Assert.assertEquals((String)errorMessage, (long)type, (long)((int)segment[0]));
            Assert.assertEquals((String)errorMessage, (float)segment[1], (float)piSegment[0], (float)0.001f);
            Assert.assertEquals((String)errorMessage, (float)segment[2], (float)piSegment[1], (float)0.001f);
            pi.next();
        }
        if (!pi.isDone()) {
            Assert.fail((String)("The iterator has more segments than expected. " + errorMessage));
        }
    }

    String errorMessage(Shape shape) {
        PathIterator pi = shape.getPathIterator(new AffineTransform());
        StringBuffer sb = new StringBuffer("The iterator sequence differs from what expected: \n");
        float[] piSegment = new float[2];
        while (!pi.isDone()) {
            int type = pi.currentSegment(piSegment);
            sb.append("{").append(type).append(", ").append(piSegment[0]).append(", ").append(piSegment[1]).append("} ");
            pi.next();
        }
        return sb.toString();
    }
}

