/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicReaderTest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Test;

public class FootprintsRenderingTest {
    @Test
    public void testFootprintsTransformation() throws Exception {
        File zip = new File("./target/rgb.jar");
        try (InputStream is = TestData.openStream((Object)new ImageMosaicReaderTest(), (String)"rgb.jar");
             FileOutputStream os = new FileOutputStream(zip);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        TestData.unzip((File)zip, (File)new File("./target"));
        ImageMosaicReader reader = new ImageMosaicReader((Object)new File("./target/rgb"));
        Style style = RendererBaseTest.loadStyle(this, "footprintstx.sld");
        GridReaderLayer layer = new GridReaderLayer((GridCoverage2DReader)reader, style);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)layer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        ReferencedEnvelope bounds = mc.getViewport().getBounds();
        bounds.expandBy(bounds.getWidth() * 0.1);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, bounds, null);
        File expected = new File("src/test/resources/org/geotools/renderer/lite/test-data/footprintstx.png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)100);
    }
}

