/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.File;
import java.io.IOException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.renderer.lite.GraphicsAwareDpiRescaleStyleVisitor;
import org.geotools.styling.Graphic;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class GraphicsAwareDpiRescaleStyleVisitorTest {
    private StyleBuilder sb;
    private FilterFactory2 ff;

    @Before
    public void setup() {
        this.sb = new StyleBuilder();
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
    }

    @Test
    public void testResizeMark() {
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, this.sb.createMark("square"), null));
        GraphicsAwareDpiRescaleStyleVisitor visitor = new GraphicsAwareDpiRescaleStyleVisitor(2.0);
        ps.accept((StyleVisitor)visitor);
        PointSymbolizer resized = (PointSymbolizer)visitor.getCopy();
        Expression size = resized.getGraphic().getSize();
        Assert.assertTrue((boolean)(size instanceof Literal));
        Assert.assertEquals((long)32L, (long)((Integer)size.evaluate(null, Integer.class)).intValue());
    }

    @Test
    public void testResizeExternalGraphic() throws IOException {
        File imageFile = new File("./src/test/resources/org/geotools/renderer/lite/test-data/draw.png").getCanonicalFile();
        Assert.assertTrue((boolean)imageFile.exists());
        String fileUrl = URLs.fileToUrl((File)imageFile).toExternalForm();
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, null, (Symbol)this.sb.createExternalGraphic(fileUrl, "image/png")));
        GraphicsAwareDpiRescaleStyleVisitor visitor = new GraphicsAwareDpiRescaleStyleVisitor(2.0);
        ps.accept((StyleVisitor)visitor);
        PointSymbolizer resized = (PointSymbolizer)visitor.getCopy();
        Expression size = resized.getGraphic().getSize();
        Assert.assertTrue((boolean)(size instanceof Literal));
        Assert.assertEquals((long)44L, (long)((Integer)size.evaluate(null, Integer.class)).intValue());
    }

    @Test
    public void testCombinedResizingDpiUom() {
        int sizeNum = 10;
        double scaleDpi = 2.0;
        double scaleUom = 3.0;
        PointSymbolizer symbolizer = this.sb.createPointSymbolizer();
        Graphic graphic = this.sb.createGraphic();
        graphic.setSize((Expression)this.ff.function("strConcat", new Expression[]{this.ff.property("size"), this.ff.literal((Object)"m")}));
        symbolizer.setGraphic((org.opengis.style.Graphic)graphic);
        GraphicsAwareDpiRescaleStyleVisitor dpiVisitor = new GraphicsAwareDpiRescaleStyleVisitor(scaleDpi);
        symbolizer.accept((StyleVisitor)dpiVisitor);
        symbolizer = (PointSymbolizer)dpiVisitor.getCopy();
        UomRescaleStyleVisitor uomVisitor = new UomRescaleStyleVisitor(scaleUom);
        uomVisitor.visit(symbolizer);
        symbolizer = (PointSymbolizer)uomVisitor.getCopy();
        SimpleFeature feature = this.createFeatureSized(sizeNum);
        Double size = (Double)symbolizer.getGraphic().getSize().evaluate((Object)feature, Double.class);
        Assert.assertEquals((double)((double)sizeNum * scaleUom), (double)size, (double)0.0);
    }

    SimpleFeature createFeatureSized(int sizeNum) {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("geotools");
        ftb.add("size", Integer.class);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ftb.buildFeatureType());
        fb.set("size", (Object)sizeNum);
        SimpleFeature feature = fb.buildFeature(null);
        return feature;
    }
}

