/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Font;
import java.awt.RenderingHints;
import java.io.File;
import java.util.HashMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PointPlacementTest {
    private static final long TIME = 5000L;
    SimpleFeatureSource pointFS;
    SimpleFeatureSource lineFS;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"point.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.pointFS = ds.getFeatureSource("point");
        this.lineFS = ds.getFeatureSource("line");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Font f = Font.createFont(0, TestData.getResource((Object)this, (String)"recreate.ttf").openStream());
        FontCache.getDefaultInstance().registerFont(f);
    }

    @Test
    public void testDefaultLabelCache() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "textAnchorRotation.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("Old labeller", (GTRenderer)renderer, 5000L, this.bounds);
    }

    @Test
    public void testLabelCacheImpl() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "textAnchorRotation.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        HashMap<String, LabelCacheImpl> rendererParams = new HashMap<String, LabelCacheImpl>();
        LabelCacheImpl labelCache = new LabelCacheImpl();
        rendererParams.put("labelCache", labelCache);
        renderer.setRendererHints(rendererParams);
        RendererBaseTest.showRender("New labeller", (GTRenderer)renderer, 5000L, this.bounds);
    }
}

