/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.PerpendicularOffsetVisitor;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RepeatedLabelTest {
    SimpleFeatureSource fs_line;
    SimpleFeatureSource square;
    SimpleFeatureSource squareHoles;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;

    @Before
    public void setUp() throws Exception {
        File property_line = new File(TestData.getResource((Object)this, (String)"partialLineLabel.properties").toURI());
        PropertyDataStore ds_line = new PropertyDataStore(property_line.getParentFile());
        this.fs_line = ds_line.getFeatureSource("partialLineLabel");
        this.square = ds_line.getFeatureSource("square");
        this.squareHoles = ds_line.getFeatureSource("square-hole");
        this.bounds = new ReferencedEnvelope(2.0, 8.0, 2.0, 8.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        RendererBaseTest.setupVeraFonts();
    }

    @Test
    public void testRepeatedLabel() throws Exception {
        this.checkRepeatedLabels("repeatedLabelsLine");
    }

    @Test
    public void testRepeatedLabelAlongLine() throws Exception {
        this.checkRepeatedLabels("repeatedLabelsAlongLine");
    }

    @Test
    public void testRepeatedLabelAlongLineSmall() throws Exception {
        this.checkRepeatedLabels("repeatedLabelsAlongLineSmall");
    }

    private void checkRepeatedLabels(String styleName) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName + ".sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line, style));
        mc.getViewport().setBounds(this.bounds);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds, null, 500, 500);
        File expected = new File("src/test/resources/org/geotools/renderer/lite/test-data/" + styleName + ".png");
        int tolerance = 2000;
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)tolerance);
    }

    @Test
    public void testLabelSquareBorders() throws Exception {
        this.checkRepeatedLabelsPolygonBorder(this.square, "repeatedLabelsAlongLine", "poly", null, 1600);
    }

    @Test
    public void testLabelSquareBordersWithHoles() throws Exception {
        this.checkRepeatedLabelsPolygonBorder(this.squareHoles, "repeatedLabelsAlongLine", "polyHole", null, 2200);
    }

    @Test
    public void testLabelSquareBordersPositiveOffset() throws Exception {
        PerpendicularOffsetVisitor visitor = new PerpendicularOffsetVisitor(10.0);
        this.checkRepeatedLabelsPolygonBorder(this.square, "repeatedLabelsAlongLine", "poly-perp-offset", visitor, 1700);
    }

    @Test
    public void testLabelSquareBordersNegativeOffset() throws Exception {
        PerpendicularOffsetVisitor visitor = new PerpendicularOffsetVisitor(-10.0);
        this.checkRepeatedLabelsPolygonBorder(this.square, "repeatedLabelsAlongLine", "poly-perp-negative-offset", visitor, 1500);
    }

    @Test
    public void testLabelSquareBordersHolesPositiveOffset() throws Exception {
        PerpendicularOffsetVisitor visitor = new PerpendicularOffsetVisitor(5.0);
        this.checkRepeatedLabelsPolygonBorder(this.squareHoles, "repeatedLabelsAlongLine", "poly-hole-perp-offset", visitor, 2200);
    }

    @Test
    public void testLabelSquareBordersHoleNegativeOffset() throws Exception {
        PerpendicularOffsetVisitor visitor = new PerpendicularOffsetVisitor(-5.0);
        this.checkRepeatedLabelsPolygonBorder(this.squareHoles, "repeatedLabelsAlongLine", "poly-hole-perp-negative-offset", visitor, 2200);
    }

    private void checkRepeatedLabelsPolygonBorder(SimpleFeatureSource features, String styleName, String testImageSuffix, DuplicatingStyleVisitor styleVisitor, int tolerance) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName + ".sld");
        if (styleVisitor != null) {
            style.accept((StyleVisitor)styleVisitor);
            style = (Style)styleVisitor.getCopy();
        }
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)features, style));
        ReferencedEnvelope bounds = features.getBounds();
        bounds.expandBy(bounds.getWidth() / 10.0);
        mc.getViewport().setBounds(bounds);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, bounds, null, 500, 500);
        File expected = new File("src/test/resources/org/geotools/renderer/lite/test-data/" + styleName + "-" + testImageSuffix + ".png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)tolerance);
    }
}

