/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.styling.Mark;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.expression.Expression;

public class VectorFillTest {
    private static final long TIME = 40000L;
    SimpleFeatureSource fs;
    SimpleFeatureSource bfs;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("square");
        this.bfs = ds.getFeatureSource("bigsquare");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(0.2, 0.2);
        Font f = Font.createFont(0, TestData.getResource((Object)this, (String)"recreate.ttf").openStream());
        FontCache.getDefaultInstance().registerFont(f);
    }

    private void runSingleLayerTest(String styleName) throws Exception {
        this.runSingleLayerTest(styleName, 100);
    }

    private void runSingleLayerTest(String styleName, int threshold) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName);
        this.runSingleLayerTest(styleName, threshold, style);
    }

    private void runSingleLayerTest(String fileName, int threshold, Style style) throws Exception, IOException {
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("vectorRenderingEnabled", Boolean.TRUE);
        renderer.setRendererHints(rendererParams);
        BufferedImage image = RendererBaseTest.showRender(fileName, (GTRenderer)renderer, 40000L, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/vector" + fileName + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)threshold);
    }

    @Test
    public void testCrossFill() throws Exception {
        this.runSingleLayerTest("fillCross.sld", 300);
    }

    @Test
    public void testCrossFillZoomedOut() throws Exception {
        String styleName = "fillCrossUom.sld";
        Style style = RendererBaseTest.loadStyle(this, styleName);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage bi = new BufferedImage(10, 10, 6);
        Graphics2D graphics = bi.createGraphics();
        renderer.paint(graphics, new Rectangle(0, 0, 10, 10), this.bounds);
        mc.dispose();
        graphics.dispose();
        mc.dispose();
    }

    @Test
    public void testTriangleFill() throws Exception {
        this.runSingleLayerTest("fillTriangle.sld", 250);
    }

    @Test
    public void testCircleFill() throws Exception {
        this.runSingleLayerTest("fillCircle.sld");
    }

    @Test
    public void testSlash() throws Exception {
        this.runSingleLayerTest("fillSlash.sld");
    }

    @Test
    public void testImageFill() throws Exception {
        this.runSingleLayerTest("fillImage.sld");
    }

    @Test
    public void testMarkFillRotated() throws Exception {
        this.runSingleLayerTest("fillMarkRotated.sld");
    }

    @Test
    public void testFontFill() throws Exception {
        this.runSingleLayerTest("fillTTFDecorative.sld");
    }

    @Test
    public void testVertLine() throws Exception {
        this.testParametricMark("vertline", "shape://vertline");
    }

    @Test
    public void testHorLine() throws Exception {
        this.testParametricMark("horline", "shape://horline");
    }

    @Test
    public void testBackslash() throws Exception {
        this.testParametricMark("backslash", "shape://backslash");
    }

    @Test
    public void testPlus() throws Exception {
        this.testParametricMark("plus", "shape://plus");
    }

    @Test
    public void testDot() throws Exception {
        this.testParametricMark("dot", "shape://dot");
    }

    @Test
    public void testTimes() throws Exception {
        this.testParametricMark("times", "shape://times");
    }

    @Test
    public void testWktShortSlash() throws Exception {
        this.testParametricMark("shortslash", "wkt://LINESTRING(-0.5 0, 0.5 0.5)");
    }

    @Test
    public void testWktShortBackslash() throws Exception {
        this.testParametricMark("shortbackslash", "wkt://LINESTRING(-0.5 0.5, 0.5 0)");
    }

    @Test
    public void testWktComposite() throws Exception {
        this.testParametricMark("wktcomposite", "wkt://MULTILINESTRING((-0.5 -0.5, 0.5 0.5), (0 -0.5, 0 0.5))");
    }

    protected void testParametricMark(String fileName, final String markName) throws Exception {
        Style slashStyle = RendererBaseTest.loadStyle(this, "fillSlash.sld");
        DuplicatingStyleVisitor markReplacer = new DuplicatingStyleVisitor(){

            public void visit(Mark mark) {
                super.visit(mark);
                Mark copy = (Mark)this.pages.peek();
                copy.setWellKnownName((Expression)this.ff.literal((Object)markName));
            }
        };
        slashStyle.accept((StyleVisitor)markReplacer);
        Style style = (Style)markReplacer.getCopy();
        this.runSingleLayerTest(fileName, 100, style);
    }
}

