/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ContrastMethod;
import org.opengis.style.SelectedChannelType;

public class DisplayCoverageTest {
    private static final int WIDTH = 10;
    private final Rectangle bounds = new Rectangle(0, 0, 10, 10);
    private final ReferencedEnvelope env = new ReferencedEnvelope((Rectangle2D)this.bounds, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);

    @Test
    public void renderCoverage() throws IOException {
        Style style = this.createCoverageStyle("1");
        String styleName = "contrastStretchSimple";
        this.testCoverageStyle(style, styleName);
    }

    @Test
    public void renderCoverageWithEnvContrastLow() throws IOException {
        Style style = this.createEnvCoverageStyle("1");
        EnvFunction.setLocalValue((String)"gamma", (Object)"0.5");
        try {
            String styleName = "contrastStretchEnvLow";
            this.testCoverageStyle(style, styleName);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void renderCoverageWithEnvContrastHigh() throws IOException {
        Style style = this.createEnvCoverageStyle("1");
        EnvFunction.setLocalValue((String)"gamma", (Object)"2");
        try {
            String styleName = "contrastStretchEnvHigh";
            this.testCoverageStyle(style, styleName);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void renderCoverageWithEnvMinMax() throws IOException {
        Style style = this.createEnvMinMaxCoverageStyle("1");
        EnvFunction.setLocalValue((String)"range_min", (Object)"4");
        EnvFunction.setLocalValue((String)"range_max", (Object)"16");
        try {
            String styleName = "contrastStretchEnvMinMax";
            this.testCoverageStyle(style, styleName);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    private void testCoverageStyle(Style style, String styleName) throws IOException {
        GridCoverage2D coverage = this.createCoverage();
        StreamingRenderer renderer = new StreamingRenderer();
        MapContent context = new MapContent();
        context.addLayer((Layer)new GridCoverageLayer(coverage, style));
        renderer.setMapContent(context);
        RenderListener listener = new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                Assert.fail((String)"Failed to render coverage");
            }
        };
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, this.env, listener);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/gridcoverage2d/" + styleName + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    private GridCoverage2D createCoverage() {
        GridCoverageFactory gcf = CoverageFactoryFinder.getGridCoverageFactory(null);
        float[][] matrix = new float[10][10];
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                matrix[i][j] = i + j;
            }
        }
        return gcf.create((CharSequence)"coverage", matrix, (Envelope)this.env);
    }

    private Style createCoverageStyle(String bandName) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        ContrastEnhancement ce = sf.contrastEnhancement((Expression)ff.literal(1.0), ContrastMethod.NORMALIZE);
        org.geotools.styling.SelectedChannelType sct = sf.createSelectedChannelType(bandName, ce);
        RasterSymbolizer sym = sf.getDefaultRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = sf.channelSelection((SelectedChannelType)sct);
        sym.setChannelSelection((ChannelSelection)sel);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }

    private Style createEnvCoverageStyle(String bandName) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        ContrastEnhancement ce = sf.contrastEnhancement((Expression)ff.function("env", new Expression[]{ff.literal((Object)"gamma"), ff.literal(1)}), ContrastMethod.NORMALIZE);
        org.geotools.styling.SelectedChannelType sct = sf.createSelectedChannelType(bandName, ce);
        RasterSymbolizer sym = sf.getDefaultRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = sf.channelSelection((SelectedChannelType)sct);
        sym.setChannelSelection((ChannelSelection)sel);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }

    private Style createEnvMinMaxCoverageStyle(String bandName) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        ContrastEnhancement ce = sf.contrastEnhancement((Expression)ff.literal(1.0), ContrastMethod.NORMALIZE);
        ce.addOption("algorithm", (Expression)ff.literal((Object)"StretchToMinimumMaximum"));
        ce.addOption("minValue", (Expression)ff.function("env", new Expression[]{ff.literal((Object)"range_min"), ff.literal(0)}));
        ce.addOption("maxValue", (Expression)ff.function("env", new Expression[]{ff.literal((Object)"range_max"), ff.literal(220)}));
        org.geotools.styling.SelectedChannelType sct = sf.createSelectedChannelType(bandName, ce);
        RasterSymbolizer sym = sf.getDefaultRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = sf.channelSelection((SelectedChannelType)sct);
        sym.setChannelSelection((ChannelSelection)sel);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }
}

