/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.renderer.lite.gridcoverage2d.GradientColorMapGenerator;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class GradientColorMapGeneratorTest {
    @Test
    public void testSVG() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        File svgFile = TestData.file((Object)this, (String)"sample.svg");
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((File)svgFile);
        ColorMap colorMap = colorMapGenerator.generateColorMap(10.0, 80.0);
        Assert.assertNotNull((Object)colorMap);
        ColorMapEntry[] colorEntries = colorMap.getColorMapEntries();
        Assert.assertNotNull((Object)colorEntries);
        Assert.assertEquals((long)6L, (long)colorEntries.length);
        Assert.assertEquals((double)0.0, (double)((Double)colorEntries[0].getOpacity().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((Double)colorEntries[5].getOpacity().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((Object)"#0000FF", (Object)colorEntries[1].getColor().toString());
        Assert.assertEquals((Object)"#00FFFF", (Object)colorEntries[2].getColor().toString());
        Assert.assertEquals((Object)"#FFFF00", (Object)colorEntries[3].getColor().toString());
        Assert.assertEquals((Object)"#FF0000", (Object)colorEntries[4].getColor().toString());
        Assert.assertEquals((Object)"17.0", (Object)colorEntries[1].getQuantity().toString());
        Assert.assertEquals((Object)"38.0", (Object)colorEntries[2].getQuantity().toString());
        Assert.assertEquals((Object)"66.0", (Object)colorEntries[3].getQuantity().toString());
        Assert.assertEquals((Object)"80.0", (Object)colorEntries[4].getQuantity().toString());
    }

    @Test
    public void testHEXcolors() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((String)"#0000ff;#00ffff;#ffff00;#ff0000");
        this.testBlueAcquaYellowRed(colorMapGenerator);
    }

    @Test
    public void testHEXcolors2() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((String)"0x0000ff;0x00ffff;0xffff00;0xff0000");
        this.testBlueAcquaYellowRed(colorMapGenerator);
    }

    @Test
    public void testRGBcolors() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((String)"rgb(0,0,255);rgb(0,255,255);rgb(255,255,0);rgb(255,0,0)");
        this.testBlueAcquaYellowRed(colorMapGenerator);
    }

    private void testBlueAcquaYellowRed(GradientColorMapGenerator colorMapGenerator) {
        ColorMap colorMap = colorMapGenerator.generateColorMap(10.0, 100.0);
        Assert.assertNotNull((Object)colorMap);
        ColorMapEntry[] colorEntries = colorMap.getColorMapEntries();
        Assert.assertNotNull((Object)colorEntries);
        Assert.assertEquals((long)6L, (long)colorEntries.length);
        Assert.assertEquals((double)0.0, (double)((Double)colorEntries[0].getOpacity().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((Double)colorEntries[5].getOpacity().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((Object)"#0000FF", (Object)colorEntries[1].getColor().toString());
        Assert.assertEquals((Object)"#00FFFF", (Object)colorEntries[2].getColor().toString());
        Assert.assertEquals((Object)"#FFFF00", (Object)colorEntries[3].getColor().toString());
        Assert.assertEquals((Object)"#FF0000", (Object)colorEntries[4].getColor().toString());
        Assert.assertEquals((Object)"10.0", (Object)colorEntries[1].getQuantity().toString());
        Assert.assertEquals((Object)"40.0", (Object)colorEntries[2].getQuantity().toString());
        Assert.assertEquals((Object)"70.0", (Object)colorEntries[3].getQuantity().toString());
        Assert.assertEquals((Object)"100.0", (Object)colorEntries[4].getQuantity().toString());
    }

    @Test
    public void testRGBAcolors() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((String)"rgba(0,0,0,1);rgba(255,0,0,0.1);rgba(0,0,255,0)");
        ColorMap colorMap = colorMapGenerator.generateColorMap(10.0, 100.0);
        Assert.assertNotNull((Object)colorMap);
        ColorMapEntry[] colorEntries = colorMap.getColorMapEntries();
        Assert.assertNotNull((Object)colorEntries);
        Assert.assertEquals((long)5L, (long)colorEntries.length);
        Assert.assertEquals((double)0.0, (double)((Double)colorEntries[0].getOpacity().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((Double)colorEntries[4].getOpacity().evaluate(null, Double.class)), (double)0.0);
        this.assertEntry(colorEntries[1], 10.0, Color.BLACK, 1.0f);
        this.assertEntry(colorEntries[2], 55.0, Color.RED, 0.1f);
        this.assertEntry(colorEntries[3], 100.0, Color.BLUE, 0.0f);
    }

    @Test
    public void testBeforeAfterColors() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((String)"rgba(0,0,0,1);rgba(255,0,0,0.5);rgba(0,0,255,0.1)");
        colorMapGenerator.setBeforeColor(Color.RED);
        colorMapGenerator.setAfterColor(new Color(0, 0, 0, 0));
        ColorMap colorMap = colorMapGenerator.generateColorMap(10.0, 100.0);
        Assert.assertNotNull((Object)colorMap);
        ColorMapEntry[] colorEntries = colorMap.getColorMapEntries();
        Assert.assertNotNull((Object)colorEntries);
        Assert.assertEquals((long)5L, (long)colorEntries.length);
        this.assertEntry(colorEntries[0], 10.0, Color.RED, 1.0f);
        this.assertEntry(colorEntries[1], 10.0, Color.BLACK, 1.0f);
        this.assertEntry(colorEntries[2], 55.0, Color.RED, 0.5f);
        this.assertEntry(colorEntries[3], 100.0, Color.BLUE, 0.1f);
        this.assertEntry(colorEntries[4], 100.0, Color.BLACK, 0.0f);
    }

    @Test
    public void testBeforeAfterColorsString() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((String)"rgba(0,0,0,1);rgba(255,0,0,0.5);rgba(0,0,255,0.1)");
        colorMapGenerator.setBeforeColor("rgba(0,0,255,0.5)");
        colorMapGenerator.setAfterColor("rgba(255,0,0,0.5)");
        ColorMap colorMap = colorMapGenerator.generateColorMap(10.0, 100.0);
        Assert.assertNotNull((Object)colorMap);
        ColorMapEntry[] colorEntries = colorMap.getColorMapEntries();
        Assert.assertNotNull((Object)colorEntries);
        Assert.assertEquals((long)5L, (long)colorEntries.length);
        this.assertEntry(colorEntries[0], 10.0, Color.BLUE, 0.5f);
        this.assertEntry(colorEntries[1], 10.0, Color.BLACK, 1.0f);
        this.assertEntry(colorEntries[2], 55.0, Color.RED, 0.5f);
        this.assertEntry(colorEntries[3], 100.0, Color.BLUE, 0.1f);
        this.assertEntry(colorEntries[4], 100.0, Color.RED, 0.5f);
    }

    @Test
    public void testBeforeAfterNullColors() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        GradientColorMapGenerator colorMapGenerator = GradientColorMapGenerator.getColorMapGenerator((String)"rgba(0,0,0,1);rgba(255,0,0,0.5);rgba(0,0,255,0.1)");
        colorMapGenerator.setBeforeColor((String)null);
        colorMapGenerator.setAfterColor((String)null);
        ColorMap colorMap = colorMapGenerator.generateColorMap(10.0, 100.0);
        Assert.assertNotNull((Object)colorMap);
        ColorMapEntry[] colorEntries = colorMap.getColorMapEntries();
        Assert.assertNotNull((Object)colorEntries);
        Assert.assertEquals((long)5L, (long)colorEntries.length);
        this.assertEntry(colorEntries[0], 10.0, Color.BLACK, 0.0f);
        this.assertEntry(colorEntries[1], 10.0, Color.BLACK, 1.0f);
        this.assertEntry(colorEntries[2], 55.0, Color.RED, 0.5f);
        this.assertEntry(colorEntries[3], 100.0, Color.BLUE, 0.1f);
        this.assertEntry(colorEntries[4], 100.0, Color.BLACK, 0.0f);
    }

    private void assertEntry(ColorMapEntry entry, double quantity, Color color, float opacity) {
        Assert.assertEquals((double)quantity, (double)((Double)entry.getQuantity().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((Object)color, (Object)entry.getColor().evaluate(null, Color.class));
        Assert.assertEquals((double)opacity, (double)((Double)entry.getOpacity().evaluate(null, Double.class)), (double)0.01f);
    }
}

