/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageReader;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageReaderSpi;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.jaiext.classifier.ColorMapTransform;
import it.geosolutions.jaiext.classifier.LinearColorMap;
import it.geosolutions.jaiext.classifier.LinearColorMapElement;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import org.geotools.TestData;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ComponentColorModelJAI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.operation.TransformException;

public class TestLinearClassifier
extends Assert {
    private static final int TEST_NUM = 1;

    @Before
    public void before() throws Exception {
        File file = TestData.copy((Object)((Object)this), (String)"arcgrid/arcgrid.zip");
        TestLinearClassifier.assertTrue((boolean)file.exists());
        TestData.unzipFile((Object)((Object)this), (String)"arcgrid/arcgrid.zip");
    }

    @Test
    public void Synthetic_Double() throws IOException {
        BufferedImage image = this.getSynthetic_Double();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.BLACK, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)10.0, (boolean)true), (int)0);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (Range)RangeFactory.create((double)10.0, (boolean)false, (double)100.0, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (Range)RangeFactory.create((double)100.0, (boolean)false, (double)300.0, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color[])new Color[]{Color.green, Color.red}, (Range)RangeFactory.create((double)300.0, (boolean)false, (double)400.0, (boolean)true), (Range)RangeFactory.create((int)3, (int)1000));
            LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c5", (Color[])new Color[]{Color.red, Color.white}, (Range)RangeFactory.create((double)400.0, (boolean)false, (double)1000.0, (boolean)true), (Range)RangeFactory.create((int)1001, (int)2000));
            LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"c6", (Color)Color.red, (double)1001.0, (int)2001);
            LinearColorMapElement c7 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)Double.NaN, (double)Double.NaN), (int)2201);
            LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5, c6}, new LinearColorMapElement[]{c7});
            ImageWorker w = new ImageWorker((RenderedImage)image);
            RenderedOp finalimage = w.classify((ColorMapTransform)list, null).getRenderedOperation();
            if (TestData.isInteractiveTest()) {
                ImageIOUtilities.visualize((RenderedImage)finalimage, (String)"synthetic");
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private BufferedImage getSynthetic_Double() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModelJAI cm = new ComponentColorModelJAI(ColorSpace.getInstance(1003), false, false, 1, 5);
        BufferedImage image = new BufferedImage((ColorModel)cm, raster, false, null);
        return image;
    }

    @Test
    public void Synthetic_Float() throws IOException {
        BufferedImage image = this.getSynthetic_Float();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.BLACK, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)10.0, (boolean)true), (int)0);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (Range)RangeFactory.create((float)10.0f, (boolean)false, (float)100.0f, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (Range)RangeFactory.create((float)100.0f, (boolean)false, (float)300.0f, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color[])new Color[]{Color.green, Color.red}, (Range)RangeFactory.create((float)300.0f, (boolean)false, (float)400.0f, (boolean)true), (Range)RangeFactory.create((int)3, (int)1000));
            LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c5", (Color[])new Color[]{Color.red, Color.white}, (Range)RangeFactory.create((float)400.0f, (boolean)false, (float)1000.0f, (boolean)true), (Range)RangeFactory.create((int)1001, (int)2000));
            LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"c6", (Color)Color.red, (float)1001.0f, (int)2001);
            LinearColorMapElement c7 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)Double.NaN, (double)Double.NaN), (int)2201);
            LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5, c6}, new LinearColorMapElement[]{c7});
            ImageWorker w = new ImageWorker((RenderedImage)image);
            RenderedOp finalimage = w.classify((ColorMapTransform)list, null).getRenderedOperation();
            if (TestData.isInteractiveTest()) {
                ImageIOUtilities.visualize((RenderedImage)finalimage, (String)"synthetic");
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private BufferedImage getSynthetic_Float() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModelJAI cm = new ComponentColorModelJAI(ColorSpace.getInstance(1003), false, false, 1, 4);
        BufferedImage image = new BufferedImage((ColorModel)cm, raster, false, null);
        return image;
    }

    @Test
    public void spearfish() throws IOException {
        RenderedImage image = this.getSpearfhisDemo();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.yellow, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)1100.0, (boolean)true), (int)5);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (Range)RangeFactory.create((double)1100.0, (boolean)false, (double)1200.0, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (Range)RangeFactory.create((double)1200.0, (boolean)false, (double)1400.0, (boolean)true), (int)7);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.blue, (Range)RangeFactory.create((double)1400.0, (boolean)false, (double)1600.0, (boolean)true), (int)1);
            LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.CYAN, (Range)RangeFactory.create((double)1600.0, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)11);
            LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)Double.NaN, (double)Double.NaN), (int)0);
            LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5}, new LinearColorMapElement[]{c6});
            ImageWorker w = new ImageWorker(image);
            RenderedOp finalimage = w.classify((ColorMapTransform)list, null).getRenderedOperation();
            if (TestData.isInteractiveTest()) {
                ImageIOUtilities.visualize((RenderedImage)finalimage, (String)"spearfish");
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private RenderedImage getSpearfhisDemo() throws IOException, FileNotFoundException {
        AsciiGridsImageReader reader = (AsciiGridsImageReader)new AsciiGridsImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(TestData.file((Object)((Object)this), (String)"arcgrid/spearfish_dem.arx")));
        RenderedImage image = reader.readAsRenderedImage(0, null);
        return image;
    }

    @Test
    public void SWAN() throws IOException {
        RenderedImage image = this.getSWAN();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.green, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)0.3), (int)51);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c1b = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.BLACK, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c1c = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            TestLinearClassifier.assertNotEquals((Object)c1, (Object)c1b);
            TestLinearClassifier.assertEquals((Object)c1, (Object)c1c);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.red, (Range)RangeFactory.create((double)0.6, (boolean)false, (double)0.9, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.BLUE, (Range)RangeFactory.create((double)0.9, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)3);
            LinearColorMapElement nodata = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)-9.0, (double)-9.0), (int)4);
            LinearColorMap list = new LinearColorMap((CharSequence)"testSWAN", new LinearColorMapElement[]{c0, c1, c3, c4}, new LinearColorMapElement[]{nodata}, new Color(0, 0, 0));
            TestLinearClassifier.assertEquals((long)list.getSourceDimensions(), (long)1L);
            TestLinearClassifier.assertEquals((long)list.getTargetDimensions(), (long)1L);
            TestLinearClassifier.assertEquals((Object)list.getName().toString(), (Object)"testSWAN");
            TestLinearClassifier.assertNotNull((Object)c0.toString());
            ImageWorker w = new ImageWorker(image);
            boolean exceptionThrown = false;
            try {
                RenderedOp d = w.classify((ColorMapTransform)list, Integer.valueOf(2)).getRenderedOperation();
                d.getTiles();
            }
            catch (Exception e) {
                exceptionThrown = true;
            }
            TestLinearClassifier.assertTrue((boolean)exceptionThrown);
            RenderedOp finalImage = w.classify((ColorMapTransform)list, Integer.valueOf(0)).getRenderedOperation();
            if (TestData.isInteractiveTest()) {
                ImageIOUtilities.visualize((RenderedImage)finalImage, (String)"testSWAN1");
            } else {
                finalImage.getTiles();
            }
            finalImage.dispose();
        }
    }

    @Test
    public void SWANGAP() throws IOException {
        RenderedImage image = this.getSWAN();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.green, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)0.3), (int)51);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.red, (Range)RangeFactory.create((double)0.7, (boolean)false, (double)0.9, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.BLUE, (Range)RangeFactory.create((double)0.9, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)3);
            LinearColorMapElement nodata = LinearColorMapElement.create((CharSequence)"nodata", (Color)Color.red, (Range)RangeFactory.create((double)-9.0, (double)-9.0), (int)4);
            LinearColorMap list = new LinearColorMap((CharSequence)"testSWAN", new LinearColorMapElement[]{c0, c1, c3, c4}, new LinearColorMapElement[]{nodata}, new Color(0, 0, 0, 0));
            ImageWorker w = new ImageWorker(image);
            boolean exceptionThrown = false;
            try {
                RenderedOp d = w.classify((ColorMapTransform)list, Integer.valueOf(2)).getRenderedOperation();
                d.getTiles();
            }
            catch (Exception e) {
                exceptionThrown = true;
            }
            TestLinearClassifier.assertTrue((boolean)exceptionThrown);
            RenderedOp finalImage = w.classify((ColorMapTransform)list, Integer.valueOf(0)).getRenderedOperation();
            IndexColorModel icm = (IndexColorModel)finalImage.getColorModel();
            TestLinearClassifier.assertEquals((long)icm.getRed(4), (long)255L);
            TestLinearClassifier.assertEquals((long)icm.getRed(2), (long)255L);
            if (TestData.isInteractiveTest()) {
                ImageIOUtilities.visualize((RenderedImage)finalImage, (String)"testSWANGAP");
            } else {
                finalImage.getTiles();
            }
            finalImage.dispose();
        }
    }

    private RenderedImage getSWAN() throws IOException, FileNotFoundException {
        AsciiGridsImageReader reader = (AsciiGridsImageReader)new AsciiGridsImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(TestData.file((Object)((Object)this), (String)"arcgrid/SWAN_NURC_LigurianSeaL07_HSIGN.asc")));
        RenderedImage image = reader.readAsRenderedImage(0, null);
        return image;
    }

    @Test
    public void noDataOnly() throws IOException, TransformException, TransformationException {
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement n0 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)Double.NaN, (double)Double.NaN), (int)9999);
            LinearColorMap list = new LinearColorMap((CharSequence)"", new LinearColorMapElement[]{n0});
            double testNum = Math.random();
            try {
                TestLinearClassifier.assertEquals((double)list.transform(testNum), (double)testNum, (double)0.0);
                TestLinearClassifier.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            TestLinearClassifier.assertEquals((double)list.transform(Double.NaN), (double)9999.0, (double)0.0);
        }
    }
}

