/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ImageGraphicFactory;
import org.geotools.renderer.style.TTFMarkFactory;
import org.geotools.renderer.style.WellKnownMarkFactory;
import org.junit.Assert;
import org.junit.Test;

public class DynamicSymbolFactoryFinderTest {
    @Test
    public void testLookupMarkFactories() {
        List result = this.loadIterator(DynamicSymbolFactoryFinder.getMarkFactories());
        Assert.assertTrue((result.size() >= 2 ? 1 : 0) != 0);
        this.assertContainsClassInstance(result, WellKnownMarkFactory.class);
        this.assertContainsClassInstance(result, TTFMarkFactory.class);
    }

    @Test
    public void testLookupExternalGraphicFactories() {
        List result = this.loadIterator(DynamicSymbolFactoryFinder.getExternalGraphicFactories());
        Assert.assertFalse((boolean)result.isEmpty());
        this.assertContainsClassInstance(result, ImageGraphicFactory.class);
    }

    public void assertContainsClassInstance(List list, Class<?> clazz) {
        for (Object item : list) {
            if (item == null || !clazz.isAssignableFrom(item.getClass())) continue;
            return;
        }
        Assert.fail((String)("List does not contain any element of class " + clazz.getName()));
    }

    public <T> List<T> loadIterator(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

