/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.markwkt;

import java.awt.Shape;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.style.markwkt.MeteoMarkFactory;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapeMarkFactoryTest {
    private SimpleFeature feature;
    private Expression exp;
    private FilterFactory ff;

    public ShapeMarkFactoryTest() {
        try {
            this.ff = CommonFactoryFinder.getFilterFactory(null);
            SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
            featureTypeBuilder.setName("TestType");
            featureTypeBuilder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            SimpleFeatureType featureType = featureTypeBuilder.buildFeatureType();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
            this.feature = featureBuilder.buildFeature(null);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }

    @Test
    public void testWellKnownName() {
        MeteoMarkFactory smf = new MeteoMarkFactory();
        try {
            this.exp = this.ff.literal((Object)"shape://triangle");
            smf.getShape(null, this.exp, (Feature)this.feature);
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testUnknownProtocol() {
        MeteoMarkFactory smf = new MeteoMarkFactory();
        try {
            this.exp = this.ff.literal((Object)"xxx://triangle");
            if (smf.getShape(null, this.exp, (Feature)this.feature) == null) {
                Assert.assertTrue((boolean)true);
                return;
            }
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSouthArrow() {
        MeteoMarkFactory smf = new MeteoMarkFactory();
        try {
            this.exp = this.ff.literal((Object)"extshape://sarrow");
            Shape shape = smf.getShape(null, this.exp, (Feature)this.feature);
            Assert.assertNotNull((Object)shape);
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.assertTrue((boolean)true);
    }
}

