/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.util.List;
import org.geotools.renderer.label.LabelSplitter;
import org.geotools.renderer.lite.LineTest;
import org.geotools.renderer.style.FontCache;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabelSplitterTest {
    @Before
    public void setUp() throws IOException, FontFormatException {
        FontCache.getDefaultInstance().registerFont(Font.createFont(0, TestData.getResource(LineTest.class, (String)"Vera.ttf").openStream()));
        FontCache.getDefaultInstance().registerFont(Font.createFont(0, TestData.getResource(LineTest.class, (String)"DroidSansFallback.ttf").openStream()));
    }

    @Test
    public void testFontRangeWithUnrenderableCharsInMiddle() {
        LabelSplitter splitter = new LabelSplitter();
        String startText = "Some text ";
        String naNun = "\u1290\ud802\ude6c";
        String endText = " here";
        String text = startText + naNun + endText;
        Font font = FontCache.getDefaultInstance().getFont("Bitstream Vera Sans");
        Font[] fonts = new Font[]{font, font, font, font, font, font};
        List ranges = splitter.buildFontRanges(text, fonts);
        Assert.assertEquals((long)3L, (long)ranges.size());
        LabelSplitter.FontRange startRange = (LabelSplitter.FontRange)ranges.get(0);
        Assert.assertEquals((long)0L, (long)startRange.startChar);
        Assert.assertEquals((long)10L, (long)startRange.endChar);
        Assert.assertEquals((Object)font, (Object)startRange.font);
        Assert.assertEquals((Object)startText, (Object)startRange.text);
        LabelSplitter.FontRange middleRange = (LabelSplitter.FontRange)ranges.get(1);
        Assert.assertEquals((long)10L, (long)middleRange.startChar);
        Assert.assertEquals((long)13L, (long)middleRange.endChar);
        Assert.assertEquals((Object)font, (Object)middleRange.font);
        Assert.assertEquals((Object)naNun, (Object)middleRange.text);
        LabelSplitter.FontRange endRange = (LabelSplitter.FontRange)ranges.get(2);
        Assert.assertEquals((long)13L, (long)endRange.startChar);
        Assert.assertEquals((long)18L, (long)endRange.endChar);
        Assert.assertEquals((Object)font, (Object)endRange.font);
        Assert.assertEquals((Object)endText, (Object)endRange.text);
    }

    @Test
    public void testFontRangeWithUnrenderableCompositeCharAtStart() {
        Font font = FontCache.getDefaultInstance().getFont("Bitstream Vera Sans");
        Font fallbackFont = FontCache.getDefaultInstance().getFont("Droid Sans Fallback");
        String compositeChar = "\ud859\ude26";
        String remainingChars = "\u5b57\u5b57\u5b57\u5b57\u5b57\u5b57\u5b57\u5b57";
        LabelSplitter splitter = new LabelSplitter();
        String text = compositeChar + remainingChars;
        Font[] fonts = new Font[]{font, font, font, font, font, fallbackFont};
        List ranges = splitter.buildFontRanges(text, fonts);
        Assert.assertEquals((long)2L, (long)ranges.size());
        LabelSplitter.FontRange startRange = (LabelSplitter.FontRange)ranges.get(0);
        Assert.assertEquals((long)0L, (long)startRange.startChar);
        Assert.assertEquals((long)2L, (long)startRange.endChar);
        Assert.assertEquals((Object)font, (Object)startRange.font);
        Assert.assertEquals((Object)compositeChar, (Object)startRange.text);
        LabelSplitter.FontRange endRange = (LabelSplitter.FontRange)ranges.get(1);
        Assert.assertEquals((long)2L, (long)endRange.startChar);
        Assert.assertEquals((long)10L, (long)endRange.endChar);
        Assert.assertEquals((Object)fallbackFont, (Object)endRange.font);
        Assert.assertEquals((Object)remainingChars, (Object)endRange.text);
    }
}

