/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.jai.Interpolation;
import javax.media.jai.ROI;
import javax.media.jai.TiledImage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.geotools.TestData;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.ImageAssert;
import org.geotools.image.util.ImageUtilities;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.CountingRenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageReaderHelper;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageReaderHelperTest;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.ContrastMethodStrategy;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.NormalizeContrastMethodStrategy;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.util.URLs;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.ChannelSelection;

public class GridCoverageRendererTest {
    private static final String AFRICA_EQUIDISTANT_CONIC_WKT = "PROJCS[\"Africa_Equidistant_Conic\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]],PROJECTION[\"Equidistant_Conic\"],PARAMETER[\"False_Easting\",0],PARAMETER[\"False_Northing\",0],PARAMETER[\"Central_Meridian\",25],PARAMETER[\"Standard_Parallel_1\",20],PARAMETER[\"Standard_Parallel_2\",-23],PARAMETER[\"Latitude_Of_Origin\",0],UNIT[\"Meter\",1],AUTHORITY[\"EPSG\",\"102023\"]]";
    String FILENAME = "TestGridCoverage.jpg";
    private GridCoverage2DReader worldReader;
    private GridCoverage2DReader rainReader;
    private GridCoverage2DReader worldPaletteReader;
    private GeoTiffReader worldReader_0_360;
    private GeoTiffReader worldRoiReader;
    private GeoTiffReader sampleGribReader;
    private GeoTiffReader multiPixelPacked;
    private static double DELTA = 1.0E-6;

    @Before
    public void getData() throws IOException {
        MapProjection.SKIP_SANITY_CHECKS = true;
        File coverageFile = TestData.copy((Object)this, (String)"geotiff/world.tiff");
        Assert.assertTrue((boolean)coverageFile.exists());
        this.worldReader = new GeoTiffReader((Object)coverageFile);
        coverageFile = TestData.copy((Object)this, (String)"geotiff/world_0_360.tiff");
        Assert.assertTrue((boolean)coverageFile.exists());
        this.worldReader_0_360 = new GeoTiffReader((Object)coverageFile);
        coverageFile = TestData.copy((Object)this, (String)"geotiff/worldPalette.tiff");
        Assert.assertTrue((boolean)coverageFile.exists());
        this.worldPaletteReader = new GeoTiffReader((Object)coverageFile);
        File file = TestData.copy((Object)this, (String)"arcgrid/arcgrid.zip");
        Assert.assertTrue((boolean)file.exists());
        TestData.unzipFile((Object)this, (String)"arcgrid/arcgrid.zip");
        URL rainURL = GridCoverageRendererTest.class.getResource("test-data/arcgrid/precip30min.asc");
        File rainFile = URLs.urlToFile((URL)rainURL);
        this.rainReader = new ArcGridReader((Object)rainFile);
        coverageFile = TestData.copy((Object)this, (String)"geotiff/world-roi.tiff");
        Assert.assertTrue((boolean)coverageFile.exists());
        this.worldRoiReader = new GeoTiffReader((Object)coverageFile);
        coverageFile = URLs.urlToFile((URL)GridCoverageRendererTest.class.getResource("test-data/sampleGrib.tif"));
        Assert.assertTrue((boolean)coverageFile.exists());
        this.sampleGribReader = new GeoTiffReader((Object)coverageFile);
        coverageFile = URLs.urlToFile((URL)GridCoverageRendererTest.class.getResource("test-data/multi_pixel_packed.tif"));
        Assert.assertTrue((boolean)coverageFile.exists());
        this.multiPixelPacked = new GeoTiffReader((Object)coverageFile);
    }

    @After
    public void close() throws IOException {
        MapProjection.SKIP_SANITY_CHECKS = false;
        this.worldReader.dispose();
        EnvFunction.clearLocalValues();
    }

    private final GridCoverage2D getGC() throws IOException, IllegalArgumentException, ParseException {
        String path = "TestGridCoverage.tif";
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        Rectangle2D.Double bounds = new Rectangle2D.Double(35.0, -41.0, 45.0, 46.0);
        GeneralEnvelope envelope = new GeneralEnvelope((Rectangle2D)bounds);
        BufferedImage image = ImageIO.read(TestData.getResource((Object)this, (String)path));
        int numBands = image.getSampleModel().getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            bands[i] = new GridSampleDimension((CharSequence)("band " + i));
        }
        String filename = new File(path).getName();
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
        return factory.create((CharSequence)filename, (RenderedImage)image, (Envelope)envelope, bands, null, null);
    }

    private static CoordinateReferenceSystem getProjectedCRS(GridCoverage2D coverage) {
        try {
            MathTransform mt;
            GeographicCRS base = (GeographicCRS)coverage.getCoordinateReferenceSystem();
            Ellipsoid ellipsoid = base.getDatum().getEllipsoid();
            DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
            ParameterValueGroup parameters = factory.getDefaultParameters("Oblique_Stereographic");
            parameters.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis());
            parameters.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis());
            parameters.parameter("central_meridian").setValue(5);
            parameters.parameter("latitude_of_origin").setValue(-5);
            try {
                mt = factory.createParameterizedTransform(parameters);
            }
            catch (FactoryException exception) {
                Assert.fail((String)exception.getLocalizedMessage());
                return null;
            }
            return new DefaultProjectedCRS(Collections.singletonMap("name", "Stereographic"), base, mt, (CartesianCS)DefaultCartesianCS.PROJECTED);
        }
        catch (NoSuchIdentifierException exception) {
            Assert.fail((String)exception.getLocalizedMessage());
            return null;
        }
    }

    @Test
    public void paint() throws Exception {
        GridCoverage2D gc = this.getGC();
        MapContent map = new MapContent();
        Style style = GridCoverageRendererTest.getStyle();
        map.addLayer((Layer)new GridCoverageLayer(gc, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        RendererBaseTest.showRender("testGridCoverage", (GTRenderer)renderer, 1000L, map.getMaxBounds());
    }

    @Test
    public void paintWrongStyle() throws Exception {
        GridCoverage2D gc = this.getGC();
        MapContent map = new MapContent();
        Style style = RendererBaseTest.loadStyle(this, "empty.sld");
        map.addLayer((Layer)new GridCoverageLayer(gc, style));
        StreamingRenderer renderer = new StreamingRenderer();
        CountingRenderListener counter = new CountingRenderListener();
        renderer.addRenderListener((RenderListener)counter);
        renderer.setMapContent(map);
        BufferedImage image = new BufferedImage(300, 300, 6);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        renderer.paint(g2d, new Rectangle(0, 0, 300, 300), map.getMaxBounds());
        g2d.dispose();
        map.dispose();
        Assert.assertEquals((long)0L, (long)counter.errors);
        Assert.assertEquals((long)0L, (long)counter.features);
    }

    @Test
    public void reproject() throws Exception {
        GridCoverage2D coverage = this.getGC();
        MapContent map = new MapContent();
        Style style = GridCoverageRendererTest.getStyle();
        map.addLayer((Layer)new GridCoverageLayer(coverage, style));
        CoordinateReferenceSystem destCRS = GridCoverageRendererTest.getProjectedCRS(coverage);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope newbounds = env.transform(destCRS, true);
        RendererBaseTest.showRender("testGridCoverageReprojection", (GTRenderer)renderer, 1000L, newbounds);
    }

    @Test
    public void testRenderingBuffer() throws Exception {
        MapContent content = new MapContent();
        Style style = GridCoverageRendererTest.getStyle();
        content.addLayer((Layer)new GridReaderLayer(this.worldReader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(content);
        renderer.setRendererHints(Collections.singletonMap("renderingBuffer", 1024));
        BufferedImage image = RendererBaseTest.showRender("testGridCoverageReprojection", (GTRenderer)renderer, 1000L, content.getViewport().getBounds());
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geotools/renderer/lite/rescaled.png"), (RenderedImage)image, (int)1000);
    }

    @Test
    public void testInterpolationBicubic() throws Exception {
        CoordinateReferenceSystem googleMercator = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-2.003750834E7, 2.003750834E7, -2.003750834E7, 2.003750834E7, googleMercator);
        Rectangle screenSize = new Rectangle(200, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 200.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(googleMercator, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        GridCoverage2D coverage = this.worldReader.read(null);
        RenderedImage image = renderer.renderImage(coverage, rasterSymbolizer, Interpolation.getInstance((int)2), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/googleMercatorBicubic.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testInvertedColors() throws Exception {
        MapContent content = new MapContent();
        content.getViewport().setBounds(new ReferencedEnvelope(-179.9997834892, 180.00025801626, -89.999828389438, 270.00021311603, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        RasterSymbolizer rs = this.buildRainColorMap();
        Style style = new StyleBuilder().createStyle((Symbolizer)rs);
        content.addLayer((Layer)new GridReaderLayer(this.rainReader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(content);
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("advancedProjectionHandling", true);
        rendererParams.put("continuousMapWrapping", true);
        renderer.setRendererHints(rendererParams);
        BufferedImage image = RendererBaseTest.showRender("testGridCoverageReprojection", (GTRenderer)renderer, 1000L, content.getViewport().getBounds());
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geotools/renderer/lite/inverted.png"), (RenderedImage)image, (int)1000);
    }

    private static Style getStyle() {
        StyleBuilder sb = new StyleBuilder();
        Style rasterstyle = sb.createStyle();
        RasterSymbolizer raster = sb.createRasterSymbolizer();
        rasterstyle.featureTypeStyles().add(sb.createFeatureTypeStyle((Symbolizer)raster));
        ((FeatureTypeStyle)rasterstyle.featureTypeStyles().get(0)).setName("GridCoverage");
        return rasterstyle;
    }

    @Test
    public void testReprojectBuffer() throws Exception {
        BufferedImage bi = new BufferedImage(100, 100, 10);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(Color.DARK_GRAY);
        graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        graphics.dispose();
        double baseX = 529687.0;
        double baseY = 3374773.0;
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:26915", (boolean)true);
        GridCoverage2D coverage = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"test", (RenderedImage)bi, (Envelope)new ReferencedEnvelope(baseX, baseX + (double)bi.getWidth(), baseY, baseY + (double)bi.getHeight(), nativeCrs));
        File testFile = new File("./target/testReprojection.tiff");
        GeoTiffWriter writer = new GeoTiffWriter((Object)testFile);
        writer.write((GridCoverage)coverage, null);
        MathTransform r2m = coverage.getGridGeometry().getGridToCRS();
        org.locationtech.jts.geom.Envelope env = new org.locationtech.jts.geom.Envelope(25.0, 75.0, 25.0, 75.0);
        ReferencedEnvelope read26915 = new ReferencedEnvelope(JTS.transform((org.locationtech.jts.geom.Envelope)env, (MathTransform)r2m), nativeCrs);
        CoordinateReferenceSystem mapCRS = CRS.decode((String)"EPSG:3857", (boolean)true);
        ReferencedEnvelope read3857 = read26915.transform(mapCRS, true);
        StyleBuilder sb = new StyleBuilder();
        GridReaderLayer layer = new GridReaderLayer((GridCoverage2DReader)new GeoTiffReader((Object)testFile), sb.createStyle((Symbolizer)sb.createRasterSymbolizer()));
        MapContent mc = new MapContent();
        mc.getViewport().setBounds(read3857);
        mc.addLayer((Layer)layer);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        BufferedImage result = RendererBaseTest.showRender("testGridCoverageBoundsReprojection", (GTRenderer)sr, 1000L, read3857);
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geotools/renderer/lite/reprojectBuffer.png"), (RenderedImage)result, (int)0);
    }

    @Test
    public void testReprojectGoogleMercator() throws Exception {
        CoordinateReferenceSystem googleMercator = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-2.003750834E7, 2.003750834E7, -2.003750834E7, 2.003750834E7, googleMercator);
        Rectangle screenSize = new Rectangle(200, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 200.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(googleMercator, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        GridCoverage2D coverage = this.worldReader.read(null);
        RenderedImage image = renderer.renderImage(coverage, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertThat((Object)image.getProperty("roi"), (Matcher)CoreMatchers.instanceOf(ROI.class));
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/googleMercator.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testReprojectGoogleMercatorLargerThanWorld() throws Exception {
        CoordinateReferenceSystem googleMercator = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-3.8448446580832E7, 3.8448446580832E7, -4.4138127016561E7, 4.4138127016561E7, googleMercator);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(googleMercator, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/googleMercatorLargerThanWorld.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testReprojectGoogleMercatorBlackLine() throws Exception {
        CoordinateReferenceSystem googleMercator = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-7.065090064528E7, 3.2797834549784E7, -2.551735468145E7, 2.6207012916082E7, googleMercator);
        Rectangle screenSize = new Rectangle(600, 300);
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(googleMercator, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertThat((Object)image.getProperty("roi"), (Matcher)CoreMatchers.instanceOf(ROI.class));
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/googleMercatorBlackLine.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)5);
    }

    @Test
    public void testReprojectGoogleMercatorTouchDateline() throws Exception {
        CoordinateReferenceSystem googleMercator = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(2.003750834E7, 4.007501668E7, 0.0, 2.003750834E7, googleMercator);
        Rectangle screenSize = new Rectangle(256, 256);
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(googleMercator, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/googleMercatorTouchDateline.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)10);
    }

    @Test
    public void testAcrossDatelineBilinear() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(10.0, 350.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Rectangle screenSize = new Rectangle(500, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 500.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/wrapDatelineNearest.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)20);
    }

    @Test
    public void testNoProjectionHandlerSet() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(10.0, 500.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Rectangle screenSize = new Rectangle(500, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 500.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        renderer.setAdvancedProjectionHandlingEnabled(false);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/noProjectionHandlerSet.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testCrashOutsideValidArea() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(2.3726353151687E-4, 180.00025801626, -269.99984914217, -89.999828389438, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Rectangle screenSize = new Rectangle(256, 256);
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        this.assertNull(image);
    }

    private void assertNull(RenderedImage image) {
    }

    @Test
    public void testAcrossDatelineBicubic() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(10.0, 350.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Rectangle screenSize = new Rectangle(500, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 500.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)2), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/wrapDatelineBicubic.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testUTM() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:32632", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-6000000.0, 6000000.0, 0.0, 5300000.0, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)2), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/utm.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
        Object property = image.getProperty("ParentCoverage");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof GridCoverage2D));
        GridCoverage2D propertyCoverage = (GridCoverage2D)property;
        CoordinateReferenceSystem targetCrs = propertyCoverage.getCoordinateReferenceSystem();
        Assert.assertTrue((boolean)targetCrs.getName().equals(crs.getName()));
    }

    @Test
    public void testSouthPolar() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-6000000.0, 6000000.0, -8000000.0, -1000000.0, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/south_polar.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testNorthPolar() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3995", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-6000000.0, 6000000.0, 8000000.0, 1000000.0, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/north_polar.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)40);
    }

    @Test
    public void testIndexedWithNoBackground() throws Exception {
        CoordinateReferenceSystem googleMercator = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-2.003750834E7, 2.003750834E7, -2.003750834E7, 2.003750834E7, googleMercator);
        Rectangle screenSize = new Rectangle(200, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 200.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(googleMercator, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldPaletteReader, null, rasterSymbolizer, Interpolation.getInstance((int)2), null, 256, 256);
        Assert.assertNotNull((Object)image);
    }

    @Test
    public void testPolarCutLowCorner() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-2500000.0, -1250000.0, -1.0E7, -8750000.0, crs);
        Rectangle screenSize = new Rectangle(256, 256);
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = this.buildRainColorMap();
        RenderedImage image = renderer.renderImage(this.rainReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/polar_whitecorner.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    private RasterSymbolizer buildRainColorMap() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap colorMap = sb.createColorMap(new String[]{"1", "2", "3", "4"}, new double[]{0.0, 100.0, 2000.0, 5000.0}, new Color[]{Color.RED, Color.WHITE, Color.GREEN, Color.BLUE}, 1);
        RasterSymbolizer rasterSymbolizer = sb.createRasterSymbolizer(colorMap, 1.0);
        return rasterSymbolizer;
    }

    @Test
    public void testPolarCutUpperCorner() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-625000.0, 0.0, -1.0E7, -9375000.0, crs);
        Rectangle screenSize = new Rectangle(256, 256);
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = this.buildRainColorMap();
        RenderedImage image = renderer.renderImage(this.rainReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/polar_whitecorner_up.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testPolarTouchDateline() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-1250000.0, 0.0, -1.0E7, -8750000.0, crs);
        Rectangle screenSize = new Rectangle(256, 256);
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = this.buildRainColorMap();
        RenderedImage image = renderer.renderImage(this.rainReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/polar_touchdateline.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testAfricaEquidistantConic() throws Exception {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)AFRICA_EQUIDISTANT_CONIC_WKT);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-1.5814047554122284E7, 2.4919762252195686E7, -1.4112074925190449E7, 1.1688610748676982E7, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage(this.worldReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/africa-conic.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testAfricaEquidistantConicIndexed() throws Exception {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)AFRICA_EQUIDISTANT_CONIC_WKT);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-1.5814047554122284E7, 2.4919762252195686E7, -1.4112074925190449E7, 1.1688610748676982E7, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        File coverageFile = TestData.copy((Object)this, (String)"geotiff/worldPalette.tiff");
        Assert.assertTrue((boolean)coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        Assert.assertTrue((boolean)(image.getColorModel() instanceof ComponentColorModel));
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/africa-conic-palette.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)10);
    }

    @Test
    public void testAfricaEquidistantConicRoi() throws Exception {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)AFRICA_EQUIDISTANT_CONIC_WKT);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-1.5814047554122284E7, 2.4919762252195686E7, -1.4112074925190449E7, 1.1688610748676982E7, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)this.worldRoiReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/africa-conic-roi.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)10);
    }

    @Test
    public void testFlippedAffine() throws Exception {
        File coverageFile = TestData.copy((Object)this, (String)"geotiff/float64.tif");
        Assert.assertTrue((boolean)coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        Style style = RendererBaseTest.loadStyle(this, "float64.sld");
        RasterSymbolizer rasterSymbolizer = (RasterSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        ReferencedEnvelope mapExtent = ReferencedEnvelope.reference((Envelope)reader.getOriginalEnvelope());
        Rectangle screenSize = new Rectangle(50, 50);
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(reader.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/flippedAffine.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)2);
    }

    @Test
    public void testEnvFunctionInColorMap() throws Exception {
        EnvFunction.setLocalValue((String)"low", (Object)"-0.001");
        EnvFunction.setLocalValue((String)"lowColor", (Object)"#000000");
        File coverageFile = TestData.copy((Object)this, (String)"geotiff/float64.tif");
        Assert.assertTrue((boolean)coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        Style style = RendererBaseTest.loadStyle(this, "float64.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridReaderLayer((GridCoverage2DReader)reader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, mc.getViewport().getBounds(), null, 50, 50);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/flippedAffineParametric.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)2);
    }

    @Test
    public void testCoverage_0_360() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(100.0, 260.0, -90.0, 90.0, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)this.worldReader_0_360, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/world_0_360.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)10);
    }

    @Test
    public void testSampleGrib() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(302.0, 308.0, 2.0, 10.0, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)this.sampleGribReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.GRAY, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/sampleGrib.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testSampleGribCropLongitude() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(304.0, 310.0, 2.0, 10.0, crs);
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = new StyleBuilder().createRasterSymbolizer();
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)this.sampleGribReader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.GRAY, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/sampleGribCropLongitude.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testBandSelectionOnNonSupportingReader() throws Exception {
        BufferedImage bi = new BufferedImage(100, 100, 1);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(Color.BLUE);
        graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        graphics.dispose();
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, nativeCrs);
        GridCoverage2D coverage = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"test", (RenderedImage)bi, (Envelope)new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, nativeCrs));
        Assert.assertEquals((long)coverage.getNumSampleDimensions(), (long)3L);
        File coverageFile = new File("./target/blue.tiff");
        GeoTiffWriter writer = new GeoTiffWriter((Object)coverageFile);
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        wp.setCompressionQuality(0.75f);
        ParameterValueGroup params = format.getWriteParameters();
        List paramsValues = params.values();
        writer.write((GridCoverage)coverage, params.values().toArray(new GeneralParameterValue[paramsValues.size()]));
        Assert.assertTrue((boolean)coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        GridCoverageRenderer renderer = new GridCoverageRenderer(nativeCrs, (org.locationtech.jts.geom.Envelope)mapExtent, new Rectangle(0, 0, 100, 100), null);
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader, null, this.buildChannelSelectingSymbolizer(3), Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((double)255.0, (double)new ImageWorker(image).getMinimums()[0], (double)0.0);
        ImageUtilities.disposeImage((RenderedImage)image);
        image = renderer.renderImage((GridCoverage2DReader)reader, null, this.buildChannelSelectingSymbolizer(1), Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((double)0.0, (double)new ImageWorker(image).getMaximums()[0], (double)0.0);
        ImageUtilities.disposeImage((RenderedImage)image);
    }

    @Test
    public void testBandSelectionExpression() throws Exception {
        BufferedImage bi = new BufferedImage(100, 100, 1);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(Color.BLUE);
        graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        graphics.dispose();
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, nativeCrs);
        GridCoverage2D coverage = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"test", (RenderedImage)bi, (Envelope)new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, nativeCrs));
        Assert.assertEquals((long)coverage.getNumSampleDimensions(), (long)3L);
        File coverageFile = new File("./target/blue.tiff");
        GeoTiffWriter writer = new GeoTiffWriter((Object)coverageFile);
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        wp.setCompressionQuality(0.75f);
        ParameterValueGroup params = format.getWriteParameters();
        List paramsValues = params.values();
        writer.write((GridCoverage)coverage, params.values().toArray(new GeneralParameterValue[paramsValues.size()]));
        Assert.assertTrue((boolean)coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        String b1 = "B1";
        RasterSymbolizer rasterSymb = this.buildEnvChannelSelectingSymbolizer(b1, 3);
        EnvFunction.removeLocalValue((String)b1);
        GridCoverageRenderer renderer = new GridCoverageRenderer(nativeCrs, (org.locationtech.jts.geom.Envelope)mapExtent, new Rectangle(0, 0, 100, 100), null);
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader, null, rasterSymb, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((double)255.0, (double)new ImageWorker(image).getMinimums()[0], (double)0.0);
        EnvFunction.setLocalValue((String)b1, (Object)"1");
        image = renderer.renderImage((GridCoverage2DReader)reader, null, rasterSymb, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((double)0.0, (double)new ImageWorker(image).getMinimums()[0], (double)0.0);
        EnvFunction.removeLocalValue((String)b1);
        ImageUtilities.disposeImage((RenderedImage)image);
    }

    @Test
    public void testBandSelectionSupportingReader() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        TestSingleBandReader reader = new TestSingleBandReader(2);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, new Rectangle(0, 0, 100, 100), null);
        RasterSymbolizer rasterSymbolizer = this.buildChannelSelectingSymbolizer(3);
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertEquals((long)1L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((double)255.0, (double)new ImageWorker(image).getMinimums()[0], (double)0.0);
        RasterSymbolizer expectedRasterSymbolizer = this.buildChannelSelectingSymbolizer(3);
        expectedRasterSymbolizer.getContrastEnhancement().setOptions(Collections.emptyMap());
        Assert.assertEquals((Object)rasterSymbolizer, (Object)expectedRasterSymbolizer);
        ImageUtilities.disposeImage((RenderedImage)image);
    }

    @Test
    public void testContrastEnhancementInChannelSelectionAfterBandSelection() throws Exception {
        TestMultiBandReader reader = new TestMultiBandReader(0, 2, 4);
        this.applyAndAssertContrastEnhancement((GridCoverage2DReader)reader);
    }

    private RasterSymbolizer createClippingChannelSelectionSymbolizer(int min, int max) {
        StyleBuilder sldBuilder = new StyleBuilder();
        RasterSymbolizer symbolizer = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        SelectedChannelType[] channels = new SelectedChannelType[]{chTypeRed, chTypeGreen, chTypeBlue};
        for (int i = 0; i < 3; ++i) {
            ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
            NormalizeContrastMethodStrategy method = new NormalizeContrastMethodStrategy();
            method.addOption("algorithm", sldBuilder.literalExpression("ClipToZero"));
            method.addOption("minValue", sldBuilder.literalExpression(min + 20 * i));
            method.addOption("maxValue", sldBuilder.literalExpression(max + 20 * i));
            cntEnh.setMethod((ContrastMethodStrategy)method);
            channels[i].setChannelName(Integer.toString(i * 2 + 1));
            channels[i].setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        }
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeGreen, (SelectedChannelType)chTypeBlue);
        symbolizer.setChannelSelection((ChannelSelection)chSel);
        symbolizer.setOpacity(sldBuilder.literalExpression(1.0));
        return symbolizer;
    }

    @Test
    public void testContrastEnhancementInChannelSelectionAfterBandSelectionWithoutColorModel() throws Exception {
        TestMultiBandReader reader = new TestMultiBandReader(new int[]{0, 2, 4}){

            @Override
            public GridCoverage2D read(GeneralParameterValue[] parameters) throws IOException {
                GridCoverage2D originalCoverage = super.read(parameters);
                RenderedImage source = new ImageWorker(originalCoverage.getRenderedImage()).format(1).getRenderedImage();
                TiledImage shortImage = new TiledImage(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight(), source.getTileGridXOffset(), source.getTileGridYOffset(), source.getSampleModel(), null);
                shortImage.set(source);
                GridCoverage2D coverage = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)originalCoverage.getName(), (RenderedImage)shortImage, (Envelope)originalCoverage.getEnvelope2D());
                return coverage;
            }
        };
        this.applyAndAssertContrastEnhancement((GridCoverage2DReader)reader);
    }

    private void applyAndAssertContrastEnhancement(GridCoverage2DReader reader) throws TransformException, NoninvertibleTransformException, FactoryException, IOException {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, new Rectangle(0, 0, 255, 255), null);
        int min = 10;
        int max = 100;
        RasterSymbolizer symbolizer = this.createClippingChannelSelectionSymbolizer(min, max);
        RenderedImage image = renderer.renderImage(reader, null, symbolizer, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertEquals((long)3L, (long)image.getSampleModel().getNumBands());
        ImageWorker worker = new ImageWorker(image);
        double[] maximums = worker.getMaximums();
        Assert.assertEquals((double)max, (double)maximums[0], (double)0.0);
        Assert.assertEquals((double)(max + 20), (double)maximums[1], (double)0.0);
        Assert.assertEquals((double)(max + 40), (double)maximums[2], (double)0.0);
        ImageUtilities.disposeImage((RenderedImage)image);
    }

    @Test
    public void testChannelSelectionOrderWithBandSelection() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        TestMultiBandReader reader = new TestMultiBandReader(4, 2, 0);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, new Rectangle(0, 0, 255, 255), null);
        StyleBuilder sldBuilder = new StyleBuilder();
        RasterSymbolizer symbolizer = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        chTypeRed.setChannelName("5");
        chTypeGreen.setChannelName("3");
        chTypeBlue.setChannelName("1");
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeGreen, (SelectedChannelType)chTypeBlue);
        symbolizer.setChannelSelection((ChannelSelection)chSel);
        symbolizer.setOpacity(sldBuilder.literalExpression(1.0));
        Graphics2D graphics = TestMultiBandReader.image.createGraphics();
        renderer.paint(graphics, (GridCoverage2DReader)reader, null, symbolizer, Interpolation.getInstance((int)0), Color.BLACK);
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader, null, symbolizer, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertEquals((long)3L, (long)image.getSampleModel().getNumBands());
    }

    @Test
    public void testPaintBandSelectionNonSupportingReader() throws Exception {
        File coverageFile = TestData.copy((Object)this, (String)"geotiff/worldPalette.tiff");
        Assert.assertTrue((boolean)coverageFile.exists());
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        RasterSymbolizer rasterSymbolizer = this.buildChannelSelectingSymbolizer(1);
        BufferedImage bi = new BufferedImage(100, 100, 5);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)ReferencedEnvelope.reference((Envelope)reader.getOriginalEnvelope()), new Rectangle(0, 0, 100, 100), null);
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        renderer.paint(graphics, (GridCoverage2DReader)reader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.BLACK);
        graphics.dispose();
        double[] minimums = new ImageWorker((RenderedImage)bi).getMaximums();
        double[] maximums = new ImageWorker((RenderedImage)bi).getMaximums();
        Assert.assertThat((Object)maximums[0], (Matcher)Matchers.equalTo((Object)maximums[1]));
        Assert.assertThat((Object)maximums[1], (Matcher)Matchers.equalTo((Object)maximums[2]));
        Assert.assertThat((Object)minimums[0], (Matcher)Matchers.equalTo((Object)minimums[1]));
        Assert.assertThat((Object)minimums[1], (Matcher)Matchers.equalTo((Object)minimums[2]));
    }

    @Test
    public void testPaintSelectionSupportingReader() throws Exception {
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        TestSingleBandReader reader = new TestSingleBandReader(2);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)mapExtent, new Rectangle(0, 0, 100, 100), null);
        RasterSymbolizer rasterSymbolizer = this.buildChannelSelectingSymbolizer(3);
        BufferedImage bi = new BufferedImage(100, 100, 5);
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        renderer.paint(graphics, (GridCoverage2DReader)reader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.BLACK);
        double[] minimums = new ImageWorker((RenderedImage)bi).getMaximums();
        double[] maximums = new ImageWorker((RenderedImage)bi).getMaximums();
        Assert.assertThat((Object)maximums[0], (Matcher)Matchers.equalTo((Object)maximums[1]));
        Assert.assertThat((Object)maximums[1], (Matcher)Matchers.equalTo((Object)maximums[2]));
        Assert.assertThat((Object)minimums[0], (Matcher)Matchers.equalTo((Object)minimums[1]));
        Assert.assertThat((Object)minimums[1], (Matcher)Matchers.equalTo((Object)minimums[2]));
    }

    @Test
    public void testReprojectTransparency() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(0.0, 20.0, 20.0, 40.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm32n = CRS.decode((String)"EPSG:32632", (boolean)true);
        ReferencedEnvelope mapExtent = re.transform(utm32n, true);
        GridCoverage2D global = this.worldReader.read(null);
        CoverageProcessor processor = CoverageProcessor.getInstance((Hints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters().clone();
        param.parameter("source").setValue((Object)global);
        param.parameter("Envelope").setValue((Object)re);
        GridCoverage2D cropped = (GridCoverage2D)((Crop)processor.getOperation("CoverageCrop")).doOperation(param, null);
        BufferedImage bi = new BufferedImage(100, 100, 6);
        Graphics2D graphics = bi.createGraphics();
        GridCoverageRenderer renderer = new GridCoverageRenderer(utm32n, (org.locationtech.jts.geom.Envelope)mapExtent, new Rectangle(0, 0, 100, 100), null);
        renderer.paint(graphics, cropped, new StyleBuilder().createRasterSymbolizer());
        graphics.dispose();
        this.assertPixelIsTransparent(bi, 0, 0);
        this.assertPixelIsTransparent(bi, bi.getWidth() - 1, 0);
    }

    @Test
    public void testRenderOutsideBounds() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(0.0, 20.0, 20.0, 40.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D global = this.worldReader.read(null);
        CoverageProcessor processor = CoverageProcessor.getInstance((Hints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters().clone();
        param.parameter("source").setValue((Object)global);
        param.parameter("Envelope").setValue((Object)re);
        GridCoverage2D cropped = (GridCoverage2D)((Crop)processor.getOperation("CoverageCrop")).doOperation(param, null);
        ReferencedEnvelope reOutside = new ReferencedEnvelope(40.0, 60.0, 20.0, 40.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)reOutside, new Rectangle(0, 0, 100, 100), null);
        RasterSymbolizer symbolizer = new StyleBuilder().createRasterSymbolizer();
        Interpolation interpolation = Interpolation.getInstance((int)0);
        RenderedImage image = renderer.renderImage(cropped, symbolizer, interpolation, null, 256, 256);
        this.assertNull(image);
    }

    @Test
    public void testRenderOffDateline() throws Exception {
        File coverageFile = URLs.urlToFile((URL)GridCoverageReaderHelperTest.class.getResource("test-data/off_dateline.tif"));
        Assert.assertTrue((boolean)coverageFile.exists());
        GeoTiffReader offDatelineReader = new GeoTiffReader((Object)coverageFile);
        ReferencedEnvelope envelope = new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (org.locationtech.jts.geom.Envelope)envelope, new Rectangle(0, 0, 450, 450), null);
        RasterSymbolizer symbolizer = new StyleBuilder().createRasterSymbolizer();
        Interpolation interpolation = Interpolation.getInstance((int)0);
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)offDatelineReader, null, symbolizer, interpolation, null, 256, 256);
        Assert.assertNotNull((Object)image);
        image = new ImageWorker(image).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/offDateline.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testHighOversample() throws Exception {
        MapContent content = new MapContent();
        content.getViewport().setBounds(new ReferencedEnvelope(0.0, -0.002, 0.004, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        RasterSymbolizer rs = this.buildRainColorMap();
        Style style = new StyleBuilder().createStyle((Symbolizer)rs);
        content.addLayer((Layer)new GridReaderLayer(this.rainReader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(content);
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("advancedProjectionHandling", true);
        rendererParams.put("continuousMapWrapping", true);
        renderer.setRendererHints(rendererParams);
        BufferedImage image = RendererBaseTest.showRender("highOversample", (GTRenderer)renderer, 1000L, content.getViewport().getBounds());
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geotools/renderer/lite/rainHighOversample.png"), (RenderedImage)image, (int)1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestSpatialTwoReaders() throws Exception {
        File source = TestData.file(GridCoverageReaderHelperTest.class, (String)"red_footprint_test");
        File testDataDir = org.geotools.test.TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "redHarvest1");
        File directory2 = new File(testDataDir, "redHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("red[^3].*"), null)) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory2, file.getName())));
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        ImageMosaicReader reader = new ImageMosaicReader((Object)directory1, null);
        ImageMosaicReader reader2 = new ImageMosaicReader((Object)directory1, null);
        try {
            for (File file : directory2.listFiles()) {
                Assert.assertTrue((boolean)file.renameTo(new File(directory1, file.getName())));
            }
            reader.harvest(null, (Object)directory1, null);
            ReferencedEnvelope readEnvelope = new ReferencedEnvelope(991000.0, 992000.0, 216000.0, 217000.0, reader2.getCoordinateReferenceSystem());
            Rectangle rasterArea = new Rectangle(0, 0, 10, 10);
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(rasterArea), (Envelope)readEnvelope);
            AffineTransform affineTransform = mapper.createAffineTransform();
            GridCoverageRenderer renderer = new GridCoverageRenderer(reader2.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)readEnvelope, rasterArea, affineTransform);
            StyleBuilder sb = new StyleBuilder();
            RasterSymbolizer symbolizer = sb.createRasterSymbolizer();
            RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader2, null, symbolizer, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
            File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/red.png");
            ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
            MapContent mc = new MapContent();
            mc.addLayer((Layer)new GridReaderLayer((GridCoverage2DReader)reader2, sb.createStyle((Symbolizer)symbolizer)));
            StreamingRenderer sr = new StreamingRenderer();
            sr.setMapContent(mc);
            BufferedImage bi = new BufferedImage(rasterArea.width, rasterArea.height, 5);
            Graphics2D graphics = bi.createGraphics();
            sr.paint(graphics, rasterArea, readEnvelope);
            graphics.dispose();
            ImageAssert.assertEquals((File)reference, (RenderedImage)bi, (int)0);
        }
        finally {
            reader.dispose();
            reader2.dispose();
        }
    }

    protected void assertPixelIsTransparent(BufferedImage image, int i, int j) {
        int pixel = image.getRGB(i, j);
        Assert.assertEquals((Object)true, (Object)(pixel >> 24 == 0 ? 1 : 0));
    }

    private RasterSymbolizer buildChannelSelectingSymbolizer(int band) {
        StyleBuilder sb = new StyleBuilder();
        RasterSymbolizer symbolizer = sb.createRasterSymbolizer();
        StyleFactory sf = sb.getStyleFactory();
        symbolizer.setChannelSelection((ChannelSelection)sf.createChannelSelection(new SelectedChannelType[]{sf.createSelectedChannelType(String.valueOf(band), (ContrastEnhancement)null)}));
        return symbolizer;
    }

    private RasterSymbolizer buildEnvChannelSelectingSymbolizer(String envVar, int band) {
        StyleBuilder sb = new StyleBuilder();
        RasterSymbolizer symbolizer = sb.createRasterSymbolizer();
        StyleFactory sf = sb.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        symbolizer.setChannelSelection((ChannelSelection)sf.createChannelSelection(new SelectedChannelType[]{sf.createSelectedChannelType((Expression)ff.function("env", new Expression[]{ff.literal((Object)envVar), ff.literal(band)}), (ContrastEnhancement)null)}));
        return symbolizer;
    }

    @Test
    public void testPaintOutsideValidArea() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle((Symbolizer)sb.createRasterSymbolizer());
        MapContent content = new MapContent();
        content.addLayer((Layer)new GridReaderLayer(this.worldReader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        CountingRenderListener counter = new CountingRenderListener();
        renderer.addRenderListener((RenderListener)counter);
        renderer.setMapContent(content);
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("advancedProjectionHandling", true);
        renderer.setRendererHints(rendererParams);
        BufferedImage image = new BufferedImage(256, 256, 6);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3572", (boolean)true);
        ReferencedEnvelope envelope = new ReferencedEnvelope(-3.8207011656556E7, -1.2735670552185E7, 1.2735670552186E7, 3.8207011656556E7, crs);
        renderer.paint(g2d, new Rectangle(0, 0, 256, 256), envelope);
        g2d.dispose();
        content.dispose();
        Assert.assertEquals((long)0L, (long)counter.errors);
        Assert.assertEquals((long)0L, (long)counter.features);
    }

    @Test
    public void testNullSymbolizer() throws Exception {
        CoordinateReferenceSystem googleMercator = CRS.decode((String)"EPSG:3857");
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(-2.003750834E7, 2.003750834E7, -2.003750834E7, 2.003750834E7, googleMercator);
        Rectangle screenSize = new Rectangle(200, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 200.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(googleMercator, (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        GridCoverage2D coverage = this.worldReader.read(null);
        RenderedImage image = renderer.renderImage(coverage, null, Interpolation.getInstance((int)2), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/googleMercatorBicubic.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    @Test
    public void testPadding() throws Exception {
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        double envWidth = 30.0;
        double envHeight = 30.0;
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(0.0, 30.0, 0.0, 30.0, wgs84);
        Rectangle screenSize = new Rectangle(30, 30);
        this.checkPadding(screenSize, mapExtent, 4);
        this.checkPadding(screenSize, mapExtent, 12);
    }

    private void checkPadding(Rectangle screenSize, ReferencedEnvelope requestedEnvelope, int padding) throws FactoryException, IOException {
        Hints hints = new Hints((RenderingHints.Key)GridCoverageRenderer.PADDING, (Object)padding);
        GridCoverageReaderHelper helper = new GridCoverageReaderHelper(this.worldReader, screenSize, requestedEnvelope, Interpolation.getInstance((int)1), hints);
        ReferencedEnvelope readEnvelope = helper.getReadEnvelope();
        Assert.assertEquals((double)(requestedEnvelope.getWidth() + (double)(padding * 2)), (double)readEnvelope.getWidth(), (double)DELTA);
        Assert.assertEquals((double)(requestedEnvelope.getHeight() + (double)(padding * 2)), (double)readEnvelope.getHeight(), (double)DELTA);
    }

    @Test
    public void testMultiPixelPackedRender() throws Exception {
        GridCoverage2D coverage = this.multiPixelPacked.read(null);
        RenderedImage image = coverage.getRenderedImage();
        ReferencedEnvelope mapExtent = ReferencedEnvelope.reference((Envelope)coverage.getEnvelope2D());
        Rectangle screenSize = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(coverage.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        Style style = RendererBaseTest.loadStyle(this, "landWaterRaster.sld");
        RasterSymbolizer rasterSymbolizer = (RasterSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        RenderedImage rendered = renderer.renderImage(coverage, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/multiPixelPacked.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)rendered, (int)0);
        coverage.dispose(true);
    }

    @Test
    public void testChannelSelectOnRescaledDataset() throws Exception {
        URL coverageFile = org.geotools.test.TestData.url(GridCoverageRendererTest.class, (String)"scale_offset");
        ImageMosaicReader reader = new ImageMosaicReader((Object)coverageFile);
        ParameterValue rescalePixels = AbstractGridFormat.RESCALE_PIXELS.createValue();
        rescalePixels.setValue(true);
        ParameterValue bands = AbstractGridFormat.BANDS.createValue();
        bands.setValue((Object)new int[]{0});
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{rescalePixels, bands});
        NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
        Assert.assertNotNull((Object)noDataProperty);
        double noData = noDataProperty.getAsSingleValue();
        int noDataPixelCoordinateX = 7;
        int noDataPixelCoordinateY = 2;
        RenderedImage image = coverage.getRenderedImage();
        Raster raster = image.getData();
        double sample = raster.getSampleDouble(7, 2, 0);
        Assert.assertEquals((double)noData, (double)sample, (double)1.0E-6);
        ReferencedEnvelope mapExtent = ReferencedEnvelope.reference((Envelope)coverage.getEnvelope2D());
        Rectangle screenSize = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(coverage.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        Style style = RendererBaseTest.loadStyle(this, "sld1.sld");
        RasterSymbolizer rasterSymbolizer = (RasterSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        image = renderer.renderImage(coverage, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        ColorModel cm = image.getColorModel();
        Assert.assertTrue((boolean)(cm instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)cm;
        int transparentPixel = icm.getTransparentPixel();
        raster = image.getData();
        int sampleB = raster.getSample(7, 2, 0);
        Assert.assertEquals((long)transparentPixel, (long)sampleB);
        coverage.dispose(true);
    }

    @Test
    public void testContrastEnhancementWithNodataDataset() throws Exception {
        URL coverageFile = org.geotools.test.TestData.url(GridCoverageRendererTest.class, (String)"nodataNbands.tiff");
        GeoTiffReader reader = new GeoTiffReader((Object)coverageFile);
        GridCoverage2D coverage = reader.read(null);
        NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
        Assert.assertNotNull((Object)noDataProperty);
        double noData = noDataProperty.getAsSingleValue();
        int noDataPixelCoordinateX = 7;
        int noDataPixelCoordinateY = 2;
        RenderedImage image = coverage.getRenderedImage();
        Raster raster = image.getData();
        double sample = raster.getSampleDouble(7, 2, 0);
        Assert.assertEquals((double)noData, (double)sample, (double)1.0E-6);
        ReferencedEnvelope mapExtent = ReferencedEnvelope.reference((Envelope)coverage.getEnvelope2D());
        Rectangle screenSize = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(coverage.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        Style style = RendererBaseTest.loadStyle(this, "n_bands.sld");
        RasterSymbolizer rasterSymbolizer = (RasterSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        image = renderer.renderImage(coverage, rasterSymbolizer, Interpolation.getInstance((int)0), Color.RED, 256, 256);
        raster = image.getData();
        int sampleB = raster.getSample(7, 2, 0);
        Assert.assertEquals((long)0L, (long)sampleB);
        coverage.dispose(true);
    }

    @Test
    public void testRenderRadarOnAzeq() throws Exception {
        File file = URLs.urlToFile((URL)GridCoverageRendererTest.class.getResource("gridcoverage2d/test-data/pacific_radar.tif"));
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        System.out.println(reader.getCoordinateReferenceSystem());
        ReferencedEnvelope readerEnvelope = ReferencedEnvelope.reference((Envelope)reader.getOriginalEnvelope());
        CoordinateReferenceSystem crs = CRS.decode((String)"AUTO:97003,9001,170,-16", (boolean)true);
        ReferencedEnvelope azeqEnvelope = readerEnvelope.transform(crs, true);
        this.testImage(reader, azeqEnvelope, "pacificRadar.png");
    }

    @Test
    public void testRenderRadarOnAzeqZoomedIn() throws Exception {
        File file = URLs.urlToFile((URL)GridCoverageRendererTest.class.getResource("gridcoverage2d/test-data/pacific_radar.tif"));
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        CoordinateReferenceSystem crs = CRS.decode((String)"AUTO:97003,9001,170,-16", (boolean)true);
        ReferencedEnvelope azeqEnvelope = new ReferencedEnvelope(898340.67097417, 1127313.3142259, -8529.3690118708, 220443.2742399, crs);
        this.testImage(reader, azeqEnvelope, "pacificRadarZoomedIn.png");
    }

    @Test
    public void testRenderRadarOnCentralAzeq() throws Exception {
        File file = URLs.urlToFile((URL)GridCoverageRendererTest.class.getResource("gridcoverage2d/test-data/pacific_radar.tif"));
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        ReferencedEnvelope readerEnvelope = ReferencedEnvelope.reference((Envelope)reader.getOriginalEnvelope());
        CoordinateReferenceSystem crs = CRS.decode((String)"AUTO:97003,9001,0,0", (boolean)true);
        ReferencedEnvelope azeqEnvelope = new ReferencedEnvelope(-1.0698974E7, 1.0065735E7, -1.8709397E7, -1.4979931, crs);
        this.testImage(reader, azeqEnvelope, "pacificRadarCentralAzeq.png");
    }

    private void testImage(GeoTiffReader reader, ReferencedEnvelope vaiEnvelope, String fileName) throws TransformException, NoninvertibleTransformException, FactoryException, IOException {
        ReferencedEnvelope mapExtent = vaiEnvelope;
        Rectangle screenSize = new Rectangle(400, (int)(mapExtent.getHeight() / mapExtent.getWidth() * 400.0));
        AffineTransform w2s = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapExtent, (Rectangle)screenSize);
        GridCoverageRenderer renderer = new GridCoverageRenderer(mapExtent.getCoordinateReferenceSystem(), (org.locationtech.jts.geom.Envelope)mapExtent, screenSize, w2s);
        RasterSymbolizer rasterSymbolizer = this.buildRadardStyle();
        RenderedImage image = renderer.renderImage((GridCoverage2DReader)reader, null, rasterSymbolizer, Interpolation.getInstance((int)0), Color.BLACK, 256, 256);
        Assert.assertNotNull((Object)image);
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/" + fileName);
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)20);
    }

    private RasterSymbolizer buildRadardStyle() {
        StyleBuilder sb = new StyleBuilder();
        ColorMap cm = sb.createColorMap(new String[]{"a", "b"}, new double[]{-20.0, 50.0}, new Color[]{Color.RED, Color.GREEN}, 1);
        RasterSymbolizer rasterSymbolizer = sb.createRasterSymbolizer(cm, 1.0);
        return rasterSymbolizer;
    }

    private static class TestMultiBandReader
    extends AbstractGridCoverage2DReader {
        int[] expectedBands;
        static BufferedImage image;

        public TestMultiBandReader(int ... expectedBands) {
            this.expectedBands = expectedBands;
            this.originalEnvelope = new GeneralEnvelope((Envelope)new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            this.crs = DefaultGeographicCRS.WGS84;
        }

        public Format getFormat() {
            return new AbstractGridFormat(){

                public GridCoverageWriter getWriter(Object destination, Hints hints) {
                    throw new UnsupportedOperationException();
                }

                public GridCoverageWriter getWriter(Object destination) {
                    throw new UnsupportedOperationException();
                }

                public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
                    throw new UnsupportedOperationException();
                }

                public AbstractGridCoverage2DReader getReader(Object source) {
                    throw new UnsupportedOperationException();
                }

                public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
                    return null;
                }

                public boolean accepts(Object source, Hints hints) {
                    throw new UnsupportedOperationException();
                }

                public ParameterValueGroup getReadParameters() {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("name", "bandTester");
                    info.put("description", "desc");
                    info.put("vendor", "vendor");
                    info.put("docURL", "http://www.geotools.org");
                    info.put("version", "1.0");
                    ArrayList<DefaultParameterDescriptor> params = new ArrayList<DefaultParameterDescriptor>();
                    params.add(AbstractGridFormat.BANDS);
                    return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(info, params.toArray(new GeneralParameterDescriptor[params.size()])));
                }
            };
        }

        public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
            for (GeneralParameterValue parameter : parameters) {
                if (!"Bands".equals(parameter.getDescriptor().getName().toString())) continue;
                Assert.assertTrue((boolean)Arrays.equals(this.expectedBands, (int[])((ParameterValue)parameter).getValue()));
            }
            BufferedImage bi = image;
            GridCoverage2D coverage = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"test", (RenderedImage)bi, (Envelope)this.getOriginalEnvelope());
            return coverage;
        }

        static {
            int width = 255;
            int height = 255;
            image = new BufferedImage(255, 255, 5);
            WritableRaster raster = image.getRaster();
            for (int i = 0; i < 255; ++i) {
                for (int j = 0; j < 255; ++j) {
                    for (int b = 0; b < 3; ++b) {
                        raster.setSample(i, j, b, i);
                    }
                }
            }
        }
    }

    private static class TestSingleBandReader
    extends AbstractGridCoverage2DReader {
        int[] expectedBands;

        public TestSingleBandReader(int ... expectedBands) {
            this.expectedBands = expectedBands;
            this.originalEnvelope = new GeneralEnvelope((Envelope)new ReferencedEnvelope(0.0, 90.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            this.crs = DefaultGeographicCRS.WGS84;
        }

        public Format getFormat() {
            return new AbstractGridFormat(){

                public GridCoverageWriter getWriter(Object destination, Hints hints) {
                    throw new UnsupportedOperationException();
                }

                public GridCoverageWriter getWriter(Object destination) {
                    throw new UnsupportedOperationException();
                }

                public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
                    throw new UnsupportedOperationException();
                }

                public AbstractGridCoverage2DReader getReader(Object source) {
                    throw new UnsupportedOperationException();
                }

                public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
                    return null;
                }

                public boolean accepts(Object source, Hints hints) {
                    throw new UnsupportedOperationException();
                }

                public ParameterValueGroup getReadParameters() {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("name", "bandTester");
                    info.put("description", "desc");
                    info.put("vendor", "vendor");
                    info.put("docURL", "http://www.geotools.org");
                    info.put("version", "1.0");
                    ArrayList<DefaultParameterDescriptor> params = new ArrayList<DefaultParameterDescriptor>();
                    params.add(AbstractGridFormat.BANDS);
                    return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(info, params.toArray(new GeneralParameterDescriptor[params.size()])));
                }
            };
        }

        public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
            Assert.assertTrue((boolean)Arrays.stream(parameters).anyMatch(p -> "Bands".equals(p.getDescriptor().getName().toString()) && Arrays.equals(this.expectedBands, (int[])((ParameterValue)p).getValue())));
            BufferedImage bi = new BufferedImage(100, 100, 10);
            Graphics2D graphics = bi.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
            graphics.dispose();
            GridCoverage2D coverage = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"test", (RenderedImage)bi, (Envelope)this.getOriginalEnvelope());
            return coverage;
        }
    }
}

