/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.File;
import java.io.IOException;
import org.geotools.data.Query;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.util.DefaultProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.renderer.lite.MarkFeatureIterator;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.util.ProgressListener;

public class MarkFeatureIteratorTest {
    SimpleFeatureSource zroads;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"zorder/zroads.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.zroads = ds.getFeatureSource("zroads");
    }

    @Test
    public void testResetOnDisk() throws Exception {
        this.testReset(0);
    }

    @Test
    public void testResetInMemory() throws Exception {
        this.testReset(1000);
    }

    @Test
    public void testCanceled() throws Exception {
        DefaultProgressListener listener = new DefaultProgressListener();
        listener.setCanceled(true);
        MarkFeatureIterator iterator = MarkFeatureIterator.create((FeatureCollection)this.zroads.getFeatures(), (int)1000, (ProgressListener)listener);
        Assert.assertNull((Object)iterator);
    }

    private void testReset(int limit) throws IOException {
        DefaultProgressListener listener = new DefaultProgressListener();
        try (MarkFeatureIterator iterator = MarkFeatureIterator.create((FeatureCollection)this.zroads.getFeatures(), (int)limit, (ProgressListener)listener);){
            if (limit >= this.zroads.getCount(Query.ALL)) {
                Assert.assertTrue((boolean)(iterator instanceof MarkFeatureIterator.MemoryMarkFeatureIterator));
            } else {
                Assert.assertTrue((boolean)(iterator instanceof MarkFeatureIterator.DiskMarkFeatureIterator));
            }
            iterator.mark();
            this.assertThreeFeatures(iterator);
            iterator.reset();
            this.assertThreeFeatures(iterator);
        }
    }

    private void assertThreeFeatures(MarkFeatureIterator iterator) {
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"Line.1", (Object)iterator.next().getIdentifier().getID());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"Line.2", (Object)iterator.next().getIdentifier().getID());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"Line.3", (Object)iterator.next().getIdentifier().getID());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

