/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.sld.v1_1.SLDConfiguration;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.test.TestData;
import org.geotools.xml.styling.SLDParser;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.picocontainer.MutablePicoContainer;

public abstract class RendererBaseTest {
    protected RendererBaseTest() {
    }

    protected static BufferedImage showRender(String testName, GTRenderer renderer, long timeOut, ReferencedEnvelope ... bounds) throws Exception {
        return RendererBaseTest.showRender(testName, renderer, timeOut, bounds, null);
    }

    protected static BufferedImage showRender(String testName, GTRenderer renderer, long timeOut, ReferencedEnvelope[] bounds, RenderListener listener) throws Exception {
        BufferedImage[] images = new BufferedImage[bounds.length];
        for (int i = 0; i < images.length; ++i) {
            images[i] = RendererBaseTest.renderImage(renderer, bounds[i], listener);
        }
        if (renderer.getMapContent() != null) {
            renderer.getMapContent().dispose();
        }
        BufferedImage image = RendererBaseTest.mergeImages(images);
        RendererBaseTest.showImage(testName, timeOut, image);
        boolean hasData = false;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getRGB(x, y) == 0) continue;
                hasData = true;
            }
        }
        assert (hasData);
        return image;
    }

    public static void showImage(String testName, long timeOut, final BufferedImage image) throws InterruptedException {
        String headless = System.getProperty("java.awt.headless", "false");
        if (!headless.equalsIgnoreCase("true") && TestData.isInteractiveTest()) {
            try {
                Frame frame = new Frame(testName);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        e.getWindow().dispose();
                    }
                });
                Panel p = new Panel(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
                    }

                    @Override
                    public void paint(Graphics g) {
                        g.drawImage(image, 0, 0, this);
                    }
                };
                frame.add(p);
                frame.pack();
                frame.setVisible(true);
                Thread.sleep(timeOut);
                frame.dispose();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }

    public static BufferedImage renderImage(GTRenderer renderer, ReferencedEnvelope bounds, RenderListener listener) {
        int w = 300;
        int h = 300;
        return RendererBaseTest.renderImage(renderer, bounds, listener, w, h);
    }

    public static BufferedImage renderImage(GTRenderer renderer, ReferencedEnvelope bounds, RenderListener listener, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        RendererBaseTest.render(renderer, g, new Rectangle(w, h), bounds, listener);
        return image;
    }

    public static BufferedImage mergeImages(BufferedImage[] images) {
        int totalWidth = 0;
        int height = 0;
        for (BufferedImage bufferedImage : images) {
            totalWidth += bufferedImage.getWidth();
            height = Math.max(height, bufferedImage.getHeight());
        }
        BufferedImage joinedImage = new BufferedImage(totalWidth, height, 2);
        Graphics g = joinedImage.getGraphics();
        int x = 0;
        for (BufferedImage bufferedImage : images) {
            g.drawImage(bufferedImage, x, 0, null);
            x += bufferedImage.getWidth();
        }
        return joinedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void render(GTRenderer renderer, Graphics g, Rectangle rect, ReferencedEnvelope bounds, RenderListener rendererListener) {
        try {
            if (rendererListener != null) {
                renderer.addRenderListener(rendererListener);
            }
            if (bounds == null) {
                renderer.paint((Graphics2D)g, rect, new AffineTransform());
            } else {
                renderer.paint((Graphics2D)g, rect, bounds);
            }
        }
        finally {
            if (rendererListener != null) {
                renderer.removeRenderListener(rendererListener);
            }
        }
    }

    public static BufferedImage render(MapContent map) throws Exception {
        StreamingRenderer r = new StreamingRenderer();
        r.setMapContent(map);
        return RendererBaseTest.showRender("testPointLabeling", (GTRenderer)r, 5000L, map.getMaxBounds());
    }

    public static Style loadStyle(Object loader, String sldFilename) throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)loader, (String)sldFilename);
        SLDParser stylereader = new SLDParser(factory, surl);
        Style style = stylereader.readXML()[0];
        return style;
    }

    protected static Style loadSEStyle(Object loader, String sldFilename) throws IOException {
        try {
            final URL surl = TestData.getResource((Object)loader, (String)sldFilename);
            SLDConfiguration configuration = new SLDConfiguration(){

                protected void configureContext(MutablePicoContainer container) {
                    DefaultResourceLocator locator = new DefaultResourceLocator();
                    locator.setSourceUrl(surl);
                    container.registerComponentInstance(ResourceLocator.class, (Object)locator);
                }
            };
            Parser parser = new Parser((Configuration)configuration);
            StyledLayerDescriptor sld = (StyledLayerDescriptor)parser.parse(surl.openStream());
            for (int i = 0; i < sld.getStyledLayers().length; ++i) {
                Style[] styles = null;
                if (sld.getStyledLayers()[i] instanceof NamedLayer) {
                    NamedLayer layer = (NamedLayer)sld.getStyledLayers()[i];
                    styles = layer.getStyles();
                } else if (sld.getStyledLayers()[i] instanceof UserLayer) {
                    UserLayer layer = (UserLayer)sld.getStyledLayers()[i];
                    styles = layer.getUserStyles();
                }
                if (styles == null) continue;
                int j = 0;
                while (j < styles.length) {
                    if (!(styles[j] instanceof NamedStyle)) {
                        return styles[j];
                    }
                    ++i;
                }
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    public static void assertPixel(BufferedImage image, int i, int j, Color color) {
        Color actual = RendererBaseTest.getPixelColor(image, i, j);
        Assert.assertEquals((Object)color, (Object)actual);
    }

    public static void assertPixel(BufferedImage image, int i, int j, Color color, int tolerance) {
        Color actual = RendererBaseTest.getPixelColor(image, i, j);
        Assert.assertTrue((Math.abs(color.getRed() - actual.getRed()) < tolerance ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(color.getGreen() - actual.getGreen()) < tolerance ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(color.getBlue() - actual.getBlue()) < tolerance ? 1 : 0) != 0);
    }

    private static Color getPixelColor(BufferedImage image, int i, int j) {
        ColorModel cm = image.getColorModel();
        WritableRaster raster = image.getRaster();
        Object pixel = raster.getDataElements(i, j, null);
        Color actual = cm.hasAlpha() ? new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), cm.getAlpha(pixel)) : new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), 255);
        return actual;
    }

    public static void setupVeraFonts() throws IOException, FontFormatException {
        FontCache.getDefaultInstance().registerFont(Font.createFont(0, TestData.getResource(RendererBaseTest.class, (String)"Vera.ttf").openStream()));
    }
}

