/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.TestData;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.GridCoverageRendererTest;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.coverage.grid.Format;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RenderingTransformationTest {
    private static final long TIME = 4000L;

    @BeforeClass
    public static void setup() {
        System.setProperty("org.geotools.referencing.forceXY", "false");
        CRS.reset((String)"all");
    }

    @AfterClass
    public static void tearDown() {
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
    }

    @Test
    public void testTransformReprojectedGridReader() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "coverageCenter.sld");
        GeoTiffReader reader = new GeoTiffReader((Object)TestData.copy((Object)this, (String)"geotiff/world.tiff"));
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridReaderLayer((GridCoverage2DReader)reader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        ReferencedEnvelope reWgs84 = new ReferencedEnvelope(-70.0, 70.0, -160.0, 160.0, CRS.decode((String)"EPSG:4326"));
        ReferencedEnvelope re = reWgs84.transform(CRS.decode((String)"EPSG:3857"), true);
        BufferedImage image = RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)renderer, 4000L, re);
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 4, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 4));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 4, image.getHeight() / 4));
    }

    @Test
    public void testTransformBBOXIsCorrect() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "noop_colormap.sld");
        GeoTiffReader reader = new GeoTiffReader((Object)TestData.file((Object)this, (String)"watertemp.tiff"));
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridReaderLayer((GridCoverage2DReader)reader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        CRSAuthorityFactory factory = CRS.getAuthorityFactory((boolean)true);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem("EPSG:4326");
        ReferencedEnvelope reWgs84 = new ReferencedEnvelope(9.848993475036622, 11.958867853088378, 40.74254816253662, 41.64941961090088, crs);
        BufferedImage image = RendererBaseTest.showRender("Transform BBOX", (GTRenderer)renderer, 4000L, reWgs84);
        Assert.assertNotEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, 299, 0));
        Assert.assertEquals((Object)new Color(133, 130, 188), (Object)this.getPixelColor(image, 299, 0));
    }

    @Test
    public void testRasterToVectorTransformAcrossDateline() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "coverageCenter.sld");
        GeoTiffReader reader = new GeoTiffReader((Object)TestData.copy((Object)this, (String)"geotiff/world.tiff"));
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridCoverageLayer(reader.read(null), style));
        StreamingRenderer renderer = new StreamingRenderer();
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("advancedProjectionHandling", true);
        rendererParams.put("continuousMapWrapping", true);
        renderer.setRendererHints(rendererParams);
        renderer.setMapContent(mc);
        ReferencedEnvelope reWgs84 = new ReferencedEnvelope(-90.0, 90.0, 0.0, 360.0, CRS.decode((String)"EPSG:4326"));
        BufferedImage image = RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)renderer, 4000L, reWgs84);
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, 0, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, image.getWidth() - 1, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() - 1, image.getHeight() / 4));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, 0, image.getHeight() / 4));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 4, image.getHeight() / 4));
    }

    @Test
    public void testRasterToTransformVectorPastDateline() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "coverageCenter.sld");
        GeoTiffReader reader = new GeoTiffReader((Object)TestData.copy((Object)this, (String)"geotiff/world.tiff"));
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridCoverageLayer(reader.read(null), style));
        StreamingRenderer renderer = new StreamingRenderer();
        HashMap<String, Boolean> rendererParams = new HashMap<String, Boolean>();
        rendererParams.put("advancedProjectionHandling", true);
        rendererParams.put("continuousMapWrapping", true);
        renderer.setRendererHints(rendererParams);
        renderer.setMapContent(mc);
        ReferencedEnvelope reWgs84 = new ReferencedEnvelope(-70.0, 70.0, 200.0, 520.0, CRS.decode((String)"EPSG:4326"));
        ReferencedEnvelope re = reWgs84.transform(CRS.decode((String)"EPSG:3857"), true);
        BufferedImage image = RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)renderer, 4000L, re);
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 4, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 4));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 4, image.getHeight() / 4));
    }

    @Test
    public void testTransformReprojectedGridCoverage() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "coverageCenter.sld");
        GeoTiffReader reader = new GeoTiffReader((Object)TestData.copy((Object)this, (String)"geotiff/world.tiff"));
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridCoverageLayer(reader.read(null), style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        ReferencedEnvelope reWgs84 = new ReferencedEnvelope(-70.0, 70.0, -160.0, 160.0, CRS.decode((String)"EPSG:4326"));
        ReferencedEnvelope re = reWgs84.transform(CRS.decode((String)"EPSG:3857"), true);
        BufferedImage image = RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)renderer, 4000L, re);
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 4, image.getHeight() / 2));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 4));
        Assert.assertEquals((Object)Color.WHITE, (Object)this.getPixelColor(image, image.getWidth() / 4, image.getHeight() / 4));
    }

    @Test
    public void testTransformNullCoverage() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "coverageCenter.sld");
        AbstractGridCoverage2DReader reader = new AbstractGridCoverage2DReader(){

            public Format getFormat() {
                return null;
            }

            public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
                return null;
            }
        };
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridReaderLayer((GridCoverage2DReader)reader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        ReferencedEnvelope re = new ReferencedEnvelope(-70.0, 70.0, -160.0, 160.0, CRS.decode((String)"EPSG:4326"));
        BufferedImage image = RendererBaseTest.showRender("Transformation with null input", (GTRenderer)renderer, 4000L, re);
        double[] minimums = new ImageWorker((RenderedImage)image).getMinimums();
        Assert.assertEquals((double)255.0, (double)minimums[0], (double)0.0);
        Assert.assertEquals((double)255.0, (double)minimums[1], (double)0.0);
        Assert.assertEquals((double)255.0, (double)minimums[2], (double)0.0);
        Assert.assertEquals((double)255.0, (double)minimums[3], (double)0.0);
    }

    @Test
    public void testTransformWithQueryNoInvert() throws Exception {
        this.testTransformWithQuery(false);
    }

    @Test
    public void testTransformWithQueryInvert() throws Exception {
        this.testTransformWithQuery(true);
    }

    private void testTransformWithQuery(boolean invert) throws IOException, URISyntaxException, CQLException, NoSuchAuthorityCodeException, FactoryException, Exception {
        Style style = RendererBaseTest.loadStyle(this, invert ? "attributeRename.sld" : "attributeRenameNoInvert.sld");
        File property = new File(TestData.getResource((Object)this, (String)"point.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        ContentFeatureSource fs = ds.getFeatureSource("point");
        FeatureLayer layer = new FeatureLayer((FeatureSource)fs, style);
        layer.setQuery(new Query(null, CQL.toFilter((String)"id > 5")));
        MapContent mc = new MapContent();
        mc.addLayer((Layer)layer);
        StreamingRenderer renderer = new StreamingRenderer();
        final AtomicInteger counter = new AtomicInteger();
        renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                counter.incrementAndGet();
            }

            public void errorOccurred(Exception e) {
            }
        });
        renderer.setMapContent(mc);
        ReferencedEnvelope re = new ReferencedEnvelope(0.0, 12.0, 0.0, 12.0, CRS.decode((String)"EPSG:4326"));
        BufferedImage image = RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)renderer, 4000L, re);
        Assert.assertEquals((long)1L, (long)counter.get());
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 2));
    }

    @Test
    public void testTransformReproject() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "reproject-rt.sld");
        File property = new File(TestData.getResource((Object)this, (String)"point.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        ContentFeatureSource fs = ds.getFeatureSource("point");
        FeatureLayer layer = new FeatureLayer((FeatureSource)fs, style);
        ReferencedEnvelope reWgs84 = new ReferencedEnvelope(0.0, 12.0, 0.0, 12.0, CRS.decode((String)"EPSG:4326"));
        ReferencedEnvelope reUTM32N = reWgs84.transform(CRS.decode((String)"EPSG:3857"), true);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)layer);
        StreamingRenderer renderer = new StreamingRenderer();
        final AtomicInteger counter = new AtomicInteger();
        renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                counter.incrementAndGet();
            }

            public void errorOccurred(Exception e) {
            }
        });
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)renderer, 4000L, reUTM32N);
        Assert.assertEquals((long)10L, (long)counter.get());
        Assert.assertEquals((Object)Color.RED, (Object)this.getPixelColor(image, image.getWidth() / 2, image.getHeight() / 2));
    }

    protected Color getPixelColor(BufferedImage image, int i, int j) {
        ColorModel cm = image.getColorModel();
        WritableRaster raster = image.getRaster();
        Object pixel = raster.getDataElements(i, j, null);
        Color actual = cm.hasAlpha() ? new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), cm.getAlpha(pixel)) : new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), 255);
        return actual;
    }

    @Test
    public void testRenderingTransformHighOversample() throws Exception {
        File file = TestData.copy((Object)this, (String)"arcgrid/arcgrid.zip");
        TestData.unzipFile((Object)this, (String)"arcgrid/arcgrid.zip");
        URL rainURL = GridCoverageRendererTest.class.getResource("test-data/arcgrid/precip30min.asc");
        File rainFile = URLs.urlToFile((URL)rainURL);
        ArcGridReader rainReader = new ArcGridReader((Object)rainFile);
        Style style = RendererBaseTest.loadStyle(this, "rainrt.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new GridReaderLayer((GridCoverage2DReader)rainReader, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        ReferencedEnvelope polarEnvelope = new ReferencedEnvelope(113000.0, 1045000.0, -113000.0, 1045000.0, CRS.decode((String)"EPSG:3995", (boolean)true));
        BufferedImage image = RendererBaseTest.showRender("High oversample, rendering transform and reprojection", (GTRenderer)renderer, 4000L, polarEnvelope);
        File expected = new File("src/test/resources/org/geotools/renderer/lite/rainrt.png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)100);
    }
}

