/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.xml.transform.TransformerException;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.ImageAssert;
import org.geotools.image.util.ComponentColorModelJAI;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.ContrastMethodStrategy;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.NormalizeContrastMethodStrategy;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.test.TestData;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ColorMap;
import org.opengis.style.ContrastMethod;

public class RasterSymbolizerTest
extends Assert {
    private static final StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private static final double DELTA = 1.0E-7;

    public static RenderedImage getSynthetic(double noDataValue) {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)500, (int)500, (int)1, null);
        Random random = new Random();
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                if ((double)random.nextFloat() > 0.9) {
                    raster.setSample(x, y, 0, noDataValue);
                    continue;
                }
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModelJAI cm = new ComponentColorModelJAI(ColorSpace.getInstance(1003), false, false, 1, 5);
        BufferedImage image = new BufferedImage((ColorModel)cm, raster, false, null);
        return image;
    }

    @Test
    public void contrastEnhancementMethods() throws Exception {
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)((Object)this), (String)"histogram.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        RasterSymbolizerHelper rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh_StyleBuilder.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        surl = TestData.url((Object)((Object)this), (String)"logarithmic.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_2 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_2);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_2 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_2 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_2 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_2 = new ContrastEnhancementImpl();
        cntEnh_2.setMethod(ContrastMethod.LOGARITHMIC);
        chTypeGray_2.setChannelName("1");
        chTypeGray_2.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_2);
        chSel_2.setGrayChannel((SelectedChannelType)chTypeGray_2);
        rsb_2.setChannelSelection((ChannelSelection)chSel_2);
        rsb_2.setOpacity(sldBuilder.literalExpression(1.0));
        rsh_StyleBuilder.visit(rsb_2);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        surl = TestData.url((Object)((Object)this), (String)"exponential.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_3 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_3);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_3 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_3 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_3 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_3 = new ContrastEnhancementImpl();
        cntEnh_3.setMethod(ContrastMethod.EXPONENTIAL);
        chTypeGray_3.setChannelName("1");
        chTypeGray_3.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_3);
        chSel_3.setGrayChannel((SelectedChannelType)chTypeGray_3);
        rsb_3.setChannelSelection((ChannelSelection)chSel_3);
        rsb_3.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_3.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh_StyleBuilder.visit(rsb_3);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        surl = TestData.url((Object)((Object)this), (String)"normalize-stretch.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_4 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_4);
        GridCoverage2D output = (GridCoverage2D)rsh_SLD.getOutput();
        ImageWorker worker = new ImageWorker(output.getRenderedImage());
        double[] min = worker.getMinimums();
        double[] max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)0.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)255.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"test_ushort.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_4 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_4 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_4 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_4 = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_4 = new NormalizeContrastMethodStrategy();
        method_4.addOption("algorithm", sldBuilder.literalExpression("StretchToMinimumMaximum"));
        method_4.addOption("minValue", sldBuilder.literalExpression(10));
        method_4.addOption("maxValue", sldBuilder.literalExpression(50));
        cntEnh_4.setMethod((ContrastMethodStrategy)method_4);
        chTypeGray_4.setChannelName("1");
        chTypeGray_4.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_4);
        chSel_4.setGrayChannel((SelectedChannelType)chTypeGray_4);
        rsb_4.setChannelSelection((ChannelSelection)chSel_4);
        rsh_StyleBuilder.visit(rsb_4);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)0.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)255.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"Float", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"smalldem.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_4f = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_4f = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_4f = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_4f = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_4f = new NormalizeContrastMethodStrategy();
        method_4f.addOption("algorithm", sldBuilder.literalExpression("StretchToMinimumMaximum"));
        method_4f.addOption("minValue", sldBuilder.literalExpression(10));
        method_4f.addOption("maxValue", sldBuilder.literalExpression(1200));
        cntEnh_4f.setMethod((ContrastMethodStrategy)method_4);
        chTypeGray_4f.setChannelName("1");
        chTypeGray_4f.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_4f);
        chSel_4f.setGrayChannel((SelectedChannelType)chTypeGray_4f);
        rsb_4f.setChannelSelection((ChannelSelection)chSel_4f);
        rsh_StyleBuilder.visit(rsb_4f);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)0.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)255.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        surl = TestData.url((Object)((Object)this), (String)"normalize-clip.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_5 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_5);
        output = (GridCoverage2D)rsh_SLD.getOutput();
        worker = new ImageWorker(output.getRenderedImage());
        worker.setNoData(RangeFactory.create((int)0, (int)0));
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)10.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)100.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_5 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_5 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_5 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_5 = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_5 = new NormalizeContrastMethodStrategy();
        method_5.addOption("algorithm", sldBuilder.literalExpression("ClipToMinimumMaximum"));
        method_5.addOption("minValue", sldBuilder.literalExpression(50));
        method_5.addOption("maxValue", sldBuilder.literalExpression(200));
        cntEnh_5.setMethod((ContrastMethodStrategy)method_5);
        chTypeGray_5.setChannelName("1");
        chTypeGray_5.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_5);
        chSel_5.setGrayChannel((SelectedChannelType)chTypeGray_5);
        rsb_5.setChannelSelection((ChannelSelection)chSel_5);
        rsh_StyleBuilder.visit(rsb_5);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        worker = new ImageWorker(output.getRenderedImage());
        worker.setNoData(RangeFactory.create((int)0, (int)0));
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)50.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)200.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"smalldem.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_5f = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_5f = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_5f = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_5f = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_5f = new NormalizeContrastMethodStrategy();
        method_5f.addOption("algorithm", sldBuilder.literalExpression("ClipToMinimumMaximum"));
        method_5f.addOption("minValue", sldBuilder.literalExpression(50));
        method_5f.addOption("maxValue", sldBuilder.literalExpression(200));
        cntEnh_5f.setMethod((ContrastMethodStrategy)method_5f);
        chTypeGray_5f.setChannelName("1");
        chTypeGray_5f.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_5f);
        chSel_5f.setGrayChannel((SelectedChannelType)chTypeGray_5f);
        rsb_5f.setChannelSelection((ChannelSelection)chSel_5f);
        rsh_StyleBuilder.visit(rsb_5f);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        worker.setNoData(RangeFactory.create((int)0, (int)0));
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)50.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)200.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"smalldem.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_5g = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_5g = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_5g = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_5g = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_5g = new NormalizeContrastMethodStrategy();
        method_5g.addOption("algorithm", sldBuilder.literalExpression("ClipToMinimumMaximum"));
        method_5g.addOption("minValue", sldBuilder.literalExpression(50));
        method_5g.addOption("maxValue", sldBuilder.literalExpression(1200));
        cntEnh_5g.setMethod((ContrastMethodStrategy)method_5g);
        chTypeGray_5g.setChannelName("1");
        chTypeGray_5g.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_5g);
        chSel_5g.setGrayChannel((SelectedChannelType)chTypeGray_5g);
        rsb_5g.setChannelSelection((ChannelSelection)chSel_5g);
        rsh_StyleBuilder.visit(rsb_5g);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        worker.setNoData(RangeFactory.create((int)0, (int)0));
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)10.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)255.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        RenderedImage source = new ImageWorker(new File(TestData.url((Object)((Object)this), (String)"small_4bands_UInt16.tif").toURI())).retainBands(new int[]{2}).getRenderedImage();
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", source, (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"band")}, null, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_5c = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_5c = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_5c = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_5c = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_5c = new NormalizeContrastMethodStrategy();
        method_5c.addOption("algorithm", sldBuilder.literalExpression("ClipToMinimumMaximum"));
        method_5c.addOption("minValue", sldBuilder.literalExpression(50));
        method_5c.addOption("maxValue", sldBuilder.literalExpression(500));
        cntEnh_5c.setMethod((ContrastMethodStrategy)method_5c);
        chTypeGray_5c.setChannelName("1");
        chTypeGray_5c.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_5c);
        chSel_5c.setGrayChannel((SelectedChannelType)chTypeGray_5c);
        rsb_5c.setChannelSelection((ChannelSelection)chSel_5c);
        rsh_StyleBuilder.visit(rsb_5c);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        worker.setNoData(RangeFactory.create((int)0, (int)0));
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)1.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)255.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"hs.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_6 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_6 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_6 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_6 = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_6 = new NormalizeContrastMethodStrategy();
        method_6.setAlgorithm(sldBuilder.literalExpression("ClipToZero"));
        method_6.addOption("minValue", sldBuilder.literalExpression(50));
        method_6.addOption("maxValue", sldBuilder.literalExpression(100));
        cntEnh_6.setMethod((ContrastMethodStrategy)method_6);
        chTypeGray_6.setChannelName("1");
        chTypeGray_6.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_6);
        chSel_6.setGrayChannel((SelectedChannelType)chTypeGray_6);
        rsb_6.setChannelSelection((ChannelSelection)chSel_6);
        rsb_6.setOpacity(sldBuilder.literalExpression(1.0));
        rsh_StyleBuilder.visit(rsb_6);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        worker = new ImageWorker(output.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)0.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)100.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"test_ushort.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        worker = new ImageWorker(gc.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_7 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_7 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_7 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_7 = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_7 = new NormalizeContrastMethodStrategy();
        method_7.setAlgorithm(sldBuilder.literalExpression("ClipToZero"));
        method_7.addParameter("minValue", sldBuilder.literalExpression(50));
        method_7.addParameter("maxValue", sldBuilder.literalExpression(18000));
        cntEnh_7.setMethod((ContrastMethodStrategy)method_7);
        chTypeGray_7.setChannelName("1");
        chTypeGray_7.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_7);
        chSel_7.setGrayChannel((SelectedChannelType)chTypeGray_7);
        rsb_7.setChannelSelection((ChannelSelection)chSel_7);
        rsb_7.setOpacity(sldBuilder.literalExpression(1.0));
        rsh_StyleBuilder.visit(rsb_7);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)0.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)255.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"smalldem.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        worker = new ImageWorker(gc.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_7f = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_7f = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_7f = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_7f = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_7f = new NormalizeContrastMethodStrategy();
        method_7f.setAlgorithm(sldBuilder.literalExpression("ClipToZero"));
        method_7f.addParameter("minValue", sldBuilder.literalExpression(50));
        method_7f.addParameter("maxValue", sldBuilder.literalExpression(200));
        cntEnh_7f.setMethod((ContrastMethodStrategy)method_7f);
        chTypeGray_7f.setChannelName("1");
        chTypeGray_7f.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_7f);
        chSel_7f.setGrayChannel((SelectedChannelType)chTypeGray_7f);
        rsb_7f.setChannelSelection((ChannelSelection)chSel_7f);
        rsb_7f.setOpacity(sldBuilder.literalExpression(1.0));
        rsh_StyleBuilder.visit(rsb_7f);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)0.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)200.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"smalldem.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        worker = new ImageWorker(gc.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_7g = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_7g = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_7g = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_7g = new ContrastEnhancementImpl();
        NormalizeContrastMethodStrategy method_7g = new NormalizeContrastMethodStrategy();
        method_7g.setAlgorithm(sldBuilder.literalExpression("ClipToZero"));
        method_7g.addParameter("minValue", sldBuilder.literalExpression(50));
        method_7g.addParameter("maxValue", sldBuilder.literalExpression(1200));
        cntEnh_7g.setMethod((ContrastMethodStrategy)method_7g);
        chTypeGray_7g.setChannelName("1");
        chTypeGray_7g.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh_7g);
        chSel_7g.setGrayChannel((SelectedChannelType)chTypeGray_7g);
        rsb_7g.setChannelSelection((ChannelSelection)chSel_7g);
        rsb_7g.setOpacity(sldBuilder.literalExpression(1.0));
        rsh_StyleBuilder.visit(rsb_7g);
        output = (GridCoverage2D)rsh_StyleBuilder.getOutput();
        RasterSymbolizerTest.assertEquals((long)0L, (long)output.getRenderedImage().getSampleModel().getDataType());
        worker = new ImageWorker(output.getRenderedImage());
        min = worker.getMinimums();
        max = worker.getMaximums();
        RasterSymbolizerTest.assertEquals((double)0.0, (double)min[0], (double)1.0E-7);
        RasterSymbolizerTest.assertEquals((double)255.0, (double)max[0], (double)1.0E-7);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
    }

    @Test
    public void bandFloat32_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_1band_Float32.tif").toURI())), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)((Object)this), (String)"1band_Float32_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_1band_Float32.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.LOGARITHMIC);
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void test1BandFloat32_ColorMap_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_1band_Float32.tif").toURI())), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)((Object)this), (String)"1band_Float32_test2.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        UserLayer nl = (UserLayer)sld.getStyledLayers()[0];
        Style style = nl.getUserStyles()[0];
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Rule rule = (Rule)fts.rules().get(0);
        RasterSymbolizer rs_1 = (RasterSymbolizer)rule.symbolizers().get(0);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_1band_Float32.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category", "category", "category"}, new double[]{0.1, 50.0, 200.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 40), new Color(0, 0, 255, 125)}, 1);
        rsb_1.setColorMap((ColorMap)cm);
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void bandsUInt16_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1")};
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"test.tif").toURI())), (org.opengis.geometry.Envelope)envelope, gsd, null, null);
        URL surl = TestData.url((Object)((Object)this), (String)"4bands_UInt16_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_4bands_UInt16.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeRed.setChannelName("1");
        chTypeBlue.setChannelName("2");
        chTypeGreen.setChannelName("3");
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeBlue, (SelectedChannelType)chTypeGreen);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void bandsUInt16_SLDROI() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1")};
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        RenderedOp image = JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"test.tif").toURI()));
        HashMap<String, ROIShape> properties = new HashMap<String, ROIShape>();
        properties.put("GC_ROI", new ROIShape((Shape)new Rectangle(image.getMinX() + 1, image.getMinY() + 1, image.getWidth() / 2, image.getHeight() / 2)));
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)image, (org.opengis.geometry.Envelope)envelope, gsd, null, properties);
        URL surl = TestData.url((Object)((Object)this), (String)"4bands_UInt16_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        RenderedOp image2 = JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_4bands_UInt16.tif").toURI()));
        properties = new HashMap();
        properties.put("GC_ROI", new ROIShape((Shape)new Rectangle(image2.getMinX() + 1, image2.getMinY() + 1, image2.getWidth() / 2, image2.getHeight() / 2)));
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)image2, (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), null, null, properties);
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeRed.setChannelName("1");
        chTypeBlue.setChannelName("2");
        chTypeGreen.setChannelName("3");
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeBlue, (SelectedChannelType)chTypeGreen);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    private static RasterSymbolizer extractRasterSymbolizer(StyledLayerDescriptor sld) {
        UserLayer nl = (UserLayer)sld.getStyledLayers()[0];
        Style style = nl.getUserStyles()[0];
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Rule rule = (Rule)fts.rules().get(0);
        RasterSymbolizer rs_1 = (RasterSymbolizer)rule.symbolizers().get(0);
        return rs_1;
    }

    @Test
    public void bandsByte_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridCoverage2D gc = this.read3BandsByteCoverage();
        URL surl = TestData.url((Object)((Object)this), (String)"3bands_Byte_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_3bands_Byte.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        cntEnh.setGammaValue(sldBuilder.literalExpression(0.5));
        chTypeRed.setChannelName("1");
        chTypeBlue.setChannelName("2");
        chTypeGreen.setChannelName("3");
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeBlue, (SelectedChannelType)chTypeGreen);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void greenSelection() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridCoverage2D gc = this.read3BandsByteCoverage();
        URL surl = TestData.url((Object)((Object)this), (String)"greenChannelSelection.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RenderedImage image = rsh.getOutput().getRenderedImage();
        File reference = new File("src/test/resources/org/geotools/renderer/lite/gridcoverage2d/greenChannleSelection.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)0);
    }

    public GridCoverage2D read3BandsByteCoverage() throws URISyntaxException, FileNotFoundException {
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1"), new GridSampleDimension((CharSequence)"test1BandByte_SLD2"), new GridSampleDimension((CharSequence)"test1BandByte_SLD3")};
        return CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_3bands_Byte.tif").toURI())), (org.opengis.geometry.Envelope)envelope, gsd, null, null);
    }

    @Test
    public void bandsByte_ColorMap_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridCoverage2D gc = this.read3BandsByteCoverage();
        URL surl = TestData.url((Object)((Object)this), (String)"3bands_Byte_test2.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_3bands_Byte.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category", "category", "category"}, new double[]{0.1, 50.0, 200.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 40), new Color(0, 0, 255, 125)}, 1);
        rsb_1.setColorMap((ColorMap)cm);
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void BandByte_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_1band_Byte.tif").toURI())), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)((Object)this), (String)"1band_Float32_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_1band_Byte.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsh.visit(rsb_1);
        RenderedImage im = ((GridCoverage2D)rsh.getOutput()).getRenderedImage();
        Assert.assertTrue((im.getSampleModel().getDataType() == 0 ? 1 : 0) != 0);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)((Object)this), (String)"small_1band_Byte.tif").toURI())), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        surl = TestData.url((Object)((Object)this), (String)"1band_Float32_test2.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh = new RasterSymbolizerHelper(gc, null);
        rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void colorMapInterpolation() throws Exception {
        URL sldURL = TestData.url((Object)((Object)this), (String)"colormap.sld");
        SLDParser stylereader = new SLDParser(sf, sldURL);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)RasterSymbolizerTest.getSynthetic(Double.NaN)), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"sd", new Category[]{new Category((CharSequence)"", Color.BLACK, 0)}, null)}, null, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        GridToEnvelopeMapper gtoem = new GridToEnvelopeMapper();
        gtoem.setEnvelope((org.opengis.geometry.Envelope)envelope);
        gtoem.setGridRange((GridEnvelope)new GridEnvelope2D(0, 0, 50, 50));
        gtoem.setPixelAnchor(PixelInCell.CELL_CORNER);
        GridCoverageRenderer renderer = new GridCoverageRenderer((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (Envelope)ReferencedEnvelope.reference((org.opengis.geometry.Envelope)envelope), new Rectangle(0, 0, 50, 50), gtoem.createAffineTransform().createInverse());
        RenderedImage image = renderer.renderImage(gc, rs, (Interpolation)new InterpolationBilinear(), null, 256, 256);
        RasterSymbolizerTest.assertNotNull((Object)image);
        RasterSymbolizerTest.assertNotNull((Object)PlanarImage.wrapRenderedImage((RenderedImage)image));
        RasterSymbolizerTest.assertTrue((boolean)(image.getColorModel() instanceof IndexColorModel));
        image = renderer.renderImage(gc, rs, (Interpolation)new InterpolationNearest(), null, 256, 256);
        RasterSymbolizerTest.assertNotNull((Object)image);
        RasterSymbolizerTest.assertNotNull((Object)PlanarImage.wrapRenderedImage((RenderedImage)image));
        RasterSymbolizerTest.assertTrue((boolean)(image.getColorModel() instanceof IndexColorModel));
    }

    @Test
    public void colorMap() throws IOException, TransformerException {
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)RasterSymbolizerTest.getSynthetic(Double.NaN)), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"sd", new Category[]{new Category((CharSequence)"", Color.BLACK, 0)}, null)}, null, null);
        this.testColorMap(gc);
    }

    @Test
    public void colorMapGrayAlpha() throws IOException, TransformerException {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)0, (int)500, (int)500, (int)2, null);
        Random random = new Random();
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                if ((double)random.nextFloat() > 0.9) {
                    raster.setSample(x, y, 0, 0);
                } else {
                    raster.setSample(x, y, 0, x + y);
                }
                raster.setSample(x, y, 1, 255);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 0);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)image), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"sd", new Category[]{new Category((CharSequence)"", Color.BLACK, 0)}, null), new GridSampleDimension((CharSequence)"sd-alpha", new Category[]{new Category((CharSequence)"", Color.BLACK, 0)}, null)}, null, null);
        this.testColorMap(gc);
    }

    private void testColorMap(GridCoverage2D gc) throws IOException, TransformerException {
        URL sldURL = TestData.url((Object)((Object)this), (String)"colormap.sld");
        SLDParser stylereader = new SLDParser(sf, sldURL);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        IndexColorModel icm1 = (IndexColorModel)((GridCoverage2D)rsh.getOutput()).getRenderedImage().getColorModel();
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)RasterSymbolizerTest.getSynthetic(Double.NaN)), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"sd", new Category[]{new Category((CharSequence)"", Color.BLACK, 0)}, null)}, null, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        rs = sldBuilder.createRasterSymbolizer();
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category0", "category1", "category2"}, new double[]{100.0, 500.0, 900.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 204), new Color(0, 0, 255, 51)}, 1);
        cm.setExtendedColors(true);
        rs.setColorMap((ColorMap)cm);
        rsh.visit(rs);
        IndexColorModel icm2 = (IndexColorModel)((GridCoverage2D)rsh.getOutput()).getRenderedImage().getColorModel();
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        Assert.assertTrue((boolean)icm1.equals(icm2));
    }

    @Test
    public void rgb() throws IOException, TransformerException {
        URL surl = TestData.url((Object)((Object)this), (String)"testrgb.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1"), new GridSampleDimension((CharSequence)"test1BandByte_SLD2"), new GridSampleDimension((CharSequence)"test1BandByte_SLD3")};
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"bahamas_hires.jpg")), (org.opengis.geometry.Envelope)envelope, gsd, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void testGapsColor() throws IOException {
        URL surl = TestData.url((Object)((Object)this), (String)"Topsoil-Organic-Carbon.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1")};
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"toc.tif")), (org.opengis.geometry.Envelope)envelope, gsd, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void dem() throws IOException, TransformerException {
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        URL surl = TestData.url((Object)((Object)this), (String)"raster_dem.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"smalldem.tif")), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"smalldem.tif")), (org.opengis.geometry.Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        chTypeGray.setChannelName("1");
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category", "category", "category"}, new double[]{0.1, 50.0, 200.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 40), new Color(0, 0, 255, 125)}, 1);
        rsb_1.setColorMap((ColorMap)cm);
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void demEmptyRange() throws IOException, TransformerException {
        URL surl = TestData.url((Object)((Object)this), (String)"dem_emptyRange.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"smalldem.tif")), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void demColorJump() throws IOException, TransformerException {
        URL surl = TestData.url((Object)((Object)this), (String)"dem_colorJump.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"smalldem.tif")), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void landsat() throws IOException, TransformerException {
        URL surl = TestData.url((Object)((Object)this), (String)"landsat.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1"), new GridSampleDimension((CharSequence)"test1BandByte_SLD2"), new GridSampleDimension((CharSequence)"test1BandByte_SLD3"), new GridSampleDimension((CharSequence)"test1BandByte_SLD4"), new GridSampleDimension((CharSequence)"test1BandByte_SLD5"), new GridSampleDimension((CharSequence)"test1BandByte_SLD6"), new GridSampleDimension((CharSequence)"test1BandByte_SLD")};
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"landsat.tiff")), (org.opengis.geometry.Envelope)envelope, gsd, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RenderedImage ri = ((GridCoverage2D)rsh.getOutput()).getRenderedImage();
        Assert.assertTrue((boolean)(ri.getColorModel() instanceof ComponentColorModel));
        Assert.assertTrue((ri.getColorModel().getNumComponents() == 3 ? 1 : 0) != 0);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    private static void testRasterSymbolizerHelper(SubchainStyleVisitorCoverageProcessingAdapter rsh) {
        if (TestData.isInteractiveTest()) {
            ImageIOUtilities.visualize((RenderedImage)((GridCoverage2D)rsh.getOutput()).getRenderedImage(), (String)rsh.getName().toString());
        } else {
            PlanarImage.wrapRenderedImage((RenderedImage)((GridCoverage2D)rsh.getOutput()).getRenderedImage()).getTiles();
            rsh.dispose(new Random().nextBoolean());
        }
    }

    @Test
    public void twoColorsTest() throws IOException {
        URL surl = TestData.url((Object)((Object)this), (String)"raster_discretecolors.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"smalldem.tif")), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RenderedImage ri = ((GridCoverage2D)rsh.getOutput()).getRenderedImage();
        Assert.assertTrue((boolean)(ri.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)ri.getColorModel();
        int mapSize = icm.getMapSize();
        Assert.assertEquals((long)3L, (long)mapSize);
        int[] rgb = new int[mapSize];
        rgb[0] = 0xFFFFFF & icm.getRGB(0);
        rgb[1] = 0xFFFFFF & icm.getRGB(1);
        rgb[2] = 0xFFFFFF & icm.getRGB(2);
        int found = 0;
        block3: for (int i = 0; i < mapSize; ++i) {
            switch (rgb[i]) {
                case 0: 
                case 32768: 
                case 0x663333: {
                    ++found;
                    continue block3;
                }
                default: {
                    throw new IllegalStateException("Found unexpected colors:" + rgb[i]);
                }
            }
        }
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void testUshort() throws IOException {
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        URL surl = TestData.url((Object)((Object)this), (String)"raster.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"test_ushort.tif")), (org.opengis.geometry.Envelope)envelope, new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test_dimension")}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RenderedImage outputImage = ((GridCoverage2D)rsh.getOutput()).getRenderedImage();
        int dataType = outputImage.getSampleModel().getDataType();
        RasterSymbolizerTest.assertEquals((long)0L, (long)dataType);
    }

    @Test
    public void contrastEnhancementInChannelSelection() throws IOException {
        StyleBuilder sldBuilder = new StyleBuilder();
        RasterSymbolizer symbolizer = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        SelectedChannelType[] channels = new SelectedChannelType[]{chTypeRed, chTypeGreen, chTypeBlue};
        int min = 10;
        int max = 100;
        for (int i = 0; i < 3; ++i) {
            ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
            NormalizeContrastMethodStrategy method = new NormalizeContrastMethodStrategy();
            method.addOption("algorithm", sldBuilder.literalExpression("StretchToMinimumMaximum"));
            method.addOption("minValue", sldBuilder.literalExpression(min + 20 * i));
            method.addOption("maxValue", sldBuilder.literalExpression(max + 20 * i));
            cntEnh.setMethod((ContrastMethodStrategy)method);
            channels[i].setChannelName(Integer.toString(i * 2 + 1));
            channels[i].setContrastEnhancement((org.opengis.style.ContrastEnhancement)cntEnh);
        }
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeGreen, (SelectedChannelType)chTypeBlue);
        symbolizer.setChannelSelection((ChannelSelection)chSel);
        symbolizer.setOpacity(sldBuilder.literalExpression(1.0));
        symbolizer = GridCoverageRenderer.setupSymbolizerForBandsSelection((RasterSymbolizer)symbolizer);
        org.geotools.styling.ChannelSelection cs = symbolizer.getChannelSelection();
        SelectedChannelType[] postBandSelectionChannels = cs.getRGBChannels();
        for (int i = 0; i < 3; ++i) {
            SelectedChannelType postBandSelectionChannel = postBandSelectionChannels[i];
            RasterSymbolizerTest.assertNotNull((Object)postBandSelectionChannel);
            ContrastEnhancement cntEnh = postBandSelectionChannel.getContrastEnhancement();
            ContrastMethod method = cntEnh.getMethod();
            RasterSymbolizerTest.assertTrue((boolean)Integer.toString(i + 1).equalsIgnoreCase((String)postBandSelectionChannel.getChannelName().evaluate(null, String.class)));
            RasterSymbolizerTest.assertTrue((boolean)method.name().equalsIgnoreCase(ContrastMethod.NORMALIZE.name()));
            Map options = cntEnh.getOptions();
            RasterSymbolizerTest.assertTrue((boolean)options.containsKey("algorithm"));
            RasterSymbolizerTest.assertTrue((boolean)options.containsKey("minValue"));
            RasterSymbolizerTest.assertTrue((boolean)options.containsKey("maxValue"));
            RasterSymbolizerTest.assertTrue((boolean)((Expression)options.get("algorithm")).equals(sldBuilder.literalExpression("StretchToMinimumMaximum")));
            RasterSymbolizerTest.assertTrue((boolean)((Expression)options.get("minValue")).equals(sldBuilder.literalExpression(min + 20 * i)));
            RasterSymbolizerTest.assertTrue((boolean)((Expression)options.get("maxValue")).equals(sldBuilder.literalExpression(max + 20 * i)));
        }
    }
}

