/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class ExpressionExtractorTest
extends TestCase {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public void testLiteral() {
        String exp = "I'm a plain string";
        List result = ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string");
        ExpressionExtractorTest.assertEquals((int)1, (int)result.size());
        ExpressionExtractorTest.assertEquals((Object)this.ff.literal((Object)"I'm a plain string"), result.get(0));
    }

    public void testLiteralEscapes() {
        String exp = "I'm a plain string \\\\ \\${bla bla\\}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string \\\\ \\${bla bla\\}");
        ExpressionExtractorTest.assertEquals((int)1, (int)result.size());
        ExpressionExtractorTest.assertEquals((Object)this.ff.literal((Object)"I'm a plain string \\ ${bla bla}"), result.get(0));
    }

    public void testSimpleExpressions() {
        String exp = "I'm a ${name} expression of type ${type}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"I'm a ${name} expression of type ${type}");
        ExpressionExtractorTest.assertEquals((int)4, (int)result.size());
        ExpressionExtractorTest.assertEquals((Object)this.ff.literal((Object)"I'm a "), result.get(0));
        ExpressionExtractorTest.assertEquals((Object)this.ff.property("name"), result.get(1));
        ExpressionExtractorTest.assertEquals((Object)this.ff.literal((Object)" expression of type "), result.get(2));
        ExpressionExtractorTest.assertEquals((Object)this.ff.property("type"), result.get(3));
    }

    public void testDoubleOpen() {
        try {
            ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string ${bla ${bla}");
            ExpressionExtractorTest.fail((String)"Double cql exp open, should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testOpenLingering() {
        try {
            ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string ${bla");
            ExpressionExtractorTest.fail((String)"Double cql exp open, should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDoubleClose() {
        try {
            ExpressionExtractor.splitCqlExpressions((String)"I'm a plain string ${bla}}");
            ExpressionExtractorTest.fail((String)"Double cql exp open, should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEscapesInside() {
        String exp = "${strLength('\\\\\\${\\}')}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"${strLength('\\\\\\${\\}')}");
        ExpressionExtractorTest.assertEquals((int)1, (int)result.size());
        ExpressionExtractorTest.assertEquals((Object)this.ff.function("strLength", new Expression[]{this.ff.literal((Object)"\\${}")}), result.get(0));
    }

    public void testTwoExpressions() {
        String exp = "${name}${age}";
        List result = ExpressionExtractor.splitCqlExpressions((String)"${name}${age}");
        ExpressionExtractorTest.assertEquals((int)2, (int)result.size());
        ExpressionExtractorTest.assertEquals((Object)this.ff.property("name"), result.get(0));
        ExpressionExtractorTest.assertEquals((Object)this.ff.property("age"), result.get(1));
    }

    public void testCatenateOne() {
        Literal l = this.ff.literal((Object)"http://test?param=");
        Expression cat = ExpressionExtractor.catenateExpressions(Arrays.asList(l));
        ExpressionExtractorTest.assertEquals((Object)l, (Object)cat);
    }

    public void testCatenateTwo() {
        Literal l = this.ff.literal((Object)"http://test?param=");
        PropertyName pn = this.ff.property("intAttribute");
        Expression cat = ExpressionExtractor.catenateExpressions(Arrays.asList(l, pn));
        ExpressionExtractorTest.assertTrue((boolean)(cat instanceof Function));
        Function f = (Function)cat;
        ExpressionExtractorTest.assertEquals((String)"Concatenate", (String)f.getName());
        ExpressionExtractorTest.assertEquals((Object)l, f.getParameters().get(0));
        ExpressionExtractorTest.assertEquals((Object)pn, f.getParameters().get(1));
    }

    public void testCatenateThree() {
        Literal l1 = this.ff.literal((Object)"http://test?param=");
        PropertyName pn = this.ff.property("intAttribute");
        Literal l2 = this.ff.literal((Object)"&param2=foo");
        Expression cat = ExpressionExtractor.catenateExpressions(Arrays.asList(l1, pn, l2));
        ExpressionExtractorTest.assertTrue((boolean)(cat instanceof Function));
        Function f = (Function)cat;
        ExpressionExtractorTest.assertEquals((String)"Concatenate", (String)f.getName());
        ExpressionExtractorTest.assertEquals((Object)l1, f.getParameters().get(0));
        ExpressionExtractorTest.assertEquals((Object)pn, f.getParameters().get(1));
        ExpressionExtractorTest.assertEquals((Object)l2, f.getParameters().get(2));
    }
}

