/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.DynamicLineStyle2D;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TTFMarkFactory;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.Fill;
import org.opengis.style.Font;

public class SLDStyleFactoryTest
extends TestCase {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    SLDStyleFactory sld = new SLDStyleFactory();
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    NumberRange<Integer> range = NumberRange.create((int)1, (int)1);
    SimpleFeatureType featureType;
    SimpleFeature feature;

    protected void setUp() throws Exception {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("test");
        ftb.add("geom", Point.class);
        ftb.add("symb", String.class);
        ftb.add("icon", String.class);
        this.featureType = ftb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.featureType);
        fb.set("geom", (Object)new GeometryFactory().createPoint(new Coordinate(0.0, 0.0)));
        fb.set("symb", (Object)"0xF054");
        fb.set("icon", (Object)"draw.png");
        this.feature = fb.buildFeature(null);
    }

    protected void tearDown() throws Exception {
        this.sld.setVectorRenderingEnabled(false);
        MarkStyle2D.setMaxMarkSizeEnabled((boolean)false);
    }

    public void testCreatePointStyle() {
        PointSymbolizer pointsym = this.sf.createPointSymbolizer();
        pointsym.setGraphic((org.opengis.style.Graphic)this.sf.getDefaultGraphic());
        NumberRange scaleRange = NumberRange.create((double)1.0, (double)50000.0);
        Style2D style = this.sld.createPointStyle(null, pointsym, (Range)scaleRange);
        SLDStyleFactoryTest.assertNotNull((Object)style);
    }

    public void testCreateLineStyle() {
        LineSymbolizer ls = this.sf.createLineSymbolizer();
        ls.setPerpendicularOffset((Expression)this.ff.literal(5));
        NumberRange scaleRange = NumberRange.create((double)1.0, (double)50000.0);
        LineStyle2D style = (LineStyle2D)this.sld.createLineStyle(null, ls, (Range)scaleRange);
        SLDStyleFactoryTest.assertNotNull((Object)style);
        SLDStyleFactoryTest.assertEquals((double)5.0, (double)style.getPerpendicularOffset(), (double)0.0);
    }

    public void testCreateIncompletePolygonStyle() {
        PolygonSymbolizer symb = this.sf.createPolygonSymbolizer();
        this.sld.createPolygonStyle(null, symb, this.range);
    }

    public void testCreateCompletePointStyle() {
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        Mark myMark = this.sf.createMark();
        myMark.setFill((Fill)this.sf.createFill((Expression)this.ff.literal((Object)"#ffff00")));
        symb.getGraphic().setSize((Expression)this.ff.literal(10));
        symb.getGraphic().graphicalSymbols().add(myMark);
        symb.getGraphic().setOpacity((Expression)this.ff.literal(1));
        symb.getGraphic().setRotation((Expression)this.ff.literal(0));
        this.sld.createPointStyle(null, symb, this.range);
    }

    public void testCreateIncompletePointStyle() {
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        Mark myMark = this.sf.createMark();
        symb.getGraphic().graphicalSymbols().add(myMark);
        this.sld.createPointStyle(null, symb, this.range);
    }

    public void testCreateDynamicMark() throws Exception {
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        Mark myMark = this.sf.createMark();
        String ttfUrl = "ttf://Serif#${symb}";
        myMark.setWellKnownName((Expression)this.ff.literal((Object)"ttf://Serif#${symb}"));
        symb.getGraphic().graphicalSymbols().add(myMark);
        MarkStyle2D ms = (MarkStyle2D)this.sld.createStyle((Object)this.feature, (Symbolizer)symb, this.range);
        SLDStyleFactoryTest.assertNotNull((Object)ms.getShape());
        SLDStyleFactory.SymbolizerKey key = new SLDStyleFactory.SymbolizerKey((Symbolizer)symb, this.range);
        SLDStyleFactoryTest.assertTrue((boolean)this.sld.dynamicSymbolizers.containsKey(key));
        Shape expected = new TTFMarkFactory().getShape(null, (Expression)this.ff.literal((Object)"ttf://Serif#0xF054"), (Feature)this.feature);
        PathIterator piExpected = expected.getPathIterator(new AffineTransform());
        PathIterator pi = ms.getShape().getPathIterator(new AffineTransform());
        double[] coordsExpected = new double[6];
        double[] coords = new double[6];
        SLDStyleFactoryTest.assertEquals((int)piExpected.getWindingRule(), (int)pi.getWindingRule());
        while (!piExpected.isDone()) {
            SLDStyleFactoryTest.assertFalse((boolean)pi.isDone());
            piExpected.currentSegment(coordsExpected);
            pi.currentSegment(coords);
            SLDStyleFactoryTest.assertEquals((double)coordsExpected[0], (double)coords[0], (double)1.0E-5);
            SLDStyleFactoryTest.assertEquals((double)coordsExpected[1], (double)coords[1], (double)1.0E-5);
            piExpected.next();
            pi.next();
        }
        SLDStyleFactoryTest.assertTrue((boolean)pi.isDone());
    }

    public void testCreateDynamicExternalGraphics() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/");
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "${icon}", "image/png");
        symb.getGraphic().graphicalSymbols().add(eg);
        GraphicStyle2D gs = (GraphicStyle2D)this.sld.createStyle((Object)this.feature, (Symbolizer)symb, this.range);
        SLDStyleFactory.SymbolizerKey key = new SLDStyleFactory.SymbolizerKey((Symbolizer)symb, this.range);
        SLDStyleFactoryTest.assertTrue((boolean)this.sld.dynamicSymbolizers.containsKey(key));
        BufferedImage img = gs.getImage();
        BufferedImage expected = ImageIO.read(StreamingRenderer.class.getResource("test-data/draw.png"));
        SLDStyleFactoryTest.assertEquals((int)expected.getHeight(), (int)img.getHeight());
        SLDStyleFactoryTest.assertEquals((int)expected.getWidth(), (int)img.getWidth());
    }

    public void testCreateDynamicExternalGraphicsVector() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/");
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "${icon}", "image/png");
        symb.getGraphic().graphicalSymbols().add(eg);
        this.sld.setVectorRenderingEnabled(true);
        GraphicStyle2D gs = (GraphicStyle2D)this.sld.createStyle((Object)this.feature, (Symbolizer)symb, this.range);
        SLDStyleFactory.SymbolizerKey key = new SLDStyleFactory.SymbolizerKey((Symbolizer)symb, this.range);
        SLDStyleFactoryTest.assertTrue((boolean)this.sld.dynamicSymbolizers.containsKey(key));
        BufferedImage expected = ImageIO.read(StreamingRenderer.class.getResource("test-data/draw.png"));
        SLDStyleFactoryTest.assertEquals((int)expected.getHeight(), (int)gs.getImage().getHeight());
        SLDStyleFactoryTest.assertEquals((int)expected.getWidth(), (int)gs.getImage().getWidth());
    }

    public void testDefaultSizeExternalGraphic() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/");
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "icon64.png", "image/png");
        symb.getGraphic().graphicalSymbols().add(eg);
        GraphicStyle2D gs = (GraphicStyle2D)this.sld.createPointStyle((Object)this.feature, symb, this.range);
        BufferedImage img = gs.getImage();
        SLDStyleFactoryTest.assertEquals((int)64, (int)img.getHeight());
        SLDStyleFactoryTest.assertEquals((int)64, (int)img.getWidth());
    }

    public void testCreateDynamicExternalFormat() throws Exception {
        this.feature.setAttribute("symb", (Object)"image/png");
        URL url = StreamingRenderer.class.getResource("test-data/");
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "${icon}", "${symb}");
        symb.getGraphic().graphicalSymbols().add(eg);
        GraphicStyle2D gs = (GraphicStyle2D)this.sld.createStyle((Object)this.feature, (Symbolizer)symb, this.range);
        SLDStyleFactory.SymbolizerKey key = new SLDStyleFactory.SymbolizerKey((Symbolizer)symb, this.range);
        SLDStyleFactoryTest.assertTrue((boolean)this.sld.dynamicSymbolizers.containsKey(key));
        BufferedImage img = gs.getImage();
        BufferedImage expected = ImageIO.read(StreamingRenderer.class.getResource("test-data/draw.png"));
        SLDStyleFactoryTest.assertEquals((int)expected.getHeight(), (int)img.getHeight());
        SLDStyleFactoryTest.assertEquals((int)expected.getWidth(), (int)img.getWidth());
    }

    public void testResizeExternalGraphic() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/");
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "icon64.png", "image/png");
        symb.getGraphic().graphicalSymbols().add(eg);
        symb.getGraphic().setSize((Expression)this.ff.literal(20));
        GraphicStyle2D gs = (GraphicStyle2D)this.sld.createPointStyle((Object)this.feature, symb, this.range);
        BufferedImage img = gs.getImage();
        SLDStyleFactoryTest.assertEquals((int)20, (int)img.getHeight());
        SLDStyleFactoryTest.assertEquals((int)20, (int)img.getWidth());
    }

    public void testNonExistingExternalGraphic() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/");
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "iAmNotThere.png", "image/png");
        symb.getGraphic().graphicalSymbols().add(eg);
        Style2D style2D = this.sld.createPointStyle((Object)this.feature, symb, this.range);
        Assert.assertThat((Object)style2D, (Matcher)CoreMatchers.instanceOf(MarkStyle2D.class));
        MarkStyle2D mark = (MarkStyle2D)style2D;
        SLDStyleFactoryTest.assertEquals((Object)Color.GRAY, (Object)mark.getFill());
    }

    public void testNonExistingExternalGraphicNoFallback() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/");
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "iAmNotThere.png", "image/png");
        symb.getGraphic().graphicalSymbols().add(eg);
        symb.getOptions().put("fallbackOnDefaultMark", "false");
        SLDStyleFactoryTest.assertNull((Object)this.sld.createPointStyle((Object)this.feature, symb, this.range));
    }

    public void testResizeGraphicFill() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/");
        PolygonSymbolizer symb = this.sf.createPolygonSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic(url + "icon64.png", "image/png");
        Graphic g = this.sf.createGraphic(new ExternalGraphic[]{eg}, null, null, null, (Expression)this.ff.literal(20), null);
        org.geotools.styling.Fill fill = this.sf.createFill(null, null, null, g);
        symb.setFill((Fill)fill);
        PolygonStyle2D ps = this.sld.createPolygonStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertTrue((boolean)(ps.getFill() instanceof TexturePaint));
        TexturePaint paint = (TexturePaint)ps.getFill();
        SLDStyleFactoryTest.assertEquals((int)20, (int)paint.getImage().getWidth());
    }

    public void testDefaultSizeMark() throws Exception {
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        Mark myMark = this.sf.createMark();
        myMark.setWellKnownName((Expression)this.ff.literal((Object)"square"));
        symb.getGraphic().graphicalSymbols().add(myMark);
        MarkStyle2D ms = (MarkStyle2D)this.sld.createPointStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertEquals((Object)16.0, (Object)ms.getSize());
    }

    public void testDefaultExpressionSizeMark() throws Exception {
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        Mark myMark = this.sf.createMark();
        myMark.setWellKnownName((Expression)this.ff.literal((Object)"square"));
        symb.getGraphic().setSize((Expression)this.ff.multiply((Expression)this.ff.property("expression/nil"), (Expression)this.ff.literal(1.0)));
        symb.getGraphic().graphicalSymbols().add(myMark);
        MarkStyle2D ms = (MarkStyle2D)this.sld.createPointStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertEquals((Object)16.0, (Object)ms.getSize());
    }

    public void testDefaultLineSymbolizerWithColor() throws Exception {
        LineSymbolizer symb = this.sf.createLineSymbolizer();
        symb.setStroke((org.opengis.style.Stroke)this.sf.createStroke((Expression)this.ff.literal((Object)"#0000FF"), (Expression)this.ff.literal(1.0)));
        symb.setPerpendicularOffset((Expression)this.ff.literal(10));
        Style2D s = this.sld.createLineStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertNotNull((Object)s);
        DynamicLineStyle2D s2 = (DynamicLineStyle2D)this.sld.createDynamicLineStyle(this.feature, symb, this.range);
        SLDStyleFactoryTest.assertNotNull((Object)s2);
        SLDStyleFactoryTest.assertEquals((Object)Color.BLUE, (Object)s2.getContour());
        SLDStyleFactoryTest.assertNotNull((Object)s2.getStroke());
        SLDStyleFactoryTest.assertEquals((double)10.0, (double)s2.getPerpendicularOffset(), (double)0.0);
    }

    public void testTexturePaintNoSize() throws Exception {
        PolygonSymbolizer symb = this.sf.createPolygonSymbolizer();
        Mark myMark = this.sf.createMark();
        myMark.setWellKnownName((Expression)this.ff.literal((Object)"square"));
        org.geotools.styling.Fill fill = this.sf.createFill(null);
        fill.setGraphicFill((org.opengis.style.Graphic)this.sf.createGraphic(null, new Mark[]{myMark}, null, null, null, null));
        symb.setFill((Fill)fill);
        PolygonStyle2D ps = this.sld.createPolygonStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertTrue((boolean)(ps.getFill() instanceof TexturePaint));
    }

    public void testUnknownFont() throws Exception {
        TextSymbolizer ts = this.sf.createTextSymbolizer();
        ts.setFill((Fill)this.sf.createFill(null));
        org.geotools.styling.Font font = this.sf.createFont((Expression)this.ff.literal((Object)"notExistingFont"), (Expression)this.ff.literal((Object)"italic"), (Expression)this.ff.literal((Object)"bold"), (Expression)this.ff.literal(20));
        ts.setFont((Font)font);
        TextStyle2D tsd = (TextStyle2D)this.sld.createTextStyle((Object)this.feature, ts, this.range);
        SLDStyleFactoryTest.assertEquals((int)20, (int)tsd.getFont().getSize());
        SLDStyleFactoryTest.assertEquals((int)3, (int)tsd.getFont().getStyle());
        SLDStyleFactoryTest.assertEquals((String)"Serif", (String)tsd.getFont().getName());
        SLDStyleFactoryTest.assertEquals((double)0.0, (double)tsd.getAnchorX(), (double)0.0);
        SLDStyleFactoryTest.assertEquals((double)0.5, (double)tsd.getAnchorY(), (double)0.0);
    }

    public void testAlternativeMarkSizeCalculation() {
        MarkStyle2D ms = new MarkStyle2D();
        ms.setSize(1.0);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(500.0f, 0.0f);
        gp.lineTo(-500.0f, 0.0f);
        gp.moveTo(200.0f, -275.0f);
        gp.lineTo(200.0f, 275.0f);
        ms.setShape((Shape)gp);
        Shape shape = ms.getTransformedShape(0.0f, 0.0f);
        Rectangle2D rect = shape.getBounds2D();
        SLDStyleFactoryTest.assertEquals((double)1.0, (double)rect.getHeight(), (double)1.0E-4);
        SLDStyleFactoryTest.assertEquals((double)1.8181818181818181, (double)rect.getWidth(), (double)1.0E-4);
        MarkStyle2D.setMaxMarkSizeEnabled((boolean)true);
        shape = ms.getTransformedShape(0.0f, 0.0f);
        rect = shape.getBounds2D();
        SLDStyleFactoryTest.assertEquals((double)0.55, (double)rect.getHeight(), (double)1.0E-4);
        SLDStyleFactoryTest.assertEquals((double)1.0, (double)rect.getWidth(), (double)1.0E-4);
    }

    public void testMarkSizeCalculation() throws Exception {
        SLDStyleFactoryTest.assertFalse((boolean)MarkStyle2D.isMaxMarkSizeEnabled());
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        Mark myMark = this.sf.createMark();
        myMark.setWellKnownName((Expression)this.ff.literal((Object)"square"));
        symb.getGraphic().graphicalSymbols().add(myMark);
        MarkStyle2D ms = (MarkStyle2D)this.sld.createPointStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertFalse((boolean)MarkStyle2D.isMaxMarkSizeEnabled());
        MarkStyle2D.setMaxMarkSizeEnabled((boolean)true);
        ms = (MarkStyle2D)this.sld.createPointStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertTrue((boolean)MarkStyle2D.isMaxMarkSizeEnabled());
    }

    public void testFallbackGraphicMark() throws Exception {
        PointSymbolizer symb = this.sf.createPointSymbolizer();
        ExternalGraphic eg = this.sf.createExternalGraphic("http://foo.com/invalid_or_missing_image_url", null);
        symb.getGraphic().graphicalSymbols().add(eg);
        Style2D icon = this.sld.createPointStyle((Object)this.feature, symb, this.range);
        SLDStyleFactoryTest.assertNotNull((Object)icon);
    }

    public void testSortBySingleAscending() throws Exception {
        this.checkSortByParsing("z", this.ff.sort("z", SortOrder.ASCENDING));
    }

    public void testSortByTwoPropertiesAscending() throws Exception {
        this.checkSortByParsing("cat ,    name", this.ff.sort("cat", SortOrder.ASCENDING), this.ff.sort("name", SortOrder.ASCENDING));
    }

    public void testSortBySingleDescending() throws Exception {
        this.checkSortByParsing("cat D   ", this.ff.sort("cat", SortOrder.DESCENDING));
    }

    public void testSortByMixed() throws Exception {
        this.checkSortByParsing("cat D,name A,z D", this.ff.sort("cat", SortOrder.DESCENDING), this.ff.sort("name", SortOrder.ASCENDING), this.ff.sort("z", SortOrder.DESCENDING));
    }

    private void checkSortByParsing(String sortBySpec, SortBy ... expected) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("sortBy", sortBySpec);
        Object[] sortBy = SLDStyleFactory.getSortBy(options);
        Assert.assertArrayEquals((Object[])expected, (Object[])sortBy);
    }

    public void testKerningOnByDefault() throws Exception {
        TextSymbolizer ts = this.sf.createTextSymbolizer();
        ts.setFill((Fill)this.sf.createFill(null));
        org.geotools.styling.Font font = this.sf.createFont((Expression)this.ff.literal((Object)"Serif"), (Expression)this.ff.literal((Object)"italic"), (Expression)this.ff.literal((Object)"bold"), (Expression)this.ff.literal(20));
        ts.setFont((Font)font);
        TextStyle2D tsd = (TextStyle2D)this.sld.createTextStyle((Object)this.feature, ts, this.range);
        SLDStyleFactoryTest.assertEquals((int)20, (int)tsd.getFont().getSize());
        Map<TextAttribute, ?> attributes = tsd.getFont().getAttributes();
        Object kerningValue = attributes.get(TextAttribute.KERNING);
        SLDStyleFactoryTest.assertEquals((Object)TextAttribute.KERNING_ON, kerningValue);
    }

    public void testKerningOffByDefault() throws Exception {
        TextSymbolizer ts = this.sf.createTextSymbolizer();
        ts.setFill((Fill)this.sf.createFill(null));
        org.geotools.styling.Font font = this.sf.createFont((Expression)this.ff.literal((Object)"Serif"), (Expression)this.ff.literal((Object)"italic"), (Expression)this.ff.literal((Object)"bold"), (Expression)this.ff.literal(20));
        ts.setFont((Font)font);
        ts.getOptions().put("kerning", "false");
        TextStyle2D tsd = (TextStyle2D)this.sld.createTextStyle((Object)this.feature, ts, this.range);
        SLDStyleFactoryTest.assertEquals((int)20, (int)tsd.getFont().getSize());
        Map<TextAttribute, ?> attributes = tsd.getFont().getAttributes();
        Object kerningValue = attributes.get(TextAttribute.KERNING);
        SLDStyleFactoryTest.assertNull(kerningValue);
    }

    public void testGEOT5878() {
        String[] wkt = new String[]{"Polygon ((6438348.98000000044703484 4962869.70000000018626451, 6438348.88999999966472387 4962867.28000000026077032, 6438343.53000000026077032 4962867.28000000026077032, 6438343.53000000026077032 4962869.76999999955296516, 6438343.61000000033527613 4962870.17999999970197678, 6438348.90000000037252903 4962870.0400000000372529, 6438348.98000000044703484 4962869.70000000018626451))", "Polygon ((6438339.7099999999627471 4962870.38999999966472387, 6438339.94000000040978193 4962873.86000000033527613, 6438346.65000000037252903 4962873.61000000033527613, 6438346.62999999988824129 4962870.38999999966472387, 6438339.7099999999627471 4962870.38999999966472387))"};
        double naglib = 1.5707964;
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("test");
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)"EPSG:31276");
        }
        catch (FactoryException e1) {
            SLDStyleFactoryTest.fail((String)e1.getMessage());
        }
        ftb.add("the_geom", Polygon.class, crs);
        ftb.add("Nagib", Double.class);
        SimpleFeatureType schema = ftb.buildFeatureType();
        WKTReader reader = new WKTReader();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (String w : wkt) {
            Geometry geom = null;
            try {
                geom = reader.read(w);
            }
            catch (ParseException e) {
                SLDStyleFactoryTest.fail((String)e.getMessage());
            }
            fb.set("the_geom", (Object)geom);
            fb.set("Nagib", (Object)naglib);
            features.add(fb.buildFeature(null));
        }
        StyleBuilder sb = new StyleBuilder();
        Mark mark = sb.createMark("wkt://LINESTRING(0 0, ${sin(Nagib) * 20000} ${cos(Nagib) * 20000} )", Color.red);
        Graphic graphic = sb.createGraphic(null, mark, null);
        graphic.setSize((Expression)this.ff.literal((Object)"40px"));
        org.geotools.styling.Fill fill = this.sf.createFill(null, null, null, graphic);
        PolygonSymbolizer symb = sb.createPolygonSymbolizer();
        symb.setFill((Fill)fill);
        Style style = sb.createStyle();
        style.featureTypeStyles().add(sb.createFeatureTypeStyle((Symbolizer)symb));
        FeatureLayer layer = new FeatureLayer((FeatureCollection)DataUtilities.collection(features), style);
        MapContent content = new MapContent();
        content.addLayer((Layer)layer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                TestCase.fail((String)"an error occured");
            }
        });
        renderer.setMapContent(content);
        BufferedImage img = new BufferedImage(100, 100, 2);
        Rectangle paintArea = new Rectangle(0, 0, 100, 100);
        renderer.paint(img.createGraphics(), paintArea, layer.getBounds(), RendererUtilities.worldToScreenTransform((ReferencedEnvelope)layer.getBounds(), (Rectangle)paintArea));
    }

    public void testDashArrayZero() throws Exception {
        LineSymbolizer ls = this.sf.createLineSymbolizer();
        Stroke stroke = this.sf.createStroke((Expression)this.ff.literal((Object)"red"), (Expression)this.ff.literal(1));
        Subtract nonObviousZero = this.ff.subtract((Expression)this.ff.literal(10), (Expression)this.ff.literal(10));
        stroke.setDashArray(Arrays.asList(nonObviousZero, nonObviousZero, nonObviousZero));
        ls.setStroke((org.opengis.style.Stroke)stroke);
        LineStyle2D ls2d = (LineStyle2D)this.sld.createLineStyle((Object)this.feature, ls, this.range);
        Assert.assertThat((Object)ls2d.getStroke(), (Matcher)CoreMatchers.instanceOf(BasicStroke.class));
        BasicStroke bs = (BasicStroke)ls2d.getStroke();
        SLDStyleFactoryTest.assertNull((Object)bs.getDashArray());
    }
}

