/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Shape;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.TTFMarkFactory;
import org.geotools.test.TestData;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class TTFMarkFactoryTest
extends TestCase {
    private TTFMarkFactory ttf;
    private FilterFactory ff;

    protected void setUp() throws Exception {
        this.ttf = new TTFMarkFactory();
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    public void testInvalidPaths() throws Exception {
        TTFMarkFactoryTest.assertNull((Object)this.ttf.getShape(null, (Expression)this.ff.literal((Object)"font://invalid"), null));
        try {
            this.ttf.getShape(null, (Expression)this.ff.literal((Object)"ttf://invalid"), null);
            TTFMarkFactoryTest.fail((String)"Should have throw an exception, invalid path");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ttf.getShape(null, (Expression)this.ff.literal((Object)"ttf://missingFont#56"), null);
            TTFMarkFactoryTest.fail((String)"Should have throw an exception, invalid font");
        }
        catch (IllegalArgumentException e) {
            TTFMarkFactoryTest.assertTrue((boolean)e.getMessage().contains("missingFont"));
        }
        try {
            this.ttf.getShape(null, (Expression)this.ff.literal((Object)"ttf://Serif#blah"), null);
            TTFMarkFactoryTest.fail((String)"Should have throw an exception, invalid char number");
        }
        catch (IllegalArgumentException e) {
            TTFMarkFactoryTest.assertTrue((boolean)e.getMessage().contains("blah"));
        }
    }

    public void testValidPathSimpleNumber() throws Exception {
        Shape shape = this.ttf.getShape(null, (Expression)this.ff.literal((Object)"ttf://Serif#56"), null);
        TTFMarkFactoryTest.assertNotNull((Object)shape);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getWidth() <= 1.0 ? 1 : 0) != 0);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getHeight() <= 1.0 ? 1 : 0) != 0);
    }

    public void testValidPathHex() throws Exception {
        Shape shape = this.ttf.getShape(null, (Expression)this.ff.literal((Object)"ttf://Serif#0xF054"), null);
        TTFMarkFactoryTest.assertNotNull((Object)shape);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getWidth() <= 1.0 ? 1 : 0) != 0);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getHeight() <= 1.0 ? 1 : 0) != 0);
    }

    public void testValidPathUnicode() throws Exception {
        Shape shape = this.ttf.getShape(null, (Expression)this.ff.literal((Object)"ttf://Serif#U+0041"), null);
        TTFMarkFactoryTest.assertNotNull((Object)shape);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getWidth() <= 1.0 ? 1 : 0) != 0);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getHeight() <= 1.0 ? 1 : 0) != 0);
    }

    public void testLocalFont() throws Exception {
        String fontPath = TestData.getResource(StreamingRenderer.class, (String)"recreate.ttf").toURI().toString();
        Shape shape = this.ttf.getShape(null, (Expression)this.ff.literal((Object)("ttf://" + fontPath + "#U+0021")), null);
        TTFMarkFactoryTest.assertNotNull((Object)shape);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getWidth() <= 1.0 ? 1 : 0) != 0);
        TTFMarkFactoryTest.assertTrue((shape.getBounds2D().getHeight() <= 1.0 ? 1 : 0) != 0);
    }
}

