/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geotools.renderer.util.ExplicitBoundsShape;

public class TestExplicitBoundsShape
extends TestCase {
    public void testConstructorOk() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertNotNull((Object)target);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testConstructor_NullShape() throws Exception {
        try {
            new ExplicitBoundsShape(null);
            TestExplicitBoundsShape.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDelegate_AllMethods() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            EasyMock.reset((Object[])new Object[]{shape});
            EasyMock.expect((Object)shape.contains((Point2D)null)).andReturn((Object)false);
            EasyMock.expect((Object)shape.contains((Rectangle2D)null)).andReturn((Object)false);
            EasyMock.expect((Object)shape.contains(0.0, 0.0)).andReturn((Object)false);
            EasyMock.expect((Object)shape.contains(0.0, 0.0, 0.0, 0.0)).andReturn((Object)false);
            EasyMock.expect((Object)shape.getBounds()).andReturn(null);
            EasyMock.expect((Object)shape.getBounds2D()).andReturn(null);
            EasyMock.expect((Object)shape.getPathIterator(null)).andReturn(null);
            EasyMock.expect((Object)shape.getPathIterator(null, 0.0)).andReturn(null);
            EasyMock.expect((Object)shape.intersects(null)).andReturn((Object)false);
            EasyMock.expect((Object)shape.intersects(0.0, 0.0, 0.0, 0.0)).andReturn((Object)false);
            EasyMock.replay((Object[])new Object[]{shape});
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertFalse((boolean)target.contains((Point2D)null));
            TestExplicitBoundsShape.assertFalse((boolean)target.contains((Rectangle2D)null));
            TestExplicitBoundsShape.assertFalse((boolean)target.contains(0.0, 0.0));
            TestExplicitBoundsShape.assertFalse((boolean)target.contains(0.0, 0.0, 0.0, 0.0));
            TestExplicitBoundsShape.assertNull((Object)target.getBounds());
            TestExplicitBoundsShape.assertNull((Object)target.getBounds2D());
            TestExplicitBoundsShape.assertNull((Object)target.getPathIterator(null));
            TestExplicitBoundsShape.assertNull((Object)target.getPathIterator(null, 0.0));
            TestExplicitBoundsShape.assertFalse((boolean)target.intersects(null));
            TestExplicitBoundsShape.assertFalse((boolean)target.intersects(0.0, 0.0, 0.0, 0.0));
            EasyMock.verify((Object[])new Object[]{shape});
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testSetBounds() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            EasyMock.reset((Object[])new Object[]{shape});
            Rectangle shapeBounds = new Rectangle(8, 7, 9, 3);
            EasyMock.expect((Object)shape.getBounds()).andReturn((Object)shapeBounds);
            EasyMock.expect((Object)shape.getBounds2D()).andReturn((Object)shapeBounds);
            EasyMock.replay((Object[])new Object[]{shape});
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertEquals((Object)shapeBounds, (Object)target.getBounds());
            TestExplicitBoundsShape.assertEquals((Object)shapeBounds, (Object)target.getBounds2D());
            Rectangle bounds = new Rectangle(1, 2, 5, 6);
            target.setBounds((Rectangle2D)bounds);
            TestExplicitBoundsShape.assertEquals((Object)bounds, (Object)target.getBounds());
            TestExplicitBoundsShape.assertEquals((Object)bounds, (Object)target.getBounds2D());
            EasyMock.verify((Object[])new Object[]{shape});
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testEquals_Shape() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertTrue((boolean)target.equals((Object)shape));
            Rectangle bounds = new Rectangle(1, 2, 5, 6);
            target.setBounds((Rectangle2D)bounds);
            TestExplicitBoundsShape.assertFalse((boolean)target.equals((Object)shape));
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testEquals_Null() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertFalse((boolean)target.equals(null));
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testEquals_Object() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertFalse((boolean)target.equals(new Object()));
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testEquals_SameObject() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertTrue((boolean)target.equals((Object)target));
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testEquals_OtherObject() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            Shape shape2 = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            ExplicitBoundsShape other = new ExplicitBoundsShape(shape);
            ExplicitBoundsShape another = new ExplicitBoundsShape(shape2);
            TestExplicitBoundsShape.assertTrue((boolean)target.equals((Object)other));
            TestExplicitBoundsShape.assertFalse((boolean)target.equals((Object)another));
            Rectangle bounds = new Rectangle(1, 1, 4, 4);
            target.setBounds((Rectangle2D)bounds);
            TestExplicitBoundsShape.assertFalse((boolean)target.equals((Object)other));
            another.setBounds((Rectangle2D)bounds);
            TestExplicitBoundsShape.assertFalse((boolean)target.equals((Object)another));
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    public void testHashCode() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            TestExplicitBoundsShape.assertEquals((int)shape.hashCode(), (int)target.hashCode());
            Rectangle bounds = new Rectangle(1, 1, 4, 4);
            target.setBounds((Rectangle2D)bounds);
            TestExplicitBoundsShape.assertFalse((shape.hashCode() == target.hashCode() ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            TestExplicitBoundsShape.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }
}

