/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3.geotiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.s3.S3ImageInputStreamImpl;
import org.geotools.s3.geotiff.S3GeoTiffReader;
import org.geotools.util.factory.Hints;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class S3GeoTiffFormat
extends GeoTiffFormat {
    private Properties prop;
    private static final Logger LOGGER = Logger.getLogger(S3GeoTiffFormat.class.getName());
    private static final DefaultParameterDescriptor<String> AWS_REGION = new DefaultParameterDescriptor("AwsRegion", String.class, (Object[])null, (Object)"US_EAST_1");

    public S3GeoTiffFormat() {
        block15: {
            this.writeParameters = null;
            this.mInfo = new HashMap();
            this.mInfo.put("name", "S3GeoTiff");
            this.mInfo.put("description", "Tagged Image File Format with Geographic information hosted on S3");
            this.mInfo.put("vendor", "Boundless Geo");
            this.mInfo.put("version", "1.0");
            this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, SUGGESTED_TILE_SIZE, AWS_REGION}));
            this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{RETAIN_AXES_ORDER, AbstractGridFormat.GEOTOOLS_WRITE_PARAMS, AbstractGridFormat.PROGRESS_LISTENER}));
            try {
                if (this.prop != null) break block15;
                this.prop = new Properties();
                String property = System.getProperty("s3.properties.location");
                if (property != null) {
                    try (FileInputStream resourceAsStream = new FileInputStream(property);){
                        this.prop.load(resourceAsStream);
                        break block15;
                    }
                }
                LOGGER.severe("Properties are missing! The system property 's3.properties.location' should be set and contain the path to the s3.properties file.");
            }
            catch (IOException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    public GeoTiffReader getReader(Object source, Hints hints) {
        try {
            S3ImageInputStreamImpl inStream;
            if (source instanceof File) {
                throw new UnsupportedOperationException("Can't instantiate S3 with a File handle");
            }
            if (source instanceof String) {
                inStream = new S3ImageInputStreamImpl((String)source);
            } else if (source instanceof URL) {
                inStream = new S3ImageInputStreamImpl((URL)source);
            } else {
                throw new IllegalArgumentException("Can't create S3ImageInputStream from input of type: " + source.getClass());
            }
            return new S3GeoTiffReader(inStream, hints);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception raised trying to instantiate S3 image input stream from source.", e);
            throw new RuntimeException(e);
        }
    }

    public boolean accepts(Object o, Hints hints) {
        if (o == null) {
            return false;
        }
        boolean accepts = false;
        if (o instanceof String) {
            String url = (String)o;
            if (url.contains("://")) {
                accepts = this.containsS3orAliasPrefix(url.split("://")[0]);
            }
        } else if (o instanceof URL) {
            String protocol = ((URL)o).getProtocol();
            accepts = this.containsS3orAliasPrefix(protocol);
        }
        return accepts;
    }

    public boolean accepts(Object source) {
        return this.accepts(source, null);
    }

    private boolean containsS3orAliasPrefix(String prefix) {
        return "s3".equals(prefix) || this.prop.get(prefix + ".s3.user") != null;
    }
}

