/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.s3.cache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheConfig {
    private static final Logger LOGGER = Logger.getLogger("S3");
    public static final String S3_CHUNK_SIZE_BYTES = "s3.caching.chunkSizeBytes";
    public static final String S3_CACHING_DISABLE_DISK = "s3.caching.disableDisk";
    public static final String S3_CACHING_USE_OFF_HEAP = "s3.caching.useOffHeap";
    public static final String S3_CACHING_CHUNK_SIZE_BYTES = "s3.caching.chunkSizeBytes";
    public static final String S3_CACHING_DISK_CACHE_SIZE = "s3.caching.diskCacheSize";
    public static final String S3_CACHING_DISK_PATH = "s3.caching.diskPath";
    public static final String S3_CACHING_EH_CACHE_CONFIG = "s3.caching.ehCacheConfig";
    public static final int MEBIBYTE_IN_BYTES = 0x100000;
    public static final String S3_CACHING_HEAP_SIZE = "s3.caching.heapSize";
    public static final String S3_CACHING_TIME_TO_IDLE = "s3.caching.timeToIdle";
    public static final String S3_CACHING_TIME_TO_LIVE = "s3.caching.timeToLive";
    private boolean useDiskCache = true;
    private boolean useOffHeapCache = false;
    private int chunkSizeBytes = 0x500000;
    private int diskCacheSize = 524288000;
    private int heapSize = 0x3200000;
    private Path cacheDirectory;
    private String configurationPath;
    private long timeToIdle = 0L;
    private long timeToLive = 0L;

    public static CacheConfig getDefaultConfig() {
        CacheConfig config = new CacheConfig();
        if (System.getProperty("s3.caching.chunkSizeBytes") != null) {
            config.setChunkSizeBytes(Integer.getInteger("s3.caching.chunkSizeBytes"));
        }
        if (Boolean.getBoolean(S3_CACHING_DISABLE_DISK)) {
            config.setUseDiskCache(false);
        }
        if (Boolean.getBoolean(S3_CACHING_USE_OFF_HEAP)) {
            config.setUseOffHeapCache(true);
        }
        if (System.getProperty("s3.caching.chunkSizeBytes") != null) {
            try {
                Integer chunkSize = Integer.parseInt(System.getProperty("s3.caching.chunkSizeBytes"));
                config.setChunkSizeBytes(chunkSize);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Can't parse chunk size", e);
            }
        }
        if (System.getProperty(S3_CACHING_HEAP_SIZE) != null) {
            try {
                Integer heapSize = Integer.parseInt(System.getProperty(S3_CACHING_HEAP_SIZE));
                config.setHeapSize(heapSize);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Can't parse heap", e);
            }
        }
        if (System.getProperty(S3_CACHING_DISK_CACHE_SIZE) != null) {
            try {
                Integer diskCacheSize = Integer.parseInt(System.getProperty(S3_CACHING_DISK_CACHE_SIZE));
                config.setDiskCacheSize(diskCacheSize);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Can't parse disk cache size", e);
            }
        }
        if (System.getProperty(S3_CACHING_DISK_PATH) != null) {
            try {
                String diskPath = System.getProperty(S3_CACHING_DISK_PATH);
                Path cachePath = Paths.get(diskPath, new String[0]);
                config.setCacheDirectory(cachePath);
            }
            catch (InvalidPathException e) {
                LOGGER.log(Level.FINER, "Can't parse disk cache path", e);
            }
        } else if (config.isUseDiskCache()) {
            try {
                config.setCacheDirectory(Files.createTempDirectory("s3Cachine", new FileAttribute[0]));
            }
            catch (IOException e) {
                throw new RuntimeException("CAN'T CREATE TEMP CACHING DIRECTORY AND NO DIRECTORY SPECIFIED", e);
            }
        }
        if (System.getProperty(S3_CACHING_EH_CACHE_CONFIG) != null) {
            String ehCachePath = System.getProperty(S3_CACHING_EH_CACHE_CONFIG);
            config.setConfigurationPath(ehCachePath);
        }
        if (System.getProperty(S3_CACHING_TIME_TO_IDLE) != null) {
            try {
                long timeToIdle = Long.parseLong(System.getProperty(S3_CACHING_TIME_TO_IDLE));
                config.setTimeToIdle(timeToIdle);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Can't parse time to idle", e);
            }
        }
        if (System.getProperty(S3_CACHING_TIME_TO_LIVE) != null) {
            try {
                long timeToLive = Long.parseLong(System.getProperty(S3_CACHING_TIME_TO_LIVE));
                config.setTimeToLive(timeToLive);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINER, "Can't parse time to live", e);
            }
        }
        return config;
    }

    public boolean isUseDiskCache() {
        return this.useDiskCache;
    }

    public void setUseDiskCache(boolean useDiskCache) {
        this.useDiskCache = useDiskCache;
    }

    public boolean isUseOffHeapCache() {
        return this.useOffHeapCache;
    }

    public void setUseOffHeapCache(boolean useOffHeapCache) {
        this.useOffHeapCache = useOffHeapCache;
    }

    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    public void setChunkSizeBytes(int chunkSizeBytes) {
        this.chunkSizeBytes = chunkSizeBytes;
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public void setDiskCacheSize(int diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
    }

    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    public int getHeapSize() {
        return this.heapSize;
    }

    public void setHeapSize(int heapSize) {
        this.heapSize = heapSize;
    }

    public long getTimeToIdle() {
        return this.timeToIdle;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToIdle(long timeToIdle) {
        this.timeToIdle = timeToIdle;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }
}

