/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.resolver.data;

import java.util.Collections;
import java.util.List;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.gml3.GMLSchema;
import org.geotools.xs.XSSchema;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class SampleDataAccessData {
    public static final String NAMESPACE_PREFIX = "gsml";
    public static final String NAMESPACE_URI = "http://www.example.org/sample-data-access/GeoSciML-lite";
    public static final Name GEOLOGICUNIT_TYPE_NAME = new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "GeologicUnit");
    public static final FeatureType GEOLOGICUNIT_TYPE = new FeatureTypeImpl(GEOLOGICUNIT_TYPE_NAME, Collections.emptyList(), null, false, Collections.emptyList(), (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
    public static final AttributeDescriptor SPECIFICATION_DESCRIPTOR = new AttributeDescriptorImpl((AttributeType)GMLSchema.FEATUREPROPERTYTYPE_TYPE, (Name)new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "specification"), 0, 1, false, null);
    public static final AttributeDescriptor SHAPE_DESCRIPTOR = new AttributeDescriptorImpl(GMLSchema.GEOMETRYPROPERTYTYPE_TYPE, (Name)new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "shape"), 1, 1, false, null);
    private static final List<PropertyDescriptor> MAPPEDFEATURE_TYPE_SCHEMA = List.of(SPECIFICATION_DESCRIPTOR, SHAPE_DESCRIPTOR);
    public static final Name MAPPEDFEATURE_TYPE_NAME = new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "MappedFeature");
    public static final FeatureType MAPPEDFEATURE_TYPE = new FeatureTypeImpl(MAPPEDFEATURE_TYPE_NAME, MAPPEDFEATURE_TYPE_SCHEMA, null, false, Collections.emptyList(), (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);

    public static Feature createMappedFeature(String id, String bgsid, String description, String specificationDescription, Geometry shape) {
        List<AttributeImpl> specificationFeatureProperties = List.of(new AttributeImpl((Object)specificationDescription, (AttributeDescriptor)new AttributeDescriptorImpl(XSSchema.STRING_TYPE, (Name)new NameImpl("http://www.opengis.net/gml", "description"), 0, 1, false, null), null));
        FeatureImpl specificationFeature = new FeatureImpl(specificationFeatureProperties, GEOLOGICUNIT_TYPE, (FeatureId)new FeatureIdImpl(id + ".spec"));
        List<AttributeImpl> properties = List.of(new AttributeImpl((Object)description, (AttributeDescriptor)new AttributeDescriptorImpl(XSSchema.STRING_TYPE, (Name)new NameImpl("http://www.opengis.net/gml", "description"), 0, 1, false, null), null), new ComplexAttributeImpl(List.of(specificationFeature), SPECIFICATION_DESCRIPTOR, null), new AttributeImpl((Object)shape, SHAPE_DESCRIPTOR, null));
        return new FeatureImpl(properties, MAPPEDFEATURE_TYPE, (FeatureId)new FeatureIdImpl(id));
    }

    public static List<Feature> createMappedFeatures() {
        return List.of(SampleDataAccessData.createMappedFeature("mf1", "651", "GUNTHORPE FORMATION", "Gunthorpe specification description", SampleDataAccessData.readGeometry("POLYGON((-1.2 52.5,-1.2 52.6,-1.1 52.6,-1.1 52.5,-1.2 52.5))")), SampleDataAccessData.createMappedFeature("mf2", "269", "MERCIA MUDSTONE GROUP", "Mercia specification description", SampleDataAccessData.readGeometry("POLYGON((-1.3 52.5,-1.3 52.6,-1.2 52.6,-1.2 52.5,-1.3 52.5))")));
    }

    public static Geometry readGeometry(String wellKnownText) {
        try {
            return new WKTReader().read(wellKnownText);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

