/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TestData
implements Runnable {
    private static final String DIRECTORY = "test-data";
    private static final String ENCODING = "UTF-8";
    public static final String EXTENSIVE_TEST_KEY = "org.geotools.test.extensive";
    public static final String INTERACTIVE_TEST_KEY = "org.geotools.test.interactive";
    private static final LinkedList<Deletable> toDelete = new LinkedList();
    private static final boolean mediaLibAvailable;

    protected TestData() {
    }

    private static boolean getBoolean(String name) {
        try {
            return Boolean.getBoolean(name);
        }
        catch (SecurityException exception) {
            Logger.getLogger("org.geotools").warning(exception.getLocalizedMessage());
            return false;
        }
    }

    public static boolean isBaseJavaPlatform() {
        return System.getProperty("java.version").startsWith("1.5");
    }

    public static boolean isMediaLibAvailable() {
        return mediaLibAvailable;
    }

    public static boolean isExtensiveTest() {
        return TestData.getBoolean(EXTENSIVE_TEST_KEY);
    }

    public static boolean isInteractiveTest() {
        return TestData.getBoolean(INTERACTIVE_TEST_KEY);
    }

    public static URL getResource(Object caller, String name) {
        name = name == null || (name = name.trim()).length() == 0 ? DIRECTORY : "test-data/" + name;
        if (caller != null) {
            Class<?> c = caller instanceof Class ? (Class<?>)caller : caller.getClass();
            return c.getResource(name);
        }
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    public static URL url(Object caller, String path) throws FileNotFoundException {
        URL url = TestData.getResource(caller, path);
        if (url == null) {
            throw new FileNotFoundException("Can not locate test-data for \"" + path + '\"');
        }
        return url;
    }

    public static File file(Object caller, String path) throws FileNotFoundException, IOException {
        URL url = TestData.url(caller, path);
        File file = new File(URLDecoder.decode(url.getPath(), ENCODING));
        if (!file.exists()) {
            throw new FileNotFoundException("Can not locate test-data for \"" + path + '\"');
        }
        return file;
    }

    public static File temp(Object caller, String name) throws IOException {
        File testData = TestData.file(caller, null);
        int split = name.lastIndexOf(46);
        String prefix = split < 0 ? name : name.substring(0, split);
        String suffix = split < 0 ? "tmp" : name.substring(split + 1);
        File tmp = File.createTempFile(prefix, '.' + suffix, testData);
        TestData.deleteOnExit(tmp);
        return tmp;
    }

    public static InputStream openStream(Object caller, String name) throws FileNotFoundException, IOException {
        return new BufferedInputStream(TestData.url(caller, name).openStream());
    }

    public static LineNumberReader openReader(Object caller, String name) throws FileNotFoundException, IOException {
        return new LineNumberReader(new InputStreamReader(TestData.url(caller, name).openStream()));
    }

    public static ReadableByteChannel openChannel(Object caller, String name) throws FileNotFoundException, IOException {
        URL url = TestData.url(caller, name);
        File file = new File(URLDecoder.decode(url.getPath(), ENCODING));
        if (file.exists()) {
            return new RandomAccessFile(file, "r").getChannel();
        }
        return Channels.newChannel(url.openStream());
    }

    public static void unzipFile(Object caller, String name) throws FileNotFoundException, IOException {
        File file = TestData.file(caller, name);
        File parent = file.getParentFile().getAbsoluteFile();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[4096];
            while (entries.hasMoreElements()) {
                File path;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (path = new File(parent, entry.getName())).exists()) continue;
                File directory = path.getParentFile();
                if (directory != null && !directory.exists()) {
                    directory.mkdirs();
                }
                try (InputStream in = zipFile.getInputStream(entry);
                     FileOutputStream out = new FileOutputStream(path);){
                    int len;
                    while ((len = in.read(buffer)) >= 0) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                TestData.deleteOnExit(path, false);
            }
        }
    }

    protected static void deleteOnExit(File file) {
        TestData.deleteOnExit(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void deleteOnExit(File file, boolean force) {
        if (force) {
            file.deleteOnExit();
        }
        Deletable entry = new Deletable(file, force);
        LinkedList<Deletable> linkedList = toDelete;
        synchronized (linkedList) {
            if (file.isFile()) {
                toDelete.addFirst(entry);
            } else {
                toDelete.addLast(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int iteration = 5;
        LinkedList<Deletable> linkedList = toDelete;
        synchronized (linkedList) {
            while (!toDelete.isEmpty() && --iteration >= 0) {
                System.gc();
                System.runFinalization();
                Iterator it = toDelete.iterator();
                while (it.hasNext()) {
                    Deletable f;
                    block8: {
                        f = (Deletable)it.next();
                        try {
                            if (f.delete()) {
                                it.remove();
                                continue;
                            }
                        }
                        catch (SecurityException e) {
                            if (iteration != 0) break block8;
                            System.err.print(e.getClass().getName());
                            System.err.print(": ");
                        }
                    }
                    if (iteration != 0 || f.canIgnore()) continue;
                    System.err.print("Can't delete ");
                    System.err.println(f);
                }
            }
        }
    }

    static {
        boolean mediaLib = false;
        Class<?> mediaLibImage = null;
        try {
            mediaLibImage = Class.forName("com.sun.medialib.mlib.Image");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl = mediaLib = mediaLibImage != null;
        if (mediaLib) {
            try {
                boolean bl2 = mediaLib = !Boolean.getBoolean("com.sun.media.jai.disableMediaLib");
                if (mediaLib) {
                    final Class<?> mImage = mediaLibImage;
                    mediaLib = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                Class[] params = new Class[]{};
                                Method method = mImage.getDeclaredMethod("isAvailable", params);
                                Object[] paramsObj = new Object[]{};
                                Object o = mImage.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                return (Boolean)method.invoke(o, paramsObj);
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                mediaLib = false;
            }
        }
        mediaLibAvailable = mediaLib;
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new TestData(), "Test data cleaner"));
    }

    private static final class Deletable {
        private final File file;
        private final long timestamp;

        public Deletable(File file, boolean force) {
            this.file = file;
            this.timestamp = force ? Long.MIN_VALUE : file.lastModified();
        }

        public boolean canIgnore() {
            return this.timestamp != Long.MIN_VALUE && this.file.isDirectory();
        }

        public boolean delete() {
            if (!this.file.exists() || this.file.lastModified() <= this.timestamp) {
                return true;
            }
            return this.file.delete();
        }

        public String toString() {
            return String.valueOf(this.file);
        }
    }
}

