/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test.wiremock;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;

public class FileRangeResponseTransformer
implements ResponseDefinitionTransformerV2 {
    public static final String TRANSFORMER_NAME = "file-range-response-transformer";

    public ResponseDefinition transform(ServeEvent serveEvent) {
        String rangeHeader = serveEvent.getRequest().getHeader("Range");
        File file = (File)serveEvent.getTransformerParameters().get((Object)"filePath");
        try {
            byte[] fileBytes = Files.readAllBytes(file.toPath());
            int fileLength = fileBytes.length;
            if (rangeHeader != null && rangeHeader.startsWith("bytes=")) {
                int end;
                String[] ranges = rangeHeader.substring(6).split("-");
                int start = Integer.parseInt(ranges[0]);
                int n = end = ranges.length > 1 && !ranges[1].isEmpty() ? Integer.parseInt(ranges[1]) : fileLength - 1;
                if (end > fileLength - 1) {
                    end = fileLength - 1;
                }
                if (start >= fileLength || start > end) {
                    return ResponseDefinitionBuilder.responseDefinition().withStatus(416).withHeaders(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Range", (String[])new String[]{"bytes */" + fileLength})})).build();
                }
                byte[] partialContent = Arrays.copyOfRange(fileBytes, start, end + 1);
                return ResponseDefinitionBuilder.responseDefinition().withStatus(206).withHeaders(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Range", (String[])new String[]{"bytes " + start + "-" + end + "/" + fileLength}), HttpHeader.httpHeader((String)"Content-Length", (String[])new String[]{String.valueOf(partialContent.length)}), HttpHeader.httpHeader((String)"Content-Type", (String[])new String[]{Files.probeContentType(file.toPath())})})).withBody(partialContent).build();
            }
            return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withHeaders(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Length", (String[])new String[]{String.valueOf(fileLength)}), HttpHeader.httpHeader((String)"Content-Type", (String[])new String[]{Files.probeContentType(file.toPath())})})).withBody(fileBytes).build();
        }
        catch (IOException e) {
            return ResponseDefinitionBuilder.responseDefinition().withStatus(500).withBody("Error reading file: " + e.getMessage()).build();
        }
    }

    public String getName() {
        return TRANSFORMER_NAME;
    }

    public boolean applyGlobally() {
        return false;
    }
}

