/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

class RemappingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    Map<String, String> attributesMapping;

    public static SimpleFeatureCollection getShapefileCompatibleCollection(SimpleFeatureCollection fc) {
        Map<String, String> attributeMappings = RemappingFeatureCollection.createAttributeMappings((SimpleFeatureType)fc.getSchema());
        for (Map.Entry<String, String> entry : attributeMappings.entrySet()) {
            if (entry.getKey().equals(entry.getValue())) continue;
            return new RemappingFeatureCollection(fc, attributeMappings);
        }
        return fc;
    }

    private static Map<String, String> createAttributeMappings(SimpleFeatureType schema) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> usedFieldNames = new HashSet<String>();
        usedFieldNames.add("the_geom");
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (attDesc instanceof GeometryDescriptor) {
                result.put(attDesc.getLocalName(), "the_geom");
                continue;
            }
            String name = attDesc.getLocalName();
            result.put(attDesc.getLocalName(), RemappingFeatureCollection.getShapeCompatibleName(usedFieldNames, name));
        }
        return result;
    }

    private static String getShapeCompatibleName(Set<String> usedFieldNames, String name) {
        if (((String)name).length() > 10) {
            name = ((String)name).substring(0, 10);
        }
        int counter = 0;
        while (usedFieldNames.contains(name)) {
            String postfix = "" + counter++;
            name = ((String)name).substring(0, ((String)name).length() - postfix.length()) + postfix;
        }
        usedFieldNames.add((String)name);
        return name;
    }

    public RemappingFeatureCollection(SimpleFeatureCollection delegate, Map<String, String> attributesMapping) {
        super(delegate);
        this.attributesMapping = attributesMapping;
    }

    public SimpleFeatureType getSchema() {
        return this.remapSchema((SimpleFeatureType)this.delegate.getSchema());
    }

    static Map<String, String> invertMappings(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : map.keySet()) {
            result.put(map.get(key), key);
        }
        return result;
    }

    private SimpleFeatureType remapSchema(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(schema.getName());
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (attDesc instanceof GeometryDescriptor) {
                GeometryDescriptor geoDesc = (GeometryDescriptor)attDesc;
                builder.add(this.attributesMapping.get(attDesc.getLocalName()), attDesc.getType().getBinding(), geoDesc.getCoordinateReferenceSystem());
                continue;
            }
            List filters = attDesc.getType().getRestrictions();
            if (filters != null && !filters.isEmpty()) {
                builder.restrictions(filters);
            }
            builder.add(this.attributesMapping.get(attDesc.getLocalName()), attDesc.getType().getBinding());
        }
        return builder.buildFeatureType();
    }

    public SimpleFeatureIterator features() {
        return new RemappingIterator(this.delegate.features(), this.attributesMapping, this.getSchema());
    }

    static SimpleFeature remap(SimpleFeature source, Map<String, String> attributeMappings, SimpleFeatureBuilder builder) {
        SimpleFeatureType target = builder.getFeatureType();
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = target.getDescriptor(i);
            Object value = null;
            String mappedName = attributeMappings.get(attributeType.getLocalName());
            if (source.getFeatureType().getDescriptor(mappedName) != null) {
                value = source.getAttribute(mappedName);
            }
            builder.add(value);
        }
        return builder.buildFeature(source.getIdentifier().getID());
    }

    public static class RemappingIterator
    implements SimpleFeatureIterator {
        Map<String, String> attributesMapping;
        SimpleFeatureIterator delegate;
        SimpleFeatureBuilder builder;

        public RemappingIterator(SimpleFeatureIterator delegate, Map<String, String> attributesMapping, SimpleFeatureType schema) {
            this.delegate = delegate;
            this.attributesMapping = RemappingFeatureCollection.invertMappings(attributesMapping);
            this.builder = new SimpleFeatureBuilder(schema);
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() {
            return RemappingFeatureCollection.remap((SimpleFeature)this.delegate.next(), this.attributesMapping, this.builder);
        }

        public void close() {
            this.delegate.close();
        }
    }
}

