/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import org.geotools.data.solr.ExpressionToSolr;
import org.geotools.data.solr.SolrSpatialStrategy;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Literal;

public final class ExpressionToSolrTest {
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testEnvelopeExpresion() throws ParseException {
        ExpressionToSolr expressionToSolr = new ExpressionToSolr();
        expressionToSolr.setSpatialStrategy(SolrSpatialStrategy.DEFAULT);
        Envelope env = new Envelope(1.0, 2.0, 3.0, 4.0);
        Literal literal = this.ff.literal((Object)env);
        Object result = expressionToSolr.visit(literal, null);
        Assert.assertNotNull((Object)result);
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(result.toString());
        Assert.assertTrue((boolean)(geometry instanceof Polygon));
        Assert.assertEquals((Object)env, (Object)geometry.getEnvelopeInternal());
    }
}

