/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.util.Date;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.solr.SolrTestSupport;
import org.geotools.data.store.ContentFeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.temporal.Period;

public class SolrTemporalTest
extends SolrTestSupport {
    public void testCompareDateFilter() throws Exception {
        Date date;
        this.init();
        Date testDate = this.df.parse("2009-06-28 00:00:00");
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsLessThanOrEqualTo f = ff.lessOrEqual((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)testDate));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)4, (int)features.size());
        try (SimpleFeatureIterator it = features.features();){
            while (it.hasNext()) {
                date = (Date)((SimpleFeature)it.next()).getAttribute("installed_tdt");
                SolrTemporalTest.assertTrue((date.before(testDate) || date.equals(testDate) ? 1 : 0) != 0);
            }
        }
        f = ff.greaterOrEqual((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)testDate));
        features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)5, (int)features.size());
        it = features.features();
        try {
            while (it.hasNext()) {
                date = (Date)((SimpleFeature)it.next()).getAttribute("installed_tdt");
                SolrTemporalTest.assertTrue((date.after(testDate) || date.equals(testDate) ? 1 : 0) != 0);
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public void testAfterFilter() throws Exception {
        this.init();
        Date testDate = this.df.parse("2009-28-06 00:00:00");
        FilterFactory ff = this.dataStore.getFilterFactory();
        After f = ff.after((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)testDate));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)5, (int)features.size());
    }

    public void testAfterInterval() throws Exception {
        this.init();
        Period period = this.period("2011-21-05 00:00:00", "2011-15-09 00:00:00");
        FilterFactory ff = this.dataStore.getFilterFactory();
        After f = ff.after((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)period));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)4, (int)features.size());
    }

    public void testBeforeFilter() throws Exception {
        this.init();
        Date testDate = this.df.parse("2009-28-06 00:00:00");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Before f = ff.before((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)testDate));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)4, (int)features.size());
    }

    public void testBeforeInterval() throws Exception {
        this.init();
        Period period = this.period("2000-12-11 00:00:00", "2011-05-21 00:00:00");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Before f = ff.before((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)period));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }

    public void testBegins() throws Exception {
        this.init();
        Period period = this.period("2004-20-06 03:44:56", "2014-22-06 03:44:56");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Begins f = ff.begins((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)period));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }

    public void testBegunBy() throws Exception {
        this.init();
        Period period = this.period("2004-20-06 03:44:56", "2014-22-06 03:44:56");
        FilterFactory ff = this.dataStore.getFilterFactory();
        BegunBy f = ff.begunBy((Expression)ff.literal((Object)period), (Expression)ff.property("installed_tdt"));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }

    public void testEnds() throws Exception {
        this.init();
        Period period = this.period("2002-20-06 03:44:56", "2004-20-06 03:44:56");
        FilterFactory ff = this.dataStore.getFilterFactory();
        Ends f = ff.ends((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)period));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }

    public void testEndedBy() throws Exception {
        this.init();
        Period period = this.period("2004-11-06 03:44:56", "2004-20-06 03:44:56");
        FilterFactory ff = this.dataStore.getFilterFactory();
        EndedBy f = ff.endedBy((Expression)ff.literal((Object)period), (Expression)ff.property("installed_tdt"));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }

    public void testDuring() throws Exception {
        this.init();
        Period period = this.period("2004-19-06 03:44:56", "2004-20-06 03:44:58");
        FilterFactory ff = this.dataStore.getFilterFactory();
        During f = ff.during((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)period));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }

    public void testTContains() throws Exception {
        this.init();
        Period period = this.period("2004-19-06 03:44:56", "2004-20-06 03:44:58");
        FilterFactory ff = this.dataStore.getFilterFactory();
        TContains f = ff.tcontains((Expression)ff.literal((Object)period), (Expression)ff.property("installed_tdt"));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }

    public void testTEquals() throws Exception {
        this.init();
        Date testDate = this.df.parse("2013-01-10 00:13:11");
        FilterFactory ff = this.dataStore.getFilterFactory();
        TEquals f = ff.tequals((Expression)ff.property("installed_tdt"), (Expression)ff.literal((Object)testDate));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrTemporalTest.assertEquals((int)1, (int)features.size());
    }
}

