/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.geotools.data.solr.SolrLayerMapper;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;

public class FieldLayerMapper
implements SolrLayerMapper {
    static Logger LOGGER = Logging.getLogger(FieldLayerMapper.class);
    String field;

    public FieldLayerMapper(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public List<String> createTypeNames(HttpSolrClient solrServer) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        SolrQuery query = new SolrQuery();
        query.setQuery("*:*");
        query.addFacetField(new String[]{this.field});
        query.setFacet(true);
        query.setFacetMinCount(1);
        query.setFacetSort("index");
        query.setRows(Integer.valueOf(0));
        query.setParam("omitHeader", true);
        QueryResponse rsp = solrServer.query((SolrParams)query);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "SOLR query done: " + query.toString());
        }
        List uniqueFacetFields = ((FacetField)rsp.getFacetFields().get(0)).getValues();
        for (FacetField.Count field : uniqueFacetFields) {
            names.add(field.getName());
        }
        return names;
    }

    @Override
    public String prepareFilterQueryForSchema() {
        return this.field + ":*";
    }

    @Override
    public String prepareFilterQuery(SimpleFeatureType featureType) {
        return this.field + ":" + featureType.getTypeName();
    }
}

