/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.geotools.data.solr.FieldLayerMapper;
import org.geotools.data.solr.SingleLayerMapper;
import org.geotools.data.solr.SolrDataStoreFactory;
import org.opengis.feature.simple.SimpleFeatureType;

public interface SolrLayerMapper {
    public List<String> createTypeNames(HttpSolrClient var1) throws Exception;

    public String prepareFilterQueryForSchema();

    public String prepareFilterQuery(SimpleFeatureType var1);

    public static enum Type {
        FIELD{

            @Override
            public SolrLayerMapper createMapper(Map<String, ?> params) throws IOException {
                if (!params.containsKey(SolrDataStoreFactory.FIELD.key)) {
                    throw new IllegalArgumentException(String.format("Layer mapper '%s' requires '%s' key", FIELD.name(), SolrDataStoreFactory.FIELD.key));
                }
                return new FieldLayerMapper((String)SolrDataStoreFactory.FIELD.lookUp(params));
            }
        }
        ,
        SINGLE{

            @Override
            public SolrLayerMapper createMapper(Map<String, ?> params) {
                return new SingleLayerMapper();
            }
        };


        public abstract SolrLayerMapper createMapper(Map<String, ?> var1) throws IOException;
    }
}

