/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr.complex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.digester.Digester;
import org.geotools.appschema.filter.FilterFactoryImplReportInvalidProperty;
import org.geotools.data.DataAccess;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.SourceDataStore;
import org.geotools.data.complex.config.TypeMapping;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.complex.spi.CustomSourceDataStore;
import org.geotools.data.solr.IndexesConfig;
import org.geotools.data.solr.SingleLayerMapper;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrFeatureSource;
import org.geotools.data.solr.complex.ComplexDataStoreConfig;
import org.geotools.data.solr.complex.SolrMultipleValue;
import org.geotools.filter.expression.AbstractExpressionVisitor;
import org.geotools.util.Converters;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public final class ComplexDataStoreFactory
implements CustomSourceDataStore {
    private final FilterFactory filterFactory = new FilterFactoryImplReportInvalidProperty();

    public void configXmlDigesterDataSources(Digester digester) {
        XMLConfigDigester.setCommonSourceDataStoreRules(ComplexDataStoreConfigWithContext.class, (String)"SolrDataStore", (Digester)digester);
        String dataStores = "AppSchemaDataAccess/sourceDataStores/";
        digester.addCallMethod(dataStores + "SolrDataStore/url", "setUrl", 1);
        digester.addCallParam(dataStores + "SolrDataStore/url", 0);
        digester.addSetProperties(dataStores + "SolrDataStore/index", "name", "currentIndex");
        digester.addCallMethod(dataStores + "SolrDataStore/index/geometry", "addGeometry", 4);
        digester.addCallParam(dataStores + "SolrDataStore/index/geometry/name", 0);
        digester.addCallParam(dataStores + "SolrDataStore/index/geometry/srid", 1);
        digester.addCallParam(dataStores + "SolrDataStore/index/geometry/type", 2);
        digester.addCallParam(dataStores + "SolrDataStore/index/geometry", 3, "default");
    }

    public void configXmlDigesterAttributesMappings(Digester digester) {
        String rootPath = "AppSchemaDataAccess/typeMappings/FeatureTypeMapping/attributeMappings/AttributeMapping";
        String multipleValuePath = rootPath + "/solrMultipleValue";
        digester.addObjectCreate(multipleValuePath, "http://www.geotools.org/app-schema", SolrMultipleValue.class);
        digester.addCallMethod(multipleValuePath, "setExpression", 1);
        digester.addCallParam(multipleValuePath, 0);
        digester.addSetNext(multipleValuePath, "setMultipleValue");
    }

    public DataAccessMappingFeatureIterator buildIterator(AppSchemaDataAccess store, FeatureTypeMapping featureTypeMapping, Query query, Transaction transaction) {
        if (!(featureTypeMapping.getSource() instanceof SolrFeatureSource)) {
            return null;
        }
        query.setSortBy(this.sortByFeatureTypeIds(featureTypeMapping));
        try {
            return new DataAccessMappingFeatureIterator(store, featureTypeMapping, query, false, true);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error creating iterator for feature type mapping '%s'.", featureTypeMapping.getMappingName()), exception);
        }
    }

    public DataAccess<? extends FeatureType, ? extends Feature> buildDataStore(SourceDataStore dataStoreConfig, AppSchemaDataAccessDTO appSchemaConfig) {
        if (!(dataStoreConfig instanceof ComplexDataStoreConfig)) {
            return null;
        }
        ComplexDataStoreConfig complexDataStoreConfig = (ComplexDataStoreConfig)dataStoreConfig;
        IndexesConfig indexesConfig = complexDataStoreConfig.getIndexesConfig();
        for (TypeMapping mapping : appSchemaConfig.getTypeMappings()) {
            Set<String> attributes = this.extractAttributesNames(mapping);
            indexesConfig.addAttributes(mapping.getSourceTypeName(), attributes);
            if (!this.isDenormalizedIndexMode(mapping, dataStoreConfig)) continue;
            indexesConfig.getIndexConfig(this.getTypeName(mapping, dataStoreConfig)).setDenormalizedIndexMode(true);
        }
        return new SolrDataStore(complexDataStoreConfig.getUrl(), new SingleLayerMapper(), indexesConfig);
    }

    private Set<String> extractAttributesNames(TypeMapping typeMapping) {
        HashSet<String> attributes = new HashSet<String>();
        List attributesMappings = typeMapping.getAttributeMappings();
        for (org.geotools.data.complex.config.AttributeMapping attributeMapping : attributesMappings) {
            Expression expression = this.parseExpression(attributeMapping.getSourceExpression());
            attributes.addAll(this.extractAttributesNames(expression));
            expression = this.parseExpression(attributeMapping.getIdentifierExpression());
            attributes.addAll(this.extractAttributesNames(expression));
            for (Object value : attributeMapping.getClientProperties().values()) {
                attributes.addAll(this.extractAttributesNames(this.parseExpression(value)));
            }
            if (!(attributeMapping.getMultipleValue() instanceof SolrMultipleValue)) continue;
            SolrMultipleValue multipleValue = (SolrMultipleValue)attributeMapping.getMultipleValue();
            attributes.addAll(this.extractAttributesNames(multipleValue.getExpression()));
        }
        return attributes;
    }

    private Set<String> extractAttributesNames(Expression expression) {
        AttributesExtractor visitor = new AttributesExtractor();
        expression.accept((ExpressionVisitor)visitor, null);
        return visitor.getAttributes();
    }

    private SortBy[] sortByFeatureTypeIds(FeatureTypeMapping featureTypeMapping) {
        ArrayList<SortBy> sortByExpressions = new ArrayList<SortBy>();
        for (AttributeMapping mapping : featureTypeMapping.getAttributeMappings()) {
            if (mapping.getIdentifierExpression() == null || mapping.getIdentifierExpression().equals(Expression.NIL)) continue;
            String attributeXpath = mapping.getTargetXPath().toString();
            SortBy sortByExpression = this.filterFactory.sort(attributeXpath, SortOrder.ASCENDING);
            sortByExpressions.add(sortByExpression);
        }
        return sortByExpressions.toArray(new SortBy[sortByExpressions.size()]);
    }

    private Expression parseExpression(Object value) {
        if (value instanceof Expression) {
            return (Expression)value;
        }
        return this.parseExpression((String)Converters.convert((Object)value, String.class));
    }

    private Expression parseExpression(String expression) {
        try {
            return AppSchemaDataAccessConfigurator.parseOgcCqlExpression((String)expression, (FilterFactory)this.filterFactory);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error parsing expression '%s'.", expression), exception);
        }
    }

    private String getTypeName(TypeMapping mapping, SourceDataStore dataStoreConfig) {
        if (dataStoreConfig.getId().equals(mapping.getIndexDataStore())) {
            return mapping.getIndexTypeName();
        }
        return mapping.getSourceTypeName();
    }

    private boolean isDenormalizedIndexMode(TypeMapping mapping, SourceDataStore dataStoreConfig) {
        return dataStoreConfig.getId().equals(mapping.getIndexDataStore());
    }

    private static class AttributesExtractor
    extends AbstractExpressionVisitor {
        private final Set<String> attributes = new HashSet<String>();

        private AttributesExtractor() {
        }

        public Object visit(PropertyName expression, Object data) {
            this.attributes.add(expression.getPropertyName());
            return expression;
        }

        public Set<String> getAttributes() {
            return this.attributes;
        }
    }

    public static final class ComplexDataStoreConfigWithContext
    extends ComplexDataStoreConfig {
        private String currentIndex;

        public void setCurrentIndex(String currentIndex) {
            this.currentIndex = currentIndex;
        }

        public void addGeometry(String attributeName, String srid, String type, String isDefault) {
            super.addGeometry(this.currentIndex, attributeName, srid, type, isDefault);
        }
    }
}

