/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.awt.RenderingHints;
import java.util.HashMap;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.solr.SolrTestSupport;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.util.factory.Hints;

public class SolrViewParametersTest
extends SolrTestSupport {
    public void testSinglesQParameters() throws Exception {
        this.init("not-active");
        HashMap<String, String> vparams = new HashMap<String, String>();
        vparams.put("q", "security_ss:WPA");
        Hints hints = new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, vparams);
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setHints(hints);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("speed_is"), (Expression)ff.literal((Object)"300"));
        q.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        SolrViewParametersTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.12");
        }
    }

    public void testMultipleQParameters() throws Exception {
        this.init();
        HashMap<String, String> vparams = new HashMap<String, String>();
        vparams.put("q", "security_ss:WPA -modem_b:true");
        Hints hints = new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, vparams);
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setHints(hints);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("speed_is"), (Expression)ff.literal((Object)"300"));
        q.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        SolrViewParametersTest.assertEquals((int)2, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((Object)((SimpleFeature)fsi.next()).getAttribute("modem_b"), (Object)false);
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((Object)((SimpleFeature)fsi.next()).getAttribute("modem_b"), (Object)false);
        }
    }

    public void testSinglesFQParameters() throws Exception {
        this.init("not-active");
        HashMap<String, String> vparams = new HashMap<String, String>();
        vparams.put("fq", "security_ss:WPA");
        Hints hints = new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, vparams);
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setHints(hints);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("speed_is"), (Expression)ff.literal((Object)"300"));
        q.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        SolrViewParametersTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((String)((SimpleFeature)fsi.next()).getID(), (String)"not-active.12");
        }
    }

    public void testMultipleFQParameters() throws Exception {
        this.init();
        HashMap<String, String> vparams = new HashMap<String, String>();
        vparams.put("fq", "security_ss:WPA -modem_b:true");
        Hints hints = new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, vparams);
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setHints(hints);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("speed_is"), (Expression)ff.literal((Object)"300"));
        q.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        SolrViewParametersTest.assertEquals((int)2, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((Object)((SimpleFeature)fsi.next()).getAttribute("modem_b"), (Object)false);
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((Object)((SimpleFeature)fsi.next()).getAttribute("modem_b"), (Object)false);
        }
    }

    public void testMixQandFQParameters() throws Exception {
        this.init();
        HashMap<String, String> vparams = new HashMap<String, String>();
        vparams.put("q", "security_ss:WPA");
        vparams.put("fq", "-modem_b:true");
        Hints hints = new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, vparams);
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setHints(hints);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("speed_is"), (Expression)ff.literal((Object)"300"));
        q.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        SolrViewParametersTest.assertEquals((int)2, (int)features.size());
        try (SimpleFeatureIterator fsi = features.features();){
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((Object)((SimpleFeature)fsi.next()).getAttribute("modem_b"), (Object)false);
            SolrViewParametersTest.assertTrue((boolean)fsi.hasNext());
            SolrViewParametersTest.assertEquals((Object)((SimpleFeature)fsi.next()).getAttribute("modem_b"), (Object)false);
        }
    }
}

