/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.solr.SolrTypeData;
import org.geotools.data.solr.StationData;
import org.geotools.data.solr.TestsSolrUtils;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.URLs;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class AppSchemaIntegrationTest
extends OnlineTestCase {
    private static final String SOLR_URL_KEY = "solr_url";
    private static final String CORE_NAME = "stations";
    private static final String testData = "/test-data/appschema/";
    private static final String xmlFileName = "mappings_solr.xml";
    private static final String ST_NAMESPACE = "http://www.stations.org/1.0";
    private static final Name mappedTypeName = Types.typeName((String)"multi_stations_solr");
    private static final String testDirStr = "target/test/" + AppSchemaIntegrationTest.class.getSimpleName();
    private static final File testDir = new File(testDirStr);
    private static final File appSchemaCacheDir = new File("target/test/" + AppSchemaIntegrationTest.class.getSimpleName() + "/app-schema-cache");
    private HttpSolrClient client;
    private static DataAccess<FeatureType, Feature> mappingDataStore;

    @Test
    public void testFeaturesData() throws Exception {
        FeatureSource fSource = mappingDataStore.getFeatureSource(mappedTypeName);
        List<Feature> features = this.toFeaturesList((FeatureCollection<FeatureType, Feature>)fSource.getFeatures());
        AppSchemaIntegrationTest.assertEquals((int)2, (int)features.size());
        NameImpl stationName = new NameImpl(ST_NAMESPACE, "stationName");
        for (Feature afeature : features) {
            String id = afeature.getIdentifier().getID();
            AppSchemaIntegrationTest.assertTrue((id.equals("13") || id.equals("7") ? 1 : 0) != 0);
            AppSchemaIntegrationTest.assertTrue((boolean)(afeature.getDefaultGeometryProperty().getValue() instanceof Point));
            Point theGeom = (Point)afeature.getDefaultGeometryProperty().getValue();
            GeometryFactory gf = new GeometryFactory();
            switch (id) {
                case "7": {
                    AppSchemaIntegrationTest.assertEquals((String)"Bologna", (String)((String)afeature.getProperty((Name)stationName).getValue()));
                    Point point1 = gf.createPoint(new Coordinate(11.34, 44.5));
                    AppSchemaIntegrationTest.assertEquals((Object)point1, (Object)theGeom);
                    break;
                }
                case "13": {
                    AppSchemaIntegrationTest.assertEquals((String)"Alessandria", (String)((String)afeature.getProperty((Name)stationName).getValue()));
                    Point point1 = gf.createPoint(new Coordinate(8.63, 44.92));
                    AppSchemaIntegrationTest.assertEquals((Object)point1, (Object)theGeom);
                }
            }
        }
    }

    private List<Feature> toFeaturesList(FeatureCollection<FeatureType, Feature> features) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        try (FeatureIterator i = features.features();){
            while (i.hasNext()) {
                result.add(i.next());
            }
        }
        return result;
    }

    protected void setUpInternal() throws Exception {
        this.client = new HttpSolrClient.Builder(this.getSolrCoreURL()).build();
        this.solrDataSetup();
        this.prepareFiles();
        this.setupDataStore();
    }

    protected void setupDataStore() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = new URL(new URL("file:"), "./" + testDirStr + "/mappings_solr.xml");
        dsParams.put("url", url.toExternalForm());
        mappingDataStore = DataAccessFinder.getDataStore(dsParams);
    }

    protected String getSolrCoreURL() {
        return this.fixture.getProperty(SOLR_URL_KEY) + "/stations";
    }

    protected void solrDataSetup() throws Exception {
        this.typeSetup();
        this.fieldsSetup();
        this.indexSetup();
    }

    protected void typeSetup() {
        TestsSolrUtils.createGeometryFieldType(this.client);
    }

    protected void fieldsSetup() throws Exception {
        File inFile = new File(AppSchemaIntegrationTest.class.getResource("/test-data/appschema/solr_types.xml").toURI());
        JAXBContext jcontext = JAXBContext.newInstance((Class[])new Class[]{SolrTypeData.SolrTypes.class});
        Unmarshaller um = jcontext.createUnmarshaller();
        SolrTypeData.SolrTypes types = (SolrTypeData.SolrTypes)um.unmarshal(inFile);
        for (SolrTypeData adata : types.getTypes()) {
            this.createField(adata.getName(), adata.getType(), adata.getMulti());
        }
    }

    protected void indexSetup() throws Exception {
        File inFile = new File(AppSchemaIntegrationTest.class.getResource("/test-data/appschema/stationsData.xml").toURI());
        JAXBContext jcontext = JAXBContext.newInstance((Class[])new Class[]{StationData.Stations.class});
        Unmarshaller um = jcontext.createUnmarshaller();
        StationData.Stations stations = (StationData.Stations)um.unmarshal(inFile);
        for (StationData adata : stations.getStations()) {
            this.client.add(adata.toSolrDoc());
        }
        this.client.commit();
    }

    protected void createField(String name, String type, boolean multiValued) {
        TestsSolrUtils.createField(this.client, name, type, multiValued);
    }

    protected void prepareFiles() throws Exception {
        this.copyTestData("meteo.xsd", testDir);
        this.copyTestData("stationsData.xml", testDir);
        File xmlFile = URLs.urlToFile((URL)AppSchemaIntegrationTest.class.getResource("/test-data/appschema/mappings_solr.xml"));
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new FileInputStream(xmlFile)));
        Node solrDs = doc.getElementsByTagName("SolrDataStore").item(0);
        NodeList dsChilds = solrDs.getChildNodes();
        for (int i = 0; i < dsChilds.getLength(); ++i) {
            Node achild = dsChilds.item(i);
            if (!achild.getNodeName().equals("url")) continue;
            achild.setTextContent(this.getSolrCoreURL());
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(testDir.getPath() + "/mappings_solr.xml"));
        transformer.transform(source, result);
        appSchemaCacheDir.mkdir();
    }

    private void copyTestData(String baseFileName, File destDir) throws IOException {
        destDir.mkdirs();
        FileUtils.copyFileToDirectory((File)URLs.urlToFile((URL)AppSchemaIntegrationTest.class.getResource(testData + baseFileName)), (File)destDir);
    }

    protected String getFixtureId() {
        return "appschema";
    }
}

