/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.client;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.stac.client.AbstractDocument;
import org.geotools.stac.client.CollectionExtent;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Collection<T>
extends AbstractDocument {
    static final Logger LOGGER = Logging.getLogger(Collection.class);
    protected CollectionExtent extent;

    public CollectionExtent getExtent() {
        return this.extent;
    }

    public void setExtent(CollectionExtent extent) {
        this.extent = extent;
    }

    public ReferencedEnvelope getBounds() {
        return Optional.ofNullable(this.extent).map(e -> e.getSpatial()).map(s -> this.toEnvelope((CollectionExtent.SpatialExtents)s)).orElse(null);
    }

    private ReferencedEnvelope toEnvelope(CollectionExtent.SpatialExtents ext) {
        ReferencedEnvelope result = null;
        CoordinateReferenceSystem crs = Optional.ofNullable(ext.getCrs()).map(Collection::decodeSafe).orElse((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        for (List<Double> box : ext.getBbox()) {
            ReferencedEnvelope re = this.toEnvelope(box, crs);
            if (result == null) {
                result = re;
                continue;
            }
            result.expandToInclude((Envelope)re);
        }
        return result;
    }

    private static CoordinateReferenceSystem decodeSafe(String s) {
        try {
            return CRS.decode((String)s);
        }
        catch (FactoryException e) {
            throw new RuntimeException("Could not decode CRS: " + s, e);
        }
    }

    private ReferencedEnvelope toEnvelope(List<Double> box, CoordinateReferenceSystem crs) {
        int size = box.size();
        if (size == 4) {
            return new ReferencedEnvelope(box.get(0).doubleValue(), box.get(2).doubleValue(), box.get(1).doubleValue(), box.get(3).doubleValue(), crs);
        }
        if (size == 6) {
            return new ReferencedEnvelope3D(box.get(0).doubleValue(), box.get(3).doubleValue(), box.get(1).doubleValue(), box.get(4).doubleValue(), box.get(2).doubleValue(), box.get(5).doubleValue(), crs);
        }
        LOGGER.log(Level.FINE, "Don't know how to represent a bounding box with " + size + " ordinates, skipping");
        return null;
    }
}

