/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import java.util.List;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.stac.client.CQL2Conformance;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.temporal.BinaryTemporalOperator;

class CQL2PostPreFilterSplitter
extends PostPreProcessFilterSplittingVisitor {
    private final boolean forcePropertyLiteral;

    private static FilterCapabilities buildFilterCapabilities(List<String> conformance) {
        FilterCapabilities caps = new FilterCapabilities();
        for (CQL2Conformance cc : CQL2Conformance.values()) {
            if (!cc.matches(conformance)) continue;
            caps.addAll(cc.getCapabilities());
        }
        return caps;
    }

    public CQL2PostPreFilterSplitter(List<String> conformance) {
        super(CQL2PostPreFilterSplitter.buildFilterCapabilities(conformance), null, null);
        this.forcePropertyLiteral = !CQL2Conformance.PROPERTY_PROPERTY.matches(conformance);
    }

    public Object visit(BBOX filter, Object notUsed) {
        if (!(!this.forcePropertyLiteral || filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal)) {
            this.postStack.push(filter);
            return null;
        }
        return super.visit(filter, notUsed);
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        if (!(!this.forcePropertyLiteral || filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal)) {
            this.postStack.push(filter);
            return;
        }
        super.visitBinaryComparisonOperator(filter);
    }

    protected void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        if (!(!this.forcePropertyLiteral || filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal)) {
            this.postStack.push(filter);
            return;
        }
        super.visitBinarySpatialOperator(filter);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        if (!(!this.forcePropertyLiteral || filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal)) {
            this.postStack.push(filter);
            return data;
        }
        return super.visit(filter, data);
    }
}

