/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.geotools.data.geojson.PagingFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.http.HTTPClient;
import org.geotools.stac.client.STACGeoJSONReader;

class STACPagingFeatureCollection
extends PagingFeatureCollection {
    private final HTTPClient http;

    public STACPagingFeatureCollection(SimpleFeatureCollection first, ObjectNode next, Integer matched, HTTPClient http) {
        super(first, next, matched);
        this.http = http;
    }

    protected SimpleFeatureCollection readNext(ObjectNode next) throws IOException {
        if (next == null) {
            return null;
        }
        JsonNode href = next.get("href");
        if (href == null) {
            return null;
        }
        LOGGER.fine(() -> "Fetching next page of data at " + href.textValue());
        try (InputStream is = this.http.get(new URL(href.textValue())).getResponseStream();){
            SimpleFeatureCollection simpleFeatureCollection;
            try (STACGeoJSONReader reader = new STACGeoJSONReader(is, this.http);){
                simpleFeatureCollection = reader.getFeatures();
            }
            return simpleFeatureCollection;
        }
    }
}

