/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.api.feature.type.Name;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.stac.client.STACClient;
import org.geotools.stac.store.STACFeatureSource;
import org.geotools.util.logging.Logging;

public class STACDataStore
extends ContentDataStore {
    static final int DEFAULT_FETCH_SIZE = 1000;
    static final int DEFAULT_FEATURE_TYPE_ITEMS = 100;
    static final Integer DEFAULT_HARD_LIMIT = 10000;
    static final Logger LOGGER = Logging.getLogger(STACDataStore.class);
    private final STACClient client;
    private STACClient.SearchMode searchMode = STACClient.SearchMode.GET;
    private int fetchSize = 1000;
    private Integer hardLimit = DEFAULT_HARD_LIMIT;
    private int featureTypeItems = 100;

    public STACDataStore(STACClient client) {
        this.client = client;
    }

    public STACClient.SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(STACClient.SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    protected List<Name> createTypeNames() throws IOException {
        return this.client.getCollections().stream().map(c -> new NameImpl(this.namespaceURI, c.getId())).collect(Collectors.toList());
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        return new STACFeatureSource(entry, this.client);
    }

    public void dispose() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to cleanly close the STAC client", e);
        }
    }

    public void setHardLimit(int hardLimit) {
        this.hardLimit = hardLimit;
    }

    public int getHardLimit() {
        return this.hardLimit;
    }

    public int getFeatureTypeItems() {
        return this.featureTypeItems;
    }

    public void setFeatureTypeItems(int featureTypeItems) {
        this.featureTypeItems = featureTypeItems;
    }

    public STACClient getClient() {
        return this.client;
    }
}

