/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.process;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.geotools.data.Parameter;
import org.geotools.process.ProcessFactory;
import org.geotools.swing.process.ProcessRunPage;
import org.geotools.swing.wizard.JDoubleField;
import org.geotools.swing.wizard.JField;
import org.geotools.swing.wizard.JGeometryField;
import org.geotools.swing.wizard.JPage;
import org.geotools.swing.wizard.ParamField;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.Name;

public class ProcessParameterPage
extends JPage {
    ProcessFactory factory;
    Name name;
    Map<String, Object> input;
    Map<String, List<ParamField>> fields = new HashMap<String, List<ParamField>>();
    Map<String, Object> paramMap = null;

    public ProcessParameterPage(ProcessFactory factory) {
        this(factory, null);
    }

    public ProcessParameterPage(ProcessFactory factory, Map<String, Object> input) {
        super("Enter Params");
        this.factory = factory;
    }

    public void setProcessFactory(ProcessFactory factory) {
        this.factory = factory;
    }

    public ProcessFactory getProcessFactory() {
        return this.factory;
    }

    @Override
    public String getBackPageIdentifier() {
        return "select";
    }

    @Override
    public String getNextPageIdentifier() {
        this.createParamMap();
        ProcessRunPage resultPage = new ProcessRunPage(this.factory, this.paramMap);
        this.getJWizard().registerWizardPanel(resultPage);
        return resultPage.getPageIdentifier();
    }

    private void createParamMap() {
        if (this.fields.isEmpty()) {
            return;
        }
        this.paramMap = new HashMap<String, Object>();
        for (String key : this.fields.keySet()) {
            List<ParamField> pws = this.fields.get(key);
            if (pws.size() > 1) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (ParamField pw : pws) {
                    if (pw.getValue() == null) continue;
                    values.add(pw.getValue());
                }
                this.paramMap.put(key, values);
                continue;
            }
            ParamField ParamField2 = pws.get(0);
            if (ParamField2.getValue() == null) continue;
            this.paramMap.put(key, ParamField2.getValue());
        }
    }

    @Override
    public void preDisplayPanel() {
        JPanel page = this.getPanel();
        page.removeAll();
        page.setLayout(new GridLayout(0, 2));
        JLabel title = new JLabel(this.factory.getTitle().toString());
        page.add(title);
        JLabel description = new JLabel(this.factory.getDescription(this.name).toString());
        page.add(description);
        for (Map.Entry entry : this.factory.getParameterInfo(this.name).entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            int min = parameter.minOccurs;
            if (min < 1) {
                min = 1;
            }
            if (parameter.maxOccurs == -1) {
                this.createAddButton(parameter);
            }
            ArrayList<ParamField> widgets = new ArrayList<ParamField>();
            for (int i = 0; i < min; ++i) {
                ParamField newWidget = this.createNewField(parameter, true);
                widgets.add(newWidget);
            }
            this.fields.put(parameter.key, widgets);
        }
    }

    private void createAddButton(Parameter<?> parameter) {
        JPanel page = this.getPanel();
        JLabel buttLabel = new JLabel("Press '+' to add a new " + String.valueOf(parameter.title) + " field: ");
        page.add(buttLabel);
        JButton butt = new JButton("+");
        butt.addActionListener(e -> this.createNewField(parameter, true));
        page.add(butt);
    }

    private ParamField createNewField(Parameter<?> parameter, boolean resize) {
        JPanel page = this.getPanel();
        JLabel label = new JLabel(parameter.title.toString());
        page.add(label);
        ParamField widget = Double.class.isAssignableFrom(parameter.type) ? new JDoubleField(parameter) : (Geometry.class.isAssignableFrom(parameter.type) ? new JGeometryField(parameter) : new JField(parameter));
        JComponent field = ((ParamField)widget).doLayout();
        page.add(field);
        page.validate();
        if (resize) {
            this.getJWizard().pack();
            this.getJWizard().validate();
        }
        return widget;
    }
}

