/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.styling;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.StyleFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class JFontChooser
extends JDialog {
    private static final long serialVersionUID = -1543116265293436599L;
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static final String[] families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final String[] styles = new String[]{"Normal", "Italic"};
    private static final String[] weights = new String[]{"Normal", "Bold"};
    private static final Integer[] sizes = new Integer[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 28, 32, 36, 48, 72};
    private static final String sampleText = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n0123456789\nThe quick brown fox jumped over the lazy dog";
    private static final int sampleTextLines = 4;
    private JComboBox<String> familyCBox;
    private JComboBox<String> styleCBox;
    private JComboBox<String> weightCBox;
    private JComboBox<Integer> sizeCBox;
    private JTextArea textArea;
    private int familyIndex;
    private int weightIndex;
    private int styleIndex;
    private int sizeIndex;
    private org.geotools.styling.Font selectedFont = null;
    private boolean completed = false;

    public static org.geotools.styling.Font showDialog(Component owner, String title, org.geotools.styling.Font labelFont) {
        JFontChooser chooser = null;
        org.geotools.styling.Font font = null;
        if (owner == null) {
            chooser = new JFontChooser((JFrame)null, title, labelFont);
        } else {
            Class<?> ownerClass = owner.getClass();
            if (JDialog.class.isAssignableFrom(ownerClass)) {
                chooser = new JFontChooser((JDialog)owner, title, labelFont);
            } else if (JFrame.class.isAssignableFrom(ownerClass)) {
                chooser = new JFontChooser((JFrame)owner, title, labelFont);
            } else {
                throw new IllegalArgumentException("owner must be a JFrame or JDialog object");
            }
        }
        chooser.setVisible(true);
        if (chooser.completed()) {
            font = chooser.getSelectedFont();
        }
        return font;
    }

    public JFontChooser(JFrame owner, String title, org.geotools.styling.Font initialFont) {
        super(owner, title, true);
        this.setResizable(false);
        this.selectedFont = initialFont == null ? sf.getDefaultFont() : initialFont;
        this.initFont();
        this.initComponents();
    }

    public JFontChooser(JDialog owner, String title, org.geotools.styling.Font initialFont) {
        super(owner, title, true);
        this.setResizable(false);
        this.selectedFont = initialFont == null ? sf.getDefaultFont() : initialFont;
        this.initFont();
        this.initComponents();
    }

    public boolean completed() {
        return this.completed;
    }

    public org.geotools.styling.Font getSelectedFont() {
        return this.selectedFont;
    }

    private void initComponents() {
        MigLayout layout = new MigLayout();
        JPanel panel = new JPanel((LayoutManager)layout);
        JLabel label = new JLabel("Family");
        panel.add(label);
        this.familyCBox = new JComboBox<String>(families);
        this.familyCBox.setSelectedIndex(this.familyIndex);
        this.familyCBox.addActionListener(e -> {
            this.familyIndex = this.familyCBox.getSelectedIndex();
            this.showSample();
        });
        panel.add(this.familyCBox);
        label = new JLabel("Style");
        panel.add(label);
        this.styleCBox = new JComboBox<String>(styles);
        this.styleCBox.setSelectedIndex(this.styleIndex);
        this.styleCBox.addActionListener(e -> {
            this.styleIndex = this.styleCBox.getSelectedIndex();
            this.showSample();
        });
        panel.add(this.styleCBox);
        label = new JLabel("Weight");
        panel.add(label);
        this.weightCBox = new JComboBox<String>(weights);
        this.weightCBox.setSelectedIndex(this.weightIndex);
        this.weightCBox.addActionListener(e -> {
            this.weightIndex = this.weightCBox.getSelectedIndex();
            this.showSample();
        });
        panel.add(this.weightCBox);
        label = new JLabel("Size");
        panel.add(label);
        this.sizeCBox = new JComboBox<Integer>(sizes);
        this.sizeCBox.setSelectedIndex(this.sizeIndex);
        this.sizeCBox.addActionListener(e -> {
            this.sizeIndex = this.sizeCBox.getSelectedIndex();
            this.showSample();
        });
        panel.add(this.sizeCBox, "wrap");
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setText(sampleText);
        this.textArea.setRows(4);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        panel.add((Component)scrollPane, "span, height 200, growx");
        JButton btn = new JButton("Apply");
        btn.addActionListener(e -> {
            this.completed = true;
            this.createSelectedFont();
            this.setVisible(false);
        });
        panel.add((Component)btn, "span, split 2, align right");
        btn = new JButton("Cancel");
        btn.addActionListener(e -> {
            this.selectedFont = null;
            this.setVisible(false);
        });
        panel.add(btn);
        this.getContentPane().add(panel);
        this.pack();
    }

    private void initFont() {
        int index;
        block0: for (Expression family : this.selectedFont.getFamily()) {
            String familyName = ((Literal)family).getValue().toString();
            for (index = 0; index < families.length; ++index) {
                if (!families[index].equalsIgnoreCase(familyName)) continue;
                this.familyIndex = index;
                continue block0;
            }
        }
        String styleName = ((Literal)this.selectedFont.getStyle()).getValue().toString();
        for (int index2 = 0; index2 < styles.length; ++index2) {
            if (!styles[index2].equalsIgnoreCase(styleName)) continue;
            this.styleIndex = index2;
            break;
        }
        String weightName = ((Literal)this.selectedFont.getWeight()).getValue().toString();
        for (int index3 = 0; index3 < weights.length; ++index3) {
            if (!weights[index3].equalsIgnoreCase(weightName)) continue;
            this.weightIndex = index3;
            break;
        }
        int size = ((Number)((Literal)this.selectedFont.getSize()).getValue()).intValue();
        this.sizeIndex = sizes.length - 1;
        for (index = 0; index < sizes.length; ++index) {
            if (sizes[index] < size) continue;
            this.sizeIndex = index;
            break;
        }
    }

    private void showSample() {
        StringBuilder sb = new StringBuilder(families[this.familyIndex]);
        if (this.weightIndex == 0) {
            if (this.styleIndex == 0) {
                sb.append("-PLAIN-");
            } else {
                sb.append("-ITALIC-");
            }
        } else if (this.styleIndex == 0) {
            sb.append("-BOLD");
        } else {
            sb.append("-BOLDITALIC-");
        }
        sb.append(sizes[this.sizeIndex]);
        Font sampleFont = Font.decode(sb.toString());
        this.textArea.setFont(sampleFont);
    }

    private void createSelectedFont() {
        this.selectedFont = sf.createFont((Expression)ff.literal((Object)families[this.familyIndex]), (Expression)ff.literal((Object)styles[this.styleIndex]), (Expression)ff.literal((Object)weights[this.weightIndex]), (Expression)ff.literal((Object)String.valueOf(sizes[this.sizeIndex])));
    }
}

