/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.swing.dialog.JTextReporter;
import org.geotools.swing.dialog.TextReporterListener;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.locale.LocaleUtils;
import org.geotools.swing.tool.CursorTool;
import org.geotools.swing.tool.InfoToolHelper;
import org.geotools.swing.tool.InfoToolHelperLookup;
import org.geotools.swing.tool.InfoToolResult;
import org.geotools.util.logging.Logging;

public class InfoTool
extends CursorTool
implements TextReporterListener {
    private static final Logger LOGGER = Logging.getLogger(InfoTool.class);
    public static final String TOOL_NAME = LocaleUtils.getValue("CursorTool", "Info");
    public static final String TOOL_TIP = LocaleUtils.getValue("CursorTool", "InfoTooltip");
    public static final String CURSOR_IMAGE = "/org/geotools/swing/icons/mActionIdentify.png";
    public static final Point CURSOR_HOTSPOT = new Point(0, 0);
    public static final String ICON_IMAGE = "/org/geotools/swing/icons/mActionIdentify.png";
    private Cursor cursor;
    private WeakHashMap<Layer, InfoToolHelper> helperTable;
    private JTextReporter.Connection textReporterConnection;

    public InfoTool() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageIcon cursorIcon = new ImageIcon(this.getClass().getResource("/org/geotools/swing/icons/mActionIdentify.png"));
        this.cursor = tk.createCustomCursor(cursorIcon.getImage(), CURSOR_HOTSPOT, TOOL_TIP);
        this.helperTable = new WeakHashMap();
    }

    @Override
    public void onMouseClicked(MapMouseEvent ev) {
        DirectPosition2D pos = ev.getWorldPos();
        this.createReporter();
        this.report(pos);
        MapContent content = this.getMapPane().getMapContent();
        int nlayers = content.layers().size();
        int n = 0;
        for (Layer layer : content.layers()) {
            InfoToolHelper helper;
            if (!layer.isSelected()) continue;
            String layerName = layer.getTitle();
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getName().getLocalPart();
            }
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getSchema().getName().getLocalPart();
            }
            if ((helper = this.helperTable.get(layer)) == null) {
                helper = InfoToolHelperLookup.getHelper(layer);
                if (helper == null) {
                    LOGGER.log(Level.WARNING, "InfoTool cannot query {0}", layer.getClass().getName());
                    return;
                }
                helper.setMapContent(content);
                helper.setLayer(layer);
            }
            try {
                InfoToolResult result = helper.getInfo(pos);
                this.textReporterConnection.append(layerName + "\n");
                this.textReporterConnection.append(result.toString(), 4);
                if (++n >= nlayers) continue;
                this.textReporterConnection.append("\n");
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Unable to query layer {0}", layerName);
            }
        }
        this.textReporterConnection.appendSeparatorLine(10, '-');
        this.textReporterConnection.appendNewline();
    }

    public JTextReporter.Connection getTextReporterConnection() {
        return this.textReporterConnection;
    }

    private void report(DirectPosition2D pos) {
        this.textReporterConnection.append(String.format("Pos x=%.4f y=%.4f\n", pos.x, pos.y));
    }

    private void createReporter() {
        if (this.textReporterConnection == null) {
            this.textReporterConnection = JTextReporter.showDialog("Feature info", null, 6, 20, 40);
            this.textReporterConnection.addListener(this);
        }
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean drawDragBox() {
        return false;
    }

    @Override
    public void onReporterClosed() {
        this.textReporterConnection = null;
    }

    @Override
    public void onReporterUpdated() {
    }
}

