/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import org.geotools.api.coverage.PointOutsideCoverageException;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.parameter.Parameter;
import org.geotools.swing.tool.InfoToolHelper;
import org.geotools.swing.tool.InfoToolHelperUtils;
import org.geotools.swing.tool.InfoToolResult;
import org.geotools.util.SuppressFBWarnings;

public class GridReaderLayerHelper
extends InfoToolHelper {
    private static final int CACHED_RASTER_WIDTH = 20;
    private WeakReference<GridCoverage2DReader> sourceRef;
    private GridCoverage2D cachedCoverage;

    @Override
    public boolean isSupportedLayer(Layer layer) {
        return layer instanceof GridReaderLayer;
    }

    @Override
    public void setLayer(Layer layer) {
        if (!(layer instanceof GridReaderLayer)) {
            throw new IllegalArgumentException("layer must be an instance of GridReaderLayer");
        }
        super.setLayer(layer);
        this.sourceRef = new WeakReference<GridCoverage2DReader>(((GridReaderLayer)layer).getReader());
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.sourceRef != null && this.sourceRef.get() != null;
    }

    @Override
    public InfoToolResult getInfo(Position2D pos) throws Exception {
        InfoToolResult result = new InfoToolResult();
        if (this.isValid()) {
            Position2D trPos = InfoToolHelperUtils.getTransformed(pos, this.getContentToLayerTransform());
            if (!(this.cachedCoverage != null && this.cachedCoverage.getEnvelope2D().contains((Position)trPos) || this.renewCachedCoverage((Position)trPos))) {
                return result;
            }
            try {
                Object objArray = this.cachedCoverage.evaluate((Position)trPos);
                Number[] bandValues = InfoToolHelperUtils.asNumberArray(objArray);
                if (bandValues != null) {
                    result.newFeature("Raw values");
                    for (int i = 0; i < bandValues.length; ++i) {
                        result.setFeatureValue("Band " + i, (Object)bandValues[i]);
                    }
                }
            }
            catch (PointOutsideCoverageException pointOutsideCoverageException) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean renewCachedCoverage(Position centrePos) {
        Rectangle queryRect = this.createQueryGridEnvelope(centrePos);
        if (queryRect.isEmpty()) {
            return false;
        }
        GridCoverage2DReader reader = (GridCoverage2DReader)this.sourceRef.get();
        if (reader == null) {
            return false;
        }
        Parameter parameter = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D, (Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(queryRect), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem()));
        try {
            this.cachedCoverage = reader.read(new GeneralParameterValue[]{parameter});
            return this.cachedCoverage != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private Rectangle createQueryGridEnvelope(Position pos) {
        GridCoverage2DReader reader = (GridCoverage2DReader)this.sourceRef.get();
        if (reader == null) {
            throw new NullPointerException("Source refererence returned a null reader");
        }
        try {
            MathTransform worldToGridTransform = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse();
            Position midPos = worldToGridTransform.transform(pos, null);
            int x = (int)midPos.getOrdinate(0);
            int y = (int)midPos.getOrdinate(1);
            int halfWidth = 10;
            Rectangle queryRect = new Rectangle(x - halfWidth, y - halfWidth, 20, 20);
            GridEnvelope gridEnv = reader.getOriginalGridRange();
            Rectangle rect = new Rectangle(gridEnv.getLow(0), gridEnv.getLow(1), gridEnv.getSpan(0), gridEnv.getSpan(1));
            XRectangle2D.intersect((Rectangle2D)queryRect, (Rectangle2D)rect, (Rectangle2D)queryRect);
            return queryRect;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

